//////////////////////////////////////////////////////////////////////////////
// deKoratorconfig.cc
// -------------------
// DeKorator window decoration for KDE
// -------------------
// Autor: moty rahamim
// Email: moty.rahamim@gmail.com
// Based on Example-0.8 by David Johnson <david@usermode.org>
// some ideas and code have been taken from plastik and KCMicons
//////////////////////////////////////////////////////////////////////////////



#include "deKoratorclient.h"


using namespace DeKorator;

// global constants

//static int BUTTONSIZE = 24;
static int MARGIN = 4;
//bool captionBufferDirty_ = true;

// frames
static int TITLESIZE = 0;
static int LEFTFRAMESIZE = 0;
static int BUTTOMFRAMESIZE = 0;
static int RIGHTFRAMESIZE = 0;

// deco
static int TOPLEFTCORNERWIDTH;
static int TOPRIGHTCORNERWIDTH;
static int LEFTTITLEWIDTH;
static int RIGHTTITLEWIDTH;
static int TOPLEFTFRAMEHEIGHT;
static int BOTTOMLEFTFRAMEHEIGHT;
static int TOPRIGHTFRAMEHEIGHT;
static int BOTTOMRIGHTFRAMEHEIGHT;
static int LEFTBOTTOMFRAMEWIDTH;
static int RIGHTBOTTOMFRAMEWIDTH;

// buttons
//static const int DECOSIZE = 24;

static int BUTTONSHEIGHT = 0;

static int BTNHELPEWIDTH = 0;
static int BTNMAXWIDTH = 0;
static int BTNCLOSEWIDTH = 0;
static int BTNMINWIDTH = 0;
static int BTNSTICKYWIDTH = 0;
static int BTNABOVEWIDTH = 0;
static int BTNBELOWWIDTH = 0;
static int BTNSHADEWIDTH = 0;
static int BTNMENUWIDTH = 0;

static int BTNHELPEHEIGHT = 0;
static int BTNMAXHEIGHT = 0;
static int BTNCLOSEHEIGHT = 0;
static int BTNMINHEIGHT = 0;
static int BTNSTICKYHEIGHT = 0;
static int BTNABOVEHEIGHT = 0;
static int BTNBELOWHEIGHT = 0;
static int BTNSHADEHEIGHT = 0;
static int BTNMENUHEIGHT = 0;

// config
// misc
static Qt::AlignmentFlags TITLEALIGN = Qt::AlignHCenter;
static bool USEMENUEIMAGE = FALSE;
static bool DBLCLKCLOSE = FALSE;
static bool SHOWBTMBORDER = FALSE;
static bool USESHDTEXT = FALSE;
static int ACTIVESHDTEXTX = FALSE;
static int ACTIVESHDTEXTY = FALSE;
static QColor ACTIVESHADECOLOR = QColor( 150, 150, 150 );
static int INACTIVESHDTEXTX = FALSE;
static int INACTIVESHDTEXTY = FALSE;
static QColor INACTIVESHADECOLOR = QColor( 150, 150, 150 );
static int BTNSHIFTX = 0;
static int BTNSHIFTY = 0;


// colors

static bool USEANIMATION = TRUE;
static QString ANIMATIONTYPE = "Intensity";
static QString BUTTONHOVERTYPE = "To Gray";
static float EFFECTAMOUNT = 5;
static QColor ACTIVEHIGHLIGHTCOLOR = QColor( 150, 150, 150 );
static QColor INACTIVEHIGHLIGHTCOLOR = QColor( 150, 150, 150 );
static QString DECOCOLORIZE = "Liquid Method";
static QString BUTTONSCOLORIZE = "Liquid Method";
static QString BUTTONSHOVERCOLORIZE = "Liquid Method";
static const uint TIMERINTERVAL = 30; // msec
static const uint ANIMATIONSTEPS = 100;

// paths
static bool USEMASKS = FALSE;



//////////////////////////////////////////////////////////////////////////////
// DeKoratorFactory Class                                                     //
//////////////////////////////////////////////////////////////////////////////

bool DeKoratorFactory::initialized_ = FALSE;
bool DeKoratorFactory::colorizeFrames_ = FALSE;
bool DeKoratorFactory::colorizeButtons_ = FALSE;
bool DeKoratorFactory::needInit_ = FALSE;
QString DeKoratorFactory::framesPath_ = "";
QString DeKoratorFactory::buttonsPath_ = "";
QString DeKoratorFactory::masksPath_ = "";


extern "C" KDecorationFactory* create_factory()
{
    return new DeKorator::DeKoratorFactory();
}

//////////////////////////////////////////////////////////////////////////////
// DeKoratorFactory()
// ----------------
// Constructor

DeKoratorFactory::DeKoratorFactory()
{
    //captionBufferDirty_ = true;
    readConfig();
    initialized_ = TRUE;
    loadPixmaps();
    bool isActive = false;
    colorizeDecoPixmaps( isActive );
    colorizeButtonsPixmaps( false );

    if ( DeKoratorFactory::colorizeFrames_ )
    {
        isActive = true;
        colorizeDecoPixmaps( isActive );
    }
    if ( DeKoratorFactory::colorizeButtons_ )
        colorizeButtonsPixmaps( true );
}

//////////////////////////////////////////////////////////////////////////////
// ~DeKoratorFactory()
// -----------------
// Destructor

DeKoratorFactory::~DeKoratorFactory() { initialized_ = FALSE; }

//////////////////////////////////////////////////////////////////////////////
// createDecoration()
// -----------------
// Create the decoration

KDecoration* DeKoratorFactory::createDecoration( KDecorationBridge* b )
{
    return new DeKoratorClient( b, this );
}

//////////////////////////////////////////////////////////////////////////////
// reset()
// -------
// Reset the handler. Returns TRUE if decorations need to be remade, FALSE if
// only a repaint is necessary

bool DeKoratorFactory::reset( unsigned long changed )
{
    //    captionBufferDirty_ = true;
    // read in the configuration
    initialized_ = FALSE;
    bool confchange = readConfig();
    initialized_ = TRUE;


    if ( confchange ||
            ( changed & ( SettingDecoration | SettingButtons | SettingBorder | SettingColors ) ) )
    {
        if ( changed & SettingColors || DeKoratorFactory::needInit_ )
        {
            loadPixmaps();
            bool isActive = false;
            colorizeDecoPixmaps( isActive );
            colorizeButtonsPixmaps( false );

            if ( DeKoratorFactory::colorizeFrames_ )
            {
                isActive = true;
                colorizeDecoPixmaps( isActive );
            }
            if ( DeKoratorFactory::colorizeButtons_ )
                colorizeButtonsPixmaps( true );
        }
        return TRUE;
    }
    else
    {
        resetDecorations( changed );
        return FALSE;
    }
}

//////////////////////////////////////////////////////////////////////////////
// readConfig()
// ------------
// Read in the configuration file

bool DeKoratorFactory::readConfig()
{
    // create a config object
    KConfig config( "kwindeKoratorrc" );
    QColor col = QColor( 150, 150, 150 );

    // grab settings

    // misc settings
    config.setGroup( "MISC" );

    Qt::AlignmentFlags oldalign = TITLEALIGN;
    QString value = config.readEntry( "TitleAlignment", "AlignHCenter" );
    if ( value == "AlignLeft" ) TITLEALIGN = Qt::AlignLeft;
    else if ( value == "AlignHCenter" ) TITLEALIGN = Qt::AlignHCenter;
    else if ( value == "AlignRight" ) TITLEALIGN = Qt::AlignRight;

    bool oldUseMenuImage = USEMENUEIMAGE;
    USEMENUEIMAGE = config.readBoolEntry( "UseMenuImage", "false" );

    bool oldDblClkClose = DBLCLKCLOSE;
    DBLCLKCLOSE = config.readBoolEntry( "DblClkClose", "false" );

    bool oldShowBtmBorder = SHOWBTMBORDER;
    SHOWBTMBORDER = config.readBoolEntry( "ShowBtmBorder", "false" );

    bool oldUseShdtext = USESHDTEXT;
    USESHDTEXT = config.readBoolEntry( "UseShdtext", "false" );

    int oldActiveShdtextX = ACTIVESHDTEXTX;
    ACTIVESHDTEXTX = config.readNumEntry( "ActiveShdtextX", 0 );

    int oldActiveShdtextY = ACTIVESHDTEXTY;
    ACTIVESHDTEXTY = config.readNumEntry( "ActiveShdtextY", 0 );

    QColor oldActiveShadeColor = ACTIVESHADECOLOR;
    ACTIVESHADECOLOR = config.readColorEntry( "ActiveShadowColor", &col );

    int oldInActiveShdtextX = INACTIVESHDTEXTX;
    INACTIVESHDTEXTX = config.readNumEntry( "InActiveShdtextX", 0 );

    int oldInActiveShdtextY = INACTIVESHDTEXTY;
    INACTIVESHDTEXTY = config.readNumEntry( "InActiveShdtextY", 0 );

    QColor oldInActiveShadeColor = INACTIVESHADECOLOR;
    INACTIVESHADECOLOR = config.readColorEntry( "InActiveShadowColor", &col );


    int oldBtnShiftX = BTNSHIFTX;
    BTNSHIFTX = config.readNumEntry( "BtnShiftX", 0 );

    int oldBtnShiftY = BTNSHIFTY;
    BTNSHIFTY = config.readNumEntry( "BtnShiftY", 0 );


    // color's settings
    config.setGroup( "COLORS" );

    bool oldColorizeFrames = DeKoratorFactory::colorizeFrames_;
    DeKoratorFactory::colorizeFrames_ = config.readBoolEntry( "ColorizeFrames", "false" );

    bool oldColorizeButtons = DeKoratorFactory::colorizeButtons_;
    DeKoratorFactory::colorizeButtons_ = config.readBoolEntry( "ColorizeButtons", "false" );

    USEANIMATION = config.readBoolEntry( "UseAnimation", "false" );

    ANIMATIONTYPE = config.readEntry( "AnimationType", "Intensity" );

    BUTTONHOVERTYPE = config.readEntry( "ButtonsHoverType", "To Gray" );

    EFFECTAMOUNT = ( ( float ) config.readNumEntry( "EffectAmount", 5 ) / 10 );

    ACTIVEHIGHLIGHTCOLOR = config.readColorEntry( "ActiveHighlightColor", &col );

    INACTIVEHIGHLIGHTCOLOR = config.readColorEntry( "InActiveHighlightColor", &col );

    QString oldDecoColorize = DECOCOLORIZE;
    DECOCOLORIZE = config.readEntry( "DecoColorize", "Liquid Method" );

    QString oldButtonsColorize = BUTTONSCOLORIZE;
    BUTTONSCOLORIZE = config.readEntry( "ButtonsColorize", "Liquid Method" );

    QString oldButtonsHoverColorize = BUTTONSHOVERCOLORIZE;
    BUTTONSHOVERCOLORIZE = config.readEntry( "ButtonsHoverColorize", "Liquid Method" );


    // path's settings
    config.setGroup( "PATHS" );

    QString oldFramesPath = DeKoratorFactory::framesPath_;
    DeKoratorFactory::framesPath_ = config.readEntry( "FramesPath", "" );

    QString oldButtonsPath = DeKoratorFactory::buttonsPath_;
    DeKoratorFactory::buttonsPath_ = config.readEntry( "ButtonsPath", "" );

    bool oldUseMasks = USEMASKS;
    USEMASKS = config.readBoolEntry( "UseMasks", "false" );

    QString oldMasksPath = DeKoratorFactory::masksPath_;
    DeKoratorFactory::masksPath_ = config.readEntry( "MasksPath", "" );


    if ( oldalign == TITLEALIGN &&
            oldUseMenuImage == USEMENUEIMAGE &&
            oldShowBtmBorder == SHOWBTMBORDER &&
            oldUseShdtext == USESHDTEXT &&
            oldActiveShdtextX == ACTIVESHDTEXTX &&
            oldActiveShdtextY == ACTIVESHDTEXTY &&
            oldActiveShadeColor == ACTIVESHADECOLOR &&
            oldInActiveShdtextX == INACTIVESHDTEXTX &&
            oldInActiveShdtextY == INACTIVESHDTEXTY &&
            oldInActiveShadeColor == INACTIVESHADECOLOR &&
            oldBtnShiftX == BTNSHIFTX &&
            oldBtnShiftY == BTNSHIFTY &&
            oldColorizeFrames == DeKoratorFactory::colorizeFrames_ &&
            oldColorizeButtons == DeKoratorFactory::colorizeButtons_ &&
            oldDecoColorize == DECOCOLORIZE &&
            oldButtonsColorize == BUTTONSCOLORIZE &&
            oldButtonsHoverColorize == BUTTONSHOVERCOLORIZE &&
            oldFramesPath == DeKoratorFactory::framesPath_ &&
            oldButtonsPath == DeKoratorFactory::buttonsPath_ &&
            oldMasksPath == DeKoratorFactory::masksPath_ &&
            oldUseMasks == USEMASKS )
        return FALSE;
    else
    {
        if ( oldColorizeFrames != DeKoratorFactory::colorizeFrames_ ||
                oldColorizeButtons != DeKoratorFactory::colorizeButtons_ ||
                ( oldDecoColorize != DECOCOLORIZE /*&& DeKoratorFactory::colorizeFrames_*/ ) ||
                ( oldButtonsColorize != BUTTONSCOLORIZE && DeKoratorFactory::colorizeButtons_ ) ||
                oldFramesPath != DeKoratorFactory::framesPath_ ||
                oldButtonsPath != DeKoratorFactory::buttonsPath_ ||
                oldMasksPath != DeKoratorFactory::masksPath_ ||
                oldUseMasks != USEMASKS
           )
            DeKoratorFactory::needInit_ = TRUE;
        else
            DeKoratorFactory::needInit_ = FALSE;
        return TRUE;
    }
}

//////////////////////////////////////////////////////////////////////////////
// loadPixmaps()
// ------------
// Read in the configuration file

void DeKoratorFactory::loadPixmaps()
{
    QString decoPixDir = DeKoratorFactory::framesPath_;
    QString btnPixDir = DeKoratorFactory::buttonsPath_;
    QString masksPixDir = DeKoratorFactory::masksPath_;

    // deco
    // top bar from left to right
    topLeftCornerBg_.load( decoPixDir + "/topLeftCornerBg.png" );
    topLeftCornerBgInAct_ = topLeftCornerBg_;
    leftButtonsBg_.load( decoPixDir + "/leftButtonsBg.png" );
    leftButtonsBgInAct_ = leftButtonsBg_;
    leftTitleBg_.load( decoPixDir + "/leftTitleBg.png" );
    leftTitleBgInAct_ = leftTitleBg_;
    midTitleBg_.load( decoPixDir + "/midTitleBg.png" );
    midTitleBgInAct_ = midTitleBg_;
    rightTitleBg_.load( decoPixDir + "/rightTitleBg.png" );
    rightTitleBgInAct_ = rightTitleBg_;
    rightButtonsBg_.load( decoPixDir + "/rightButtonsBg.png" );
    rightButtonsBgInAct_ = rightButtonsBg_;
    topRightCornerBg_.load( decoPixDir + "/topRightCornerBg.png" );
    topRightCornerBgInAct_ = topRightCornerBg_;
    // left frame from top to buttom
    topLeftFrameBg_.load( decoPixDir + "/topLeftFrameBg.png" );
    topLeftFrameBgInAct_ = topLeftFrameBg_;
    midLeftFrameBg_.load( decoPixDir + "/midLeftFrameBg.png" );
    midLeftFrameBgInAct_ = midLeftFrameBg_;
    buttomLeftFrameBg_.load( decoPixDir + "/bottomLeftFrameBg.png" );
    buttomLeftFrameBgInAct_ = buttomLeftFrameBg_;
    // buttom frame from left to right
    leftButtomFrameBg_.load( decoPixDir + "/leftBottomFrameBg.png" );
    leftButtomFrameBgInAct_ = leftButtomFrameBg_;
    midButtomFrameBg_.load( decoPixDir + "/midBottomFrameBg.png" );
    midButtomFrameBgInAct_ = midButtomFrameBg_;
    rightButtomFrameBg_.load( decoPixDir + "/rightBottomFrameBg.png" );
    rightButtomFrameBgInAct_ = rightButtomFrameBg_;
    // right frame from top to buttom
    topRightFrameBg_.load( decoPixDir + "/topRightFrameBg.png" );
    topRightFrameBgInAct_ = topRightFrameBg_;
    midRightFrameBg_.load( decoPixDir + "/midRightFrameBg.png" );
    rightFrameBgInAct_ = midRightFrameBg_;
    buttomRightFrameBg_.load( decoPixDir + "/bottomRightFrameBg.png" );
    buttomRightFrameBgInAct_ = buttomRightFrameBg_;



    // buttons
    buttonRestorePix_.load( btnPixDir + "/normal/buttonRestore.png" );
    buttonRestorePressPix_.load( btnPixDir + "/press/buttonRestorePress.png" );
    buttonRestoreHoverPix_.load( btnPixDir + "/hover/buttonRestoreHover.png" );
    buttonRestorePixInAct_ = buttonRestorePix_;

    buttonHelpPix_.load( btnPixDir + "/normal/buttonHelp.png" );
    buttonHelpPressPix_.load( btnPixDir + "/press/buttonHelpPress.png" );
    buttonHelpHoverPix_.load( btnPixDir + "/hover/buttonHelpHover.png" );
    buttonHelpPixInAct_ = buttonHelpPix_;

    buttonMaxPix_.load( btnPixDir + "/normal/buttonMax.png" );
    buttonMaxPressPix_.load( btnPixDir + "/press/buttonMaxPress.png" );
    buttonMaxHoverPix_.load( btnPixDir + "/hover/buttonMaxHover.png" );
    buttonMaxPixInAct_ = buttonMaxPix_;

    buttonMinPix_.load( btnPixDir + "/normal/buttonMin.png" );
    buttonMinPressPix_.load( btnPixDir + "/press/buttonMinPress.png" );
    buttonMinHoverPix_.load( btnPixDir + "/hover/buttonMinHover.png" );
    buttonMinPixInAct_ = buttonMinPix_;

    buttonClosePix_.load( btnPixDir + "/normal/buttonClose.png" );
    buttonClosePressPix_.load( btnPixDir + "/press/buttonClosePress.png" );
    buttonCloseHoverPix_.load( btnPixDir + "/hover/buttonCloseHover.png" );
    buttonClosePixInAct_ = buttonClosePix_;

    buttonStickyPix_.load( btnPixDir + "/normal/buttonSticky.png" );
    buttonStickyPressPix_.load( btnPixDir + "/press/buttonStickyPress.png" );
    buttonStickyHoverPix_.load( btnPixDir + "/hover/buttonStickyHover.png" );
    buttonStickyPixInAct_ = buttonStickyPix_;

    buttonStickyDownPix_.load( btnPixDir + "/normal/buttonStickyDown.png" );
    buttonStickyDownPressPix_.load( btnPixDir + "/press/buttonStickyDownPress.png" );
    buttonStickyDownHoverPix_.load( btnPixDir + "/hover/buttonStickyDownHover.png" );
    buttonStickyDownPixInAct_ = buttonStickyDownPix_;

    buttonAbovePix_.load( btnPixDir + "/normal/buttonAbove.png" );
    buttonAbovePressPix_.load( btnPixDir + "/press/buttonAbovePress.png" );
    buttonAboveHoverPix_.load( btnPixDir + "/hover/buttonAboveHover.png" );
    buttonAbovePixInAct_ = buttonAbovePix_;

    buttonAboveDownPix_.load( btnPixDir + "/normal/buttonAboveDown.png" );
    buttonAboveDownPressPix_.load( btnPixDir + "/press/buttonAboveDownPress.png" );
    buttonAboveDownHoverPix_.load( btnPixDir + "/hover/buttonAboveDownHover.png" );
    buttonAboveDownPixInAct_ = buttonAboveDownPix_;

    buttonBelowPix_.load( btnPixDir + "/normal/buttonBelow.png" );
    buttonBelowPressPix_.load( btnPixDir + "/press/buttonBelowPress.png" );
    buttonBelowHoverPix_.load( btnPixDir + "/hover/buttonBelowHover.png" );
    buttonBelowPixInAct_ = buttonBelowPix_;

    buttonBelowDownPix_.load( btnPixDir + "/normal/buttonBelowDown.png" );
    buttonBelowDownPressPix_.load( btnPixDir + "/press/buttonBelowDownPress.png" );
    buttonBelowDownHoverPix_.load( btnPixDir + "/hover/buttonBelowDownHover.png" );
    buttonBelowDownPixInAct_ = buttonBelowDownPix_;

    buttonShadePix_.load( btnPixDir + "/normal/buttonShade.png" );
    buttonShadePressPix_.load( btnPixDir + "/press/buttonShadePress.png" );
    buttonShadeHoverPix_.load( btnPixDir + "/hover/buttonShadeHover.png" );
    buttonShadePixInAct_ = buttonShadePix_;

    buttonShadeDownPix_.load( btnPixDir + "/normal/buttonShadeDown.png" );
    buttonShadeDownPressPix_.load( btnPixDir + "/press/buttonShadeDownPress.png" );
    buttonShadeDownHoverPix_.load( btnPixDir + "/hover/buttonShadeDownHover.png" );
    buttonShadeDownPixInAct_ = buttonShadeDownPix_;

    buttonMenuPix_.load( btnPixDir + "/normal/buttonMenu.png" );
    buttonMenuPressPix_.load( btnPixDir + "/press/buttonMenuPress.png" );
    buttonMenuHoverPix_.load( btnPixDir + "/hover/buttonMenuHover.png" );
    buttonMenuPixInAct_ = buttonMenuPix_;

    //masks
    topLeftCornerBitmap_ = QBitmap( masksPixDir + "/topLeftCornerBitmap.png" );
    topRightCornerBitmap_ = QBitmap( masksPixDir + "/topRightCornerBitmap.png" );
    buttomLeftCornerBitmap_ = QBitmap( masksPixDir + "/buttomLeftCornerBitmap.png" );
    buttomRightCornerBitmap_ = QBitmap( masksPixDir + "/buttomRightCornerBitmap.png" );

    determineSizes();

}

//////////////////////////////////////////////////////////////////////////////
// determineSizes()
// ------------
//
void DeKoratorFactory::determineSizes()
{
    //MARGIN = midButtomFrameBg_.height();

    // frames
    TITLESIZE = midTitleBg_.height();
    LEFTFRAMESIZE = midLeftFrameBg_.width();
    BUTTOMFRAMESIZE = midButtomFrameBg_.height();;
    RIGHTFRAMESIZE = midRightFrameBg_.width();

    TOPLEFTCORNERWIDTH = topLeftCornerBg_.width();
    TOPRIGHTCORNERWIDTH = topRightCornerBg_.width();
    LEFTTITLEWIDTH = leftTitleBg_.width();
    RIGHTTITLEWIDTH = rightTitleBg_.width();
    TOPLEFTFRAMEHEIGHT = topLeftFrameBg_.height();
    BOTTOMLEFTFRAMEHEIGHT = buttomLeftFrameBg_.height();
    TOPRIGHTFRAMEHEIGHT = topRightFrameBg_.height();
    BOTTOMRIGHTFRAMEHEIGHT = buttomRightFrameBg_.height();
    LEFTBOTTOMFRAMEWIDTH = leftButtomFrameBg_.width();
    RIGHTBOTTOMFRAMEWIDTH = rightButtomFrameBg_.width();
    // buttons
    BUTTONSHEIGHT = TITLESIZE;

    BTNHELPEWIDTH = buttonHelpPix_.width();
    BTNMAXWIDTH = buttonMaxPix_.width();
    BTNCLOSEWIDTH = buttonClosePix_.width();
    BTNMINWIDTH = buttonMinPix_.width();
    BTNSTICKYWIDTH = buttonStickyPix_.width();
    BTNABOVEWIDTH = buttonAbovePix_.width();
    BTNBELOWWIDTH = buttonBelowPix_.width();
    BTNSHADEWIDTH = buttonShadePix_.width();
    BTNMENUWIDTH = buttonMenuPix_.width();

    BTNHELPEHEIGHT = buttonHelpPix_.height();
    BTNMAXHEIGHT = buttonMaxPix_.height();
    BTNCLOSEHEIGHT = buttonClosePix_.height();
    BTNMINHEIGHT = buttonMinPix_.height();
    BTNSTICKYHEIGHT = buttonStickyPix_.height();
    BTNABOVEHEIGHT = buttonAbovePix_.height();
    BTNBELOWHEIGHT = buttonBelowPix_.height();
    BTNSHADEHEIGHT = buttonShadePix_.height();
    BTNMENUHEIGHT = buttonMenuPix_.height();

}


//////////////////////////////////////////////////////////////////////////////
// colorizeDecoPixmaps()
// ------------
//
void DeKoratorFactory::colorizeDecoPixmaps( bool isActive )
{
    QColor col = options() ->colorGroup( KDecoration::ColorTitleBar, isActive ).background();

    if ( isActive )
    {
        // top
        colorizePixmap( &topLeftCornerBg_, col, DECOCOLORIZE );
        colorizePixmap( &leftButtonsBg_, col, DECOCOLORIZE );
        colorizePixmap( &leftTitleBg_, col, DECOCOLORIZE );
        colorizePixmap( &midTitleBg_, col, DECOCOLORIZE );
        colorizePixmap( &rightTitleBg_, col, DECOCOLORIZE );
        colorizePixmap( &rightButtonsBg_, col, DECOCOLORIZE );
        colorizePixmap( &topRightCornerBg_, col, DECOCOLORIZE );
        // left
        colorizePixmap( &topLeftFrameBg_, col, DECOCOLORIZE );
        colorizePixmap( &midLeftFrameBg_, col, DECOCOLORIZE );
        colorizePixmap( &buttomLeftFrameBg_, col, DECOCOLORIZE );
        // buttom
        colorizePixmap( &leftButtomFrameBg_, col, DECOCOLORIZE );
        colorizePixmap( &midButtomFrameBg_, col, DECOCOLORIZE );
        colorizePixmap( &rightButtomFrameBg_, col, DECOCOLORIZE );
        // right
        colorizePixmap( &topRightFrameBg_, col, DECOCOLORIZE );
        colorizePixmap( &midRightFrameBg_, col, DECOCOLORIZE );
        colorizePixmap( &buttomRightFrameBg_, col, DECOCOLORIZE );
    }
    else
    {
        // top
        colorizePixmap( &topLeftCornerBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &leftButtonsBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &leftTitleBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &midTitleBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &rightTitleBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &rightButtonsBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &topRightCornerBgInAct_, col, DECOCOLORIZE );
        // left
        colorizePixmap( &topLeftFrameBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &midLeftFrameBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttomLeftFrameBgInAct_, col, DECOCOLORIZE );
        // buttom
        colorizePixmap( &leftButtomFrameBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &midButtomFrameBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &rightButtomFrameBgInAct_, col, DECOCOLORIZE );
        // right
        colorizePixmap( &topRightFrameBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &rightFrameBgInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttomRightFrameBgInAct_, col, DECOCOLORIZE );
    }
}

//////////////////////////////////////////////////////////////////////////////
// colorizeButtonsPixmaps()
// ------------
//
void DeKoratorFactory::colorizeButtonsPixmaps( bool isActive )
{


    if ( isActive )
    {
        QColor col = options() ->colorGroup( KDecoration::ColorButtonBg, isActive ).background();

        colorizePixmap( &buttonRestorePix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonHelpPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonMaxPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonMinPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonClosePix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonStickyPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonStickyDownPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonAbovePix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonAboveDownPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonBelowPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonBelowDownPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonShadePix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonShadeDownPix_, col, BUTTONSCOLORIZE );
        colorizePixmap( &buttonMenuPix_, col, BUTTONSCOLORIZE );
    }
    else
    {
        QColor col = options() ->colorGroup( KDecoration::ColorButtonBg, isActive ).background();

        colorizePixmap( &buttonRestorePixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonHelpPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonMaxPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonMinPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonClosePixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonStickyPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonStickyDownPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonAbovePixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonAboveDownPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonBelowPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonBelowDownPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonShadePixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonShadeDownPixInAct_, col, DECOCOLORIZE );
        colorizePixmap( &buttonMenuPixInAct_, col, DECOCOLORIZE );
    }
}


//////////////////////////////////////////////////////////////////////////////
// colorizePixmap()
// ------------
//
void DeKoratorFactory::colorizePixmap( QPixmap *pix, QColor c, QString colorizeMethod )
{
    QImage img;
    if ( colorizeMethod == "Liquid Method" )
    {
        img = pix->convertToImage();
        //KIconEffect::toGray( img, 1.0 );

        if ( img.depth() != 32 )
            img = img.convertDepth( 32 );
        QImage *dest = new QImage( img.width(), img.height(), 32 );
        dest->setAlphaBuffer( TRUE );
        unsigned int *data = ( unsigned int * ) img.bits();
        unsigned int *destData = ( unsigned int* ) dest->bits();
        int total = img.width() * img.height();
        int current;
        int delta;
        int destR, destG, destB, alpha;
        int srcR = c.red() + 100;
        int srcG = c.green() + 100;
        int srcB = c.blue() + 100;

        for ( current = 0; current < total; ++current )
        {
            alpha = qAlpha( data[ current ] );

            //         qWarning( "--------------------------" );
            //         qWarning( "red - %d", qRed( data[ current ] ) );
            //         qWarning( "green - %d", qRed( data[ current ] ) );
            //         qWarning( "blue - %d", qRed( data[ current ] ) );

            delta = 255 - qGray( data[ current ] );

            destR = srcR - delta;
            destG = srcG - delta;
            destB = srcB - delta;

            if ( destR < 0 ) destR = 0;
            if ( destG < 0 ) destG = 0;
            if ( destB < 0 ) destB = 0;
            if ( destR > 255 ) destR = 255;
            if ( destG > 255 ) destG = 255;
            if ( destB > 255 ) destB = 255;
            destData[ current ] = qRgba( destR, destG, destB, alpha );
        }
        pix->convertFromImage( *dest );
    }
    else if ( colorizeMethod == "Kde Method" )
    {
        img = pix->convertToImage();
        KIconEffect::colorize( img, c, 1.0 );
        pix->convertFromImage( img, 0 );
    }
}











//////////////////////////////////////////////////////////////////////////////
// DeKoratorButton Class                                                      //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// DeKoratorButton()
// ---------------
// Constructor

DeKoratorButton::DeKoratorButton( bool isLeft, int buttonWidth, int buttonHeight, DeKoratorClient *parent, const char *name,
                                  const QString& tip, ButtonType type, QPixmap *buttonPix, QPixmap *buttonPixPress , QPixmap *buttonPixHover, QPixmap *buttonPixInAct )
        : QButton( parent->widget(), name ), isLeft_( isLeft ), buttonWidth_( buttonWidth ), client_( parent ), type_( type ), lastmouse_( NoButton ), decoPixHeight_( buttonHeight )
{
    //decoPixInAct_ = buttonPixInAct;
    animProgress = 0;
    hover_ = FALSE;
    setBackgroundMode( NoBackground );
    setFixedSize( buttonWidth_, BUTTONSHEIGHT );
    setCursor( arrowCursor );
    if ( buttonPix )
        setPixmap( buttonPix, buttonPixPress, buttonPixHover, buttonPixInAct );
    QToolTip::add( this, tip );
    animTmr = new QTimer( this );
    connect( animTmr, SIGNAL( timeout() ), this, SLOT( animate() ) );
}

DeKoratorButton::~DeKoratorButton()
{
    //if ( deco_ ) delete deco_;
}

//////////////////////////////////////////////////////////////////////////////
// setPixmap()
// -----------
// Set the button decoration

void DeKoratorButton::setPixmap( QPixmap *buttonPix, QPixmap *buttonPixPress , QPixmap *buttonPixHover, QPixmap *buttonPixInAct )
{
    decoPix_ = buttonPix;
    decoPixPress_ = buttonPixPress;
    decoPixHover_ = buttonPixHover;
    decoPixInAct_ = buttonPixInAct;

    //decoPix_->setMask(*deco_);
    //   }
    //   else
    //   {
    //     deco_ = new QBitmap(DECOSIZE, DECOSIZE, bitmap, TRUE);
    //     deco_->setMask(*deco_);
    //   }
    repaint( FALSE );
}

//////////////////////////////////////////////////////////////////////////////
// sizeHint()
// ----------
// Return size hint

QSize DeKoratorButton::sizeHint() const
{
    return QSize( buttonWidth_, BUTTONSHEIGHT );
}

//////////////////////////////////////////////////////////////////////////////
// enterEvent()
// ------------
// Mouse has entered the button

void DeKoratorButton::enterEvent( QEvent *e )
{
    // if we wanted to do mouseovers, we would keep track of it here
    QButton::enterEvent( e );
    hover_ = TRUE;
    setCursor( Qt::PointingHandCursor );
    if ( USEANIMATION )
        animate();
    else
        repaint( FALSE );
}

//////////////////////////////////////////////////////////////////////////////
// leaveEvent()
// ------------
// Mouse has left the button

void DeKoratorButton::leaveEvent( QEvent *e )
{
    // if we wanted to do mouseovers, we would keep track of it here
    QButton::leaveEvent( e );
    hover_ = FALSE;
    unsetCursor ();
    if ( USEANIMATION )
        animate();
    else
        repaint( FALSE );
}

//////////////////////////////////////////////////////////////////////////////
// mousePressEvent()
// -----------------
// Button has been pressed

void DeKoratorButton::mousePressEvent( QMouseEvent* e )
{
    lastmouse_ = e->button();

    // translate and pass on mouse event
    int button = LeftButton;
    if ( ( type_ != ButtonMax ) && ( e->button() != LeftButton ) )
    {
        button = NoButton; // middle & right buttons inappropriate
    }
    QMouseEvent me( e->type(), e->pos(), e->globalPos(),
                    button, e->state() );
    QButton::mousePressEvent( &me );
}

//////////////////////////////////////////////////////////////////////////////
// mouseReleaseEvent()
// -----------------
// Button has been released

void DeKoratorButton::mouseReleaseEvent( QMouseEvent* e )
{
    lastmouse_ = e->button();

    // translate and pass on mouse event
    int button = LeftButton;
    if ( ( type_ != ButtonMax ) && ( e->button() != LeftButton ) )
    {
        button = NoButton; // middle & right buttons inappropriate
    }
    QMouseEvent me( e->type(), e->pos(), e->globalPos(), button, e->state() );
    QButton::mouseReleaseEvent( &me );
}

//////////////////////////////////////////////////////////////////////////////
// drawButton()
// ------------
// Draw the button

void DeKoratorButton::drawButton( QPainter *painter )
{
    if ( !DeKoratorFactory::initialized() ) return ;

    QColorGroup group;
    int dx = 0, dy = 0;
    bool act = client_->isActive();

    //painter->fillRect(rect(), Qt::red);

    // fill background
    if ( isLeft_ )
        painter->drawTiledPixmap( rect(), act ? client_->decoFactory_->leftButtonsBg_ : client_->decoFactory_->leftButtonsBgInAct_ );
    else
        painter->drawTiledPixmap( rect(), act ? client_->decoFactory_->rightButtonsBg_ : client_->decoFactory_->rightButtonsBgInAct_ );


    QPixmap *tempPix = NULL;
    dy = ( type_ == ButtonMenu && !USEMENUEIMAGE ) ? ( height() - 16 ) / 2 : ( BUTTONSHEIGHT - decoPixHeight_ ) / 2;

    // pressed
    if ( isDown() )
    {
        dx += BTNSHIFTX;
        dy += BTNSHIFTY;

        if ( type_ == ButtonMenu && !USEMENUEIMAGE )
        {
            tempPix = new QPixmap();
            *tempPix = *decoPixPress_;
            *decoPixPress_ = client_->icon().pixmap( QIconSet::Small, QIconSet::Normal );

        }

        if ( BUTTONHOVERTYPE == "Use Image Colors" )
            painter->drawPixmap( dx, dy, *decoPixPress_ );
        else if ( BUTTONHOVERTYPE == "Colorize" && BUTTONSHOVERCOLORIZE == "Liquid Method" )
        {
            QColor col = ( act ) ? ACTIVEHIGHLIGHTCOLOR : INACTIVEHIGHLIGHTCOLOR;
            col.dark( 130 );

            QPixmap decoPixPressBak = *decoPixPress_;
            DeKoratorFactory::colorizePixmap( &decoPixPressBak, col, BUTTONSHOVERCOLORIZE );

            painter->drawPixmap( dx, dy, decoPixPressBak );
        }
        else
        {
            QImage img;
            //QColor col = client_->decoFactory_->options() ->colorGroup( KDecoration::ColorTitleBlend, TRUE ).background().dark( 130 );

            img = decoPixPress_->convertToImage();
            QImage *manipulatedImg = chooseRightHoverEffect( &img, false, BUTTONHOVERTYPE );

            painter->drawPixmap( dx, dy, *manipulatedImg );

        }
        if ( type_ == ButtonMenu && !USEMENUEIMAGE )
        {

            *decoPixPress_ = *tempPix;
            if ( tempPix )
                delete tempPix;
        }
    }
    // hover
    else if ( hover_ )
    {
        //qWarning( "%d", animProgress );
        //QColor col = client_->decoFactory_->options() ->colorGroup( KDecoration::ColorTitleBar, act ).background();
        QColor col = client_->decoFactory_->options() ->colorGroup( KDecoration::ColorButtonBg, act ).background();

        if ( type_ == ButtonMenu && !USEMENUEIMAGE )
        {
            tempPix = new QPixmap();
            *tempPix = *decoPixHover_;
            *decoPixHover_ = client_->icon().pixmap( QIconSet::Small, QIconSet::Normal );
        }
        if ( USEANIMATION )
        {
            if ( act && !client_->decoFactory_->DeKoratorFactory::colorizeButtons_ )
            {
                //QString res = "5";
                QImage img = decoPixHover_->convertToImage();
                QImage *manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                painter->drawPixmap( dx, dy, *manipulatedImg );
            }
            else
            {
                if ( DECOCOLORIZE == "Liquid Method" )
                {
                    //QString res = "5";
                    QPixmap decoPixBak = *decoPixHover_;
                    DeKoratorFactory::colorizePixmap( &decoPixBak, col, DECOCOLORIZE );
                    QImage img = decoPixBak.convertToImage();
                    QImage *manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                    painter->drawPixmap( dx, dy, *manipulatedImg );
                }
                else //( DECOCOLORIZE == "Kde Method" )
                {
                    //QString res = "5";
                    QImage img = decoPixHover_->convertToImage();
                    KIconEffect::colorize( img, col, 1.0 );
                    QImage *manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                    painter->drawPixmap( dx, dy, *manipulatedImg );
                }
            }
        }
        else
        {
            if ( BUTTONHOVERTYPE == "Use Image Colors" )
                painter->drawPixmap( dx, dy, *decoPixHover_ );
            else if ( BUTTONHOVERTYPE == "Colorize" && BUTTONSHOVERCOLORIZE == "Liquid Method" )
            {
                QPixmap decoPixHoverBak = *decoPixHover_;
                DeKoratorFactory::colorizePixmap( &decoPixHoverBak, ( act ) ? ACTIVEHIGHLIGHTCOLOR : INACTIVEHIGHLIGHTCOLOR, BUTTONSHOVERCOLORIZE );

                painter->drawPixmap( dx, dy, decoPixHoverBak );
            }
            else
            {
                //QColor col = client_->decoFactory_->options() ->colorGroup( KDecoration::ColorTitleBlend, TRUE ).background();
                QImage img = decoPixHover_->convertToImage();
                //QString res = "5";
                QImage *manipulatedImg = chooseRightHoverEffect( &img, false, BUTTONHOVERTYPE );

                painter->drawPixmap( dx, dy, *manipulatedImg );
            }
        }
        if ( type_ == ButtonMenu && !USEMENUEIMAGE )
        {

            *decoPixHover_ = *tempPix;
            if ( tempPix )
                delete tempPix;
        }
    }
    else
    {
        if ( act )
        {
            if ( type_ == ButtonMenu && !USEMENUEIMAGE )
            {
                tempPix = new QPixmap();
                *tempPix = *decoPix_;
                *decoPix_ = client_->icon().pixmap( QIconSet::Small, QIconSet::Normal );
            }

            if ( USEANIMATION )
            {
                //QString res = "5";
                QImage img = decoPix_->convertToImage();
                QImage *manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                painter->drawPixmap( dx, dy, *manipulatedImg );
            }
            else
                painter->drawPixmap( dx, dy, *decoPix_ );

            if ( type_ == ButtonMenu && !USEMENUEIMAGE )
            {
                *decoPix_ = *tempPix;
                if ( tempPix )
                    delete tempPix;
            }
        }
        // normal
        else
        {
            QColor col = client_->decoFactory_->options() ->colorGroup( KDecoration::ColorButtonBg, act ).background();

            if ( type_ == ButtonMenu && !USEMENUEIMAGE )
            {
                tempPix = new QPixmap();
                *tempPix = *decoPixInAct_;
                *decoPixInAct_ = client_->icon().pixmap( QIconSet::Small, QIconSet::Normal );

                if ( DECOCOLORIZE == "Liquid Method" )
                {
                    DeKoratorFactory::colorizePixmap( decoPixInAct_, col, DECOCOLORIZE );

                    if ( USEANIMATION )
                    {
                        //QString res = "5";
                        QImage img = decoPixInAct_->convertToImage();
                        QImage *manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                        painter->drawPixmap( dx, dy, *manipulatedImg );
                    }
                    else
                        painter->drawPixmap( dx, dy, *decoPixInAct_ );
                }
                else
                {
                    QImage img = decoPixInAct_->convertToImage();
                    KIconEffect::colorize( img, col, 1.0 );

                    if ( USEANIMATION )
                    {
                        //QString res = "5";
                        QImage * manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                        painter->drawPixmap( dx, dy, *manipulatedImg );
                    }
                    else
                        painter->drawPixmap( dx, dy, img );
                }
            }
            else if ( DECOCOLORIZE == "Liquid Method" )
            {
                QPixmap decoPixBak = *decoPixInAct_;
                //DeKoratorFactory::colorizePixmap( &decoPixBak, col, DECOCOLORIZE );

                if ( USEANIMATION )
                {
                    //QString res = "5";
                    QImage img = decoPixBak.convertToImage();
                    QImage *manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                    painter->drawPixmap( dx, dy, *manipulatedImg );
                }
                else
                    painter->drawPixmap( dx, dy, decoPixBak );
            }
            else //( DECOCOLORIZE == "Kde Method" )
            {
                QImage img = decoPixInAct_->convertToImage();
                //KIconEffect::colorize( img, col, 1.0 );

                if ( USEANIMATION )
                {

                    //QString res = "5";
                    QImage * manipulatedImg = chooseRightHoverEffect( &img, true, ANIMATIONTYPE );

                    painter->drawPixmap( dx, dy, *manipulatedImg );
                }
                else
                    painter->drawPixmap( dx, dy, img );
            }
            if ( type_ == ButtonMenu && !USEMENUEIMAGE )
            {

                *decoPixInAct_ = *tempPix;
                if ( tempPix )
                    delete tempPix;
            }
        }

    }
    if ( client_->isShade() && !SHOWBTMBORDER )
    {
        painter->setPen( QColor( 70, 70, 70 ) );
        painter->drawLine( 0, BUTTONSHEIGHT - 1, buttonWidth_ - 1, BUTTONSHEIGHT - 1 );
    }
}

//////////////////////////////////////////////////////////////////////////////
// chooseRightHoverEffect()
// ------------
//
QImage* DeKoratorButton::chooseRightHoverEffect( QImage *img, bool isAnimate, QString res )
{

    if ( isAnimate )
    {
        float f = ( ( float ) animProgress / 100 );

        if ( res == "Intensity" )
        {
            f /= 1.5;

            * img = KImageEffect::intensity ( *img, f );
        }
        else if ( res == "Blend" )
        {
            f /= 1.7;
            QColor col = client_->isActive() ? ACTIVEHIGHLIGHTCOLOR : INACTIVEHIGHLIGHTCOLOR;

            * img = KImageEffect::blend ( col, *img, f );
        }
        else if ( res == "Solarize" )
        {
            KImageEffect::solarize ( *img, 100 - animProgress );
        }
        else if ( res == "Fade" )
        {
            f /= 3;
            QColor col = client_->isActive() ? ACTIVEHIGHLIGHTCOLOR : INACTIVEHIGHLIGHTCOLOR;

            * img = KImageEffect::fade ( *img, f, col );
        }
        else if ( res == "Trashed" )
        {
            * img = KImageEffect::fade ( *img, animProgress, Qt::black );
        }
    }
    else
    {
        if ( BUTTONHOVERTYPE == "To Gray" )
            KIconEffect::toGray( *img, EFFECTAMOUNT );
        else if ( BUTTONHOVERTYPE == "Colorize" )
        {
            QColor col = client_->isActive() ? ACTIVEHIGHLIGHTCOLOR : INACTIVEHIGHLIGHTCOLOR;
            KIconEffect::colorize( *img, col, EFFECTAMOUNT );
        }
        else if ( BUTTONHOVERTYPE == "DeSaturate" )
            KIconEffect::deSaturate( *img, EFFECTAMOUNT );
        else if ( BUTTONHOVERTYPE == "To Gamma" )
            KIconEffect::toGamma( *img, EFFECTAMOUNT );
    }
    return img;
}
//////////////////////////////////////////////////////////////////////////////
// animate()
// ------------
// animate the button

void DeKoratorButton::animate()
{
    animTmr->stop();

    if ( hover_ )
    {
        if ( animProgress < ANIMATIONSTEPS )
        {
            animProgress += 5;
            animTmr->start( TIMERINTERVAL, true ); // single-shot
        }
        else
        {
            animProgress = ANIMATIONSTEPS;
        }
    }
    else
    {
        if ( animProgress > 0 )
        {
            animProgress -= 5;
            animTmr->start( TIMERINTERVAL, true ); // single-shot
        }
        else
        {
            animProgress = 0;
        }
    }

    repaint( false );
}









//////////////////////////////////////////////////////////////////////////////
// DeKoratorClient Class                                                      //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// DeKoratorClient()
// ---------------
// Constructor

DeKoratorClient::DeKoratorClient( KDecorationBridge *b, KDecorationFactory *f )
        : KDecoration( b, f ), mainLayout_( NULL ), titleLayout_( NULL ), midLayout_( NULL ) , leftTitleBarSpacer_( NULL ), titleBarSpacer_( NULL ), rightTitleBarSpacer_( NULL ), leftSpacer_( NULL ), rightSpacer_( NULL ), bottomSpacer_( NULL ), captionBufferDirty_( true )
{
    captionBufferDirty_ = true;
    decoFactory_ = ( DeKoratorFactory* ) f;
}

DeKoratorClient::~DeKoratorClient()
{
    for ( int n = 0; n < ButtonTypeCount; n++ )
    {
        if ( button[ n ] ) delete button[ n ];
    }
}

//////////////////////////////////////////////////////////////////////////////
// init()
// ------
// Actual initializer for class


// basic layout:

//  __________________________________________________________________________
// | leftTitleBarSpacer | btns | titleBarSpacer_ | bts | rightTitleBarSpacer |
// |____________________|______|_________________|_____|_____________________|
// | |                                                                     | |
// | |                         contentsFake                                | |
// | |                                                                     | |
// |leftSpacer                                                    rightSpacer|
// |_|_____________________________________________________________________|_|
// |                                 bottomSpacer                            |
// |_________________________________________________________________________|
//

void DeKoratorClient::init()
{
    createMainWidget( WNoAutoErase );
    widget() ->installEventFilter( this );

    // for flicker-free redraws
    widget() ->setBackgroundMode( NoBackground );
    //qWarning( "1" );
    if ( mainLayout_ != NULL )
    {
        // layouts
        delete mainLayout_;
        delete titleLayout_;
        delete midLayout_;
        // spacers
        delete leftTitleBarSpacer_;
        delete titleBarSpacer_;
        delete rightTitleBarSpacer_;
        delete leftSpacer_;
        delete rightSpacer_;
        delete bottomSpacer_;
    }
    //qWarning( "2" );

    // layouts
    mainLayout_ = new QVBoxLayout( widget(), 0, 0 );
    titleLayout_ = new QHBoxLayout( mainLayout_, 0, 0 );
    midLayout_ = new QHBoxLayout( mainLayout_, 0, 0 );

    // spacers
    leftTitleBarSpacer_ = new QSpacerItem( decoFactory_->topLeftCornerBg_.width(), TITLESIZE,
                                           QSizePolicy::Fixed, QSizePolicy::Fixed );
    titleBarSpacer_ = new QSpacerItem( 1, TITLESIZE, QSizePolicy::Expanding,
                                       QSizePolicy::Fixed );
    rightTitleBarSpacer_ = new QSpacerItem( decoFactory_->topRightCornerBg_.width(), TITLESIZE,
                                            QSizePolicy::Fixed, QSizePolicy::Fixed );
    leftSpacer_ = new QSpacerItem( LEFTFRAMESIZE, 1,
                                   QSizePolicy::Fixed, QSizePolicy::Expanding );
    rightSpacer_ = new QSpacerItem( RIGHTFRAMESIZE, 1,
                                    QSizePolicy::Fixed, QSizePolicy::Expanding );
    bottomSpacer_ = new QSpacerItem( 1, ( !isSetShade() || SHOWBTMBORDER ) ? BUTTOMFRAMESIZE : 0,
                                     QSizePolicy::Expanding, QSizePolicy::Fixed );

    //qWarning( "3" );
    // setup layout

    //left spacer
    titleLayout_->addItem( leftTitleBarSpacer_ );
    // setup titlebar buttons
    for ( int n = 0; n < ButtonTypeCount; n++ ) button[ n ] = 0;
    addButtons( titleLayout_, options() ->titleButtonsLeft(), TRUE );
    titleLayout_->addItem( titleBarSpacer_ );
    addButtons( titleLayout_, options() ->titleButtonsRight(), FALSE );
    //right spacer
    titleLayout_->addItem( rightTitleBarSpacer_ );

    // mid layout
    midLayout_->addItem( leftSpacer_ );
    if ( isPreview() )
    {
        midLayout_->addWidget( new QLabel( "<center><b>" + i18n( "Dekorator preview (Version 0.2)" ) + "</b></center>", widget() ) );
    }
    else
    {
        midLayout_->addItem( new QSpacerItem( 0, 0 ) );
    }
    midLayout_->addItem( rightSpacer_ );
    //qWarning( "4" );

    //Bottom
    //if(!isSetShade() || SHOWBTMBORDER)
    mainLayout_->addItem( bottomSpacer_ );

    // connections
    connect( this, SIGNAL( keepAboveChanged( bool ) ), SLOT( keepAboveChange( bool ) ) );
    connect( this, SIGNAL( keepBelowChanged( bool ) ), SLOT( keepBelowChange( bool ) ) );

    captionBufferDirty_ = true;
    widget() ->update( titleBarSpacer_->geometry() );
    //qWarning( "5" );
}

//////////////////////////////////////////////////////////////////////////////
// addButtons()
// ------------
// Add buttons to title layout

void DeKoratorClient::addButtons( QBoxLayout *layout, const QString& s, bool isLeft )
{
    //const unsigned char * bitmap;
    QPixmap * pix1, *pix2, *pix3, *pix4;
    QString tip;

    if ( s.length() > 0 )
    {
        for ( unsigned n = 0; n < s.length(); n++ )
        {
            switch ( s[ n ] )
            {
            case 'M':                                                                                                                                                                                                                                                                                               // Menu button
                if ( !button[ ButtonMenu ] )
                {
                    button[ ButtonMenu ] =
                        new DeKoratorButton( isLeft, ( BTNMENUWIDTH < 16 ) ? 16 : BTNMENUWIDTH, BTNMENUHEIGHT, this, "menu", i18n( "Menu" ), ButtonMenu, &( decoFactory_->buttonMenuPix_ ) ,
                                             &( decoFactory_->buttonMenuPressPix_ ),
                                             &( decoFactory_->buttonMenuHoverPix_ ),
                                             &( decoFactory_->buttonMenuPixInAct_ ) );
                    connect( button[ ButtonMenu ], SIGNAL( pressed() ),
                             this, SLOT( menuButtonPressed() ) );
                    connect( button[ ButtonMenu ], SIGNAL( released() ), this, SLOT( menuButtonReleased() ) );

                    layout->addWidget( button[ ButtonMenu ] );
                }
                break;

            case 'S':                                                                                                                                                                                                                                                                                               // Sticky button
                if ( !button[ ButtonSticky ] )
                {
                    bool d = isOnAllDesktops();
                    if ( d )
                    {
                        pix1 = &( decoFactory_->buttonStickyDownPix_ );
                        pix2 = &( decoFactory_->buttonStickyDownPressPix_ );
                        pix3 = &( decoFactory_->buttonStickyDownHoverPix_ );
                        pix4 = &( decoFactory_->buttonStickyDownPixInAct_ );
                    }
                    else
                    {
                        pix1 = &( decoFactory_->buttonStickyPix_ );
                        pix2 = &( decoFactory_->buttonStickyPressPix_ );
                        pix3 = &( decoFactory_->buttonStickyHoverPix_ );
                        pix4 = &( decoFactory_->buttonStickyDownPixInAct_ );
                    }
                    button[ ButtonSticky ] =
                        new DeKoratorButton( isLeft, BTNSTICKYWIDTH, BTNSTICKYHEIGHT, this, "sticky", d ? i18n( "Sticky" ) : i18n( "Un-Sticky" ),
                                             ButtonSticky, pix1, pix2, pix3, pix4 );
                    connect( button[ ButtonSticky ], SIGNAL( clicked() ),
                             this, SLOT( toggleOnAllDesktops() ) );
                    layout->addWidget( button[ ButtonSticky ] );
                }
                break;

            case 'H':                                                                                                                                                                                                                                                                                               // Help button
                if ( ( !button[ ButtonHelp ] ) && providesContextHelp() )
                {
                    button[ ButtonHelp ] =
                        new DeKoratorButton( isLeft, BTNHELPEWIDTH, BTNHELPEHEIGHT, this, "help", i18n( "Help" ),
                                             ButtonHelp, &( decoFactory_->buttonHelpPix_ ) ,
                                             &( decoFactory_->buttonHelpPressPix_ ),
                                             &( decoFactory_->buttonHelpHoverPix_ ),
                                             &( decoFactory_->buttonHelpPixInAct_ ) );
                    connect( button[ ButtonHelp ], SIGNAL( clicked() ),
                             this, SLOT( showContextHelp() ) );
                    layout->addWidget( button[ ButtonHelp ] );
                }
                break;

            case 'I':                                                                                                                                                                                                                                                                                               // Minimize button
                if ( ( !button[ ButtonMin ] ) && isMinimizable() )
                {
                    button[ ButtonMin ] =
                        new DeKoratorButton( isLeft, BTNMINWIDTH, BTNMINHEIGHT, this, "iconify", i18n( "Minimize" ), ButtonMin, &( decoFactory_->buttonMinPix_ ) ,
                                             &( decoFactory_->buttonMinPressPix_ ),
                                             &( decoFactory_->buttonMinHoverPix_ ) ,
                                             &( decoFactory_->buttonMinPixInAct_ ) );
                    connect( button[ ButtonMin ], SIGNAL( clicked() ),
                             this, SLOT( minimize() ) );
                    layout->addWidget( button[ ButtonMin ] );
                }
                break;

            case 'A':                                                                                                                                                                                                                                                                                               // Maximize button
                if ( ( !button[ ButtonMax ] ) && isMaximizable() )
                {
                    bool m = ( maximizeMode() == MaximizeFull );
                    if ( m )
                    {
                        pix1 = &( decoFactory_->buttonRestorePix_ );
                        pix2 = &( decoFactory_->buttonRestorePressPix_ );
                        pix3 = &( decoFactory_->buttonRestoreHoverPix_ );
                        pix4 = &( decoFactory_->buttonRestorePixInAct_ );
                    }
                    else
                    {
                        pix1 = &( decoFactory_->buttonMaxPix_ );
                        pix2 = &( decoFactory_->buttonMaxPressPix_ );
                        pix3 = &( decoFactory_->buttonMaxHoverPix_ );
                        pix4 = &( decoFactory_->buttonMaxPixInAct_ );
                    }
                    button[ ButtonMax ] =
                        new DeKoratorButton( isLeft, BTNMAXWIDTH, BTNMAXHEIGHT, this, "maximize", m ? i18n( "Restore" ) : i18n( "Maximize" ),
                                             ButtonMax, pix1, pix2, pix3, pix4 );
                    connect( button[ ButtonMax ], SIGNAL( clicked() ),
                             this, SLOT( maxButtonPressed() ) );
                    layout->addWidget( button[ ButtonMax ] );
                }
                break;

            case 'X':                                                                                                                                                                                                                                                                                               // Close button
                if ( ( !button[ ButtonClose ] ) && isCloseable() )
                {
                    button[ ButtonClose ] =
                        new DeKoratorButton( isLeft, BTNCLOSEWIDTH, BTNCLOSEHEIGHT, this, "close", i18n( "Close" ),
                                             ButtonClose, &( decoFactory_->buttonClosePix_ ),
                                             &( decoFactory_->buttonClosePressPix_ ),
                                             &( decoFactory_->buttonCloseHoverPix_ ),
                                             &( decoFactory_->buttonClosePixInAct_ ) );
                    connect( button[ ButtonClose ], SIGNAL( clicked() ),
                             this, SLOT( closeWindow() ) );
                    layout->addWidget( button[ ButtonClose ] );
                }
                break;

            case 'F':                                                                                                                                                                                                                                                                                               // Above button
                if ( ( !button[ ButtonAbove ] ) )
                {
                    bool a = keepAbove();
                    if ( a )
                    {
                        pix1 = &( decoFactory_->buttonAboveDownPix_ );
                        pix2 = &( decoFactory_->buttonAboveDownPressPix_ );
                        pix3 = &( decoFactory_->buttonAboveDownHoverPix_ );
                        pix4 = &( decoFactory_->buttonAboveDownPixInAct_ );
                    }
                    else
                    {
                        pix1 = &( decoFactory_->buttonAbovePix_ );
                        pix2 = &( decoFactory_->buttonAbovePressPix_ );
                        pix3 = &( decoFactory_->buttonAboveHoverPix_ );
                        pix4 = &( decoFactory_->buttonAbovePixInAct_ );
                    }
                    pix1 = &( decoFactory_->buttonAbovePix_ );
                    button[ ButtonAbove ] =
                        new DeKoratorButton( isLeft, BTNABOVEWIDTH, BTNABOVEHEIGHT, this, "above",
                                             i18n( "Keep Above Others" ), ButtonAbove, pix1, pix2, pix3, pix4 );
                    connect( button[ ButtonAbove ], SIGNAL( clicked() ),
                             this, SLOT( aboveButtonPressed() ) );
                    layout->addWidget( button[ ButtonAbove ] );
                }
                break;

            case 'B':                                                                                                                                                                                                                                                                                               // Below button
                if ( ( !button[ ButtonBelow ] ) )
                {
                    bool b = keepBelow();
                    if ( b )
                    {
                        pix1 = &( decoFactory_->buttonBelowDownPix_ );
                        pix2 = &( decoFactory_->buttonBelowDownPressPix_ );
                        pix3 = &( decoFactory_->buttonBelowDownHoverPix_ );
                        pix4 = &( decoFactory_->buttonBelowDownPixInAct_ );
                    }
                    else
                    {
                        pix1 = &( decoFactory_->buttonBelowPix_ );
                        pix2 = &( decoFactory_->buttonBelowPressPix_ );
                        pix3 = &( decoFactory_->buttonBelowHoverPix_ );
                        pix4 = &( decoFactory_->buttonBelowPixInAct_ );
                    }
                    pix1 = &( decoFactory_->buttonBelowPix_ );
                    button[ ButtonBelow ] =
                        new DeKoratorButton( isLeft, BTNBELOWWIDTH, BTNBELOWHEIGHT, this, "below",
                                             i18n( "Keep Below Others" ), ButtonBelow, pix1, pix2, pix3, pix4 );
                    connect( button[ ButtonBelow ], SIGNAL( clicked() ),
                             this, SLOT( belowButtonPressed() ) );
                    layout->addWidget( button[ ButtonBelow ] );
                }
                break;

            case 'L':                                                                                                                                                                                                                                                                                               // Shade button
                if ( ( !button[ ButtonShade && isShadeable() ] ) )
                {
                    bool s = isSetShade();
                    if ( s )
                    {
                        pix1 = &( decoFactory_->buttonShadeDownPix_ );
                        pix2 = &( decoFactory_->buttonShadeDownPressPix_ );
                        pix3 = &( decoFactory_->buttonShadeDownHoverPix_ );
                        pix4 = &( decoFactory_->buttonShadeDownPixInAct_ );
                    }
                    else
                    {
                        pix1 = &( decoFactory_->buttonShadePix_ );
                        pix2 = &( decoFactory_->buttonShadePressPix_ );
                        pix3 = &( decoFactory_->buttonShadeHoverPix_ );
                        pix4 = &( decoFactory_->buttonShadePixInAct_ );
                    }
                    button[ ButtonShade ] =
                        new DeKoratorButton( isLeft, BTNSHADEWIDTH, BTNSHADEHEIGHT, this, "shade", s ? i18n( "Unshade" ) : i18n( "Shade" ),
                                             ButtonShade, pix1, pix2, pix3, pix4 );
                    connect( button[ ButtonShade ], SIGNAL( clicked() ),
                             this, SLOT( shadeButtonPressed() ) );
                    layout->addWidget( button[ ButtonShade ] );
                }
                break;

            case '_':                                                                                                                                                                                                                                   // Spacer item
                layout->addSpacing( 5 );
            }
        }
    }
}

//////////////////////////////////////////////////////////////////////////////
// activeChange()
// --------------
// window active state has changed

void DeKoratorClient::activeChange()
{
    for ( int n = 0; n < ButtonTypeCount; n++ )
        if ( button[ n ] ) button[ n ] ->reset();
    widget() ->repaint( FALSE );
}

//////////////////////////////////////////////////////////////////////////////
// captionChange()
// ---------------
// The title has changed

void DeKoratorClient::captionChange()
{
    captionBufferDirty_ = true;
    widget() ->repaint( titleBarSpacer_->geometry() );
}

//////////////////////////////////////////////////////////////////////////////
// desktopChange()
// ---------------
// Called when desktop/sticky changes

void DeKoratorClient::desktopChange()
{
    //qWarning("ssssssssssssssssssssss");
    bool d = isOnAllDesktops();
    QPixmap *pix1, *pix2, *pix3, *pix4;
    if ( d )
    {
        pix1 = &( decoFactory_->buttonStickyDownPix_ );
        pix2 = &( decoFactory_->buttonStickyDownPressPix_ );
        pix3 = &( decoFactory_->buttonStickyDownHoverPix_ );
        pix4 = &( decoFactory_->buttonStickyDownPixInAct_ );
    }
    else
    {
        pix1 = &( decoFactory_->buttonStickyPix_ );
        pix2 = &( decoFactory_->buttonStickyPressPix_ );
        pix3 = &( decoFactory_->buttonStickyHoverPix_ );
        pix4 = &( decoFactory_->buttonStickyPixInAct_ );
    }
    if ( button[ ButtonSticky ] )
    {
        button[ ButtonSticky ] ->setPixmap( pix1, pix2, pix3, pix4 );
        QToolTip::remove( button[ ButtonSticky ] );
        QToolTip::add( button[ ButtonSticky ], d ? i18n( "Sticky" ) : i18n( "Un-Sticky" ) );
    }
}

//////////////////////////////////////////////////////////////////////////////
// iconChange()
// ------------
// The title has changed

void DeKoratorClient::iconChange()
{
    if ( !USEMENUEIMAGE && button[ ButtonMenu ] )
    {
        //button[ ButtonMenu ] ->setPixmap( 0 );
        button[ ButtonMenu ] ->repaint( FALSE );
    }
}

//////////////////////////////////////////////////////////////////////////////
// maximizeChange()
// ----------------
// Maximized state has changed

void DeKoratorClient::maximizeChange()
{
    bool m = ( maximizeMode() == MaximizeFull );
    QPixmap *pix1, *pix2, *pix3, *pix4;
    if ( m )
    {
        pix1 = &( decoFactory_->buttonRestorePix_ );
        pix2 = &( decoFactory_->buttonRestorePressPix_ );
        pix3 = &( decoFactory_->buttonRestoreHoverPix_ );
        pix4 = &( decoFactory_->buttonRestorePixInAct_ );
    }
    else
    {
        pix1 = &( decoFactory_->buttonMaxPix_ );
        pix2 = &( decoFactory_->buttonMaxPressPix_ );
        pix3 = &( decoFactory_->buttonMaxHoverPix_ );
        pix4 = &( decoFactory_->buttonMaxPixInAct_ );
    }
    if ( button[ ButtonMax ] )
    {
        button[ ButtonMax ] ->setPixmap( pix1, pix2, pix3, pix4 );
        QToolTip::remove( button[ ButtonMax ] );
        QToolTip::add( button[ ButtonMax ], m ? i18n( "Restore" ) : i18n( "Maximize" ) );
    }
}

//////////////////////////////////////////////////////////////////////////////
// shadeChange()
// -------------
// Called when window shading changes

void DeKoratorClient::shadeChange()
{
    bool s = isSetShade();
    QPixmap *pix1, *pix2, *pix3, *pix4;
    if ( s )
    {
        pix1 = &( decoFactory_->buttonShadeDownPix_ );
        pix2 = &( decoFactory_->buttonShadeDownPressPix_ );
        pix3 = &( decoFactory_->buttonShadeDownHoverPix_ );
        pix4 = &( decoFactory_->buttonShadeDownPixInAct_ );
    }
    else
    {
        pix1 = &( decoFactory_->buttonShadePix_ );
        pix2 = &( decoFactory_->buttonShadePressPix_ );
        pix3 = &( decoFactory_->buttonShadeHoverPix_ );
        pix4 = &( decoFactory_->buttonShadePixInAct_ );
    }
    if ( button[ ButtonShade ] )
    {
        button[ ButtonShade ] ->setPixmap( pix1, pix2, pix3, pix4 );
        QToolTip::remove( button[ ButtonShade ] );
        QToolTip::add( button[ ButtonShade ], s ? i18n( "Unshade" ) : i18n( "Shade" ) );
    }

    //mainlayout_->setRowSpacing( 3, isSetShade() ? 0 : MARGIN );
    for ( int n = 0; n < ButtonTypeCount; n++ )
        if ( button[ n ] ) button[ n ] ->reset();
    widget() ->repaint( FALSE );

    //mainlayout_->setRowSpacing( 3, isSetShade() ? 0 : MARGIN );
    //     if ( DeKoratorFactory::useMasks_ )
    //         doShape();
}

//////////////////////////////////////////////////////////////////////////////
// keepAboveChange()
// ------------
// The above state has changed

void DeKoratorClient::keepAboveChange( bool a )
{
    QPixmap * pix1, *pix2, *pix3, *pix4;
    if ( a )
    {
        pix1 = &( decoFactory_->buttonAboveDownPix_ );
        pix2 = &( decoFactory_->buttonAboveDownPressPix_ );
        pix3 = &( decoFactory_->buttonAboveDownHoverPix_ );
        pix4 = &( decoFactory_->buttonAboveDownPixInAct_ );
    }
    else
    {
        pix1 = &( decoFactory_->buttonAbovePix_ );
        pix2 = &( decoFactory_->buttonAbovePressPix_ );
        pix3 = &( decoFactory_->buttonAboveHoverPix_ );
        pix4 = &( decoFactory_->buttonAbovePixInAct_ );
    }
    if ( button[ ButtonAbove ] )
    {
        button[ ButtonAbove ] ->setPixmap( pix1, pix2, pix3, pix4 );
    }
}

//////////////////////////////////////////////////////////////////////////////
// keepBelowChange()
// ------------
// The below state has changed

void DeKoratorClient::keepBelowChange( bool b )
{
    QPixmap * pix1, *pix2, *pix3, *pix4;
    if ( b )
    {
        pix1 = &( decoFactory_->buttonBelowDownPix_ );
        pix2 = &( decoFactory_->buttonBelowDownPressPix_ );
        pix3 = &( decoFactory_->buttonBelowDownHoverPix_ );
        pix4 = &( decoFactory_->buttonBelowDownPixInAct_ );
    }
    else
    {
        pix1 = &( decoFactory_->buttonBelowPix_ );
        pix2 = &( decoFactory_->buttonBelowPressPix_ );
        pix3 = &( decoFactory_->buttonBelowHoverPix_ );
        pix4 = &( decoFactory_->buttonBelowPixInAct_ );
    }
    if ( button[ ButtonBelow ] )
    {
        button[ ButtonBelow ] ->setPixmap( pix1, pix2, pix3, pix4 );
    }
}

//////////////////////////////////////////////////////////////////////////////
// borders()
// ----------
// Get the size of the borders

void DeKoratorClient::borders( int &l, int &r, int &t, int &b ) const
{
    l = LEFTFRAMESIZE;
    r = RIGHTFRAMESIZE;
    t = TITLESIZE ;
    //     if ( SHOWBTMBORDER )
    //b = 10;
    //     else
    //         b = isShade() ? 0 : BUTTOMFRAMESIZE;
    //b = SHOWBTMBORDER ? BUTTOMFRAMESIZE : isShade() ? 1 : BUTTOMFRAMESIZE;
    if ( !isShade() || SHOWBTMBORDER )
    {
        b = BUTTOMFRAMESIZE;
        bottomSpacer_->changeSize( 1, BUTTOMFRAMESIZE, QSizePolicy::Expanding, QSizePolicy::Fixed );
    }
    else
    {
        b = 0;
        bottomSpacer_->changeSize( 1, b, QSizePolicy::Expanding, QSizePolicy::Fixed );
    }
    widget() ->layout() ->activate();
}

//////////////////////////////////////////////////////////////////////////////
// resize()
// --------
// Called to resize the window

void DeKoratorClient::resize( const QSize &size )
{
    widget() ->resize( size );
}

//////////////////////////////////////////////////////////////////////////////
// minimumSize()
// -------------
// Return the minimum allowable size for this window

QSize DeKoratorClient::minimumSize() const
{
    QSize size = widget() ->minimumSize();
    size.setWidth( size.width() + decoFactory_->topLeftCornerBg_.width() + decoFactory_->topRightCornerBg_.width() );

    return size;

}

//////////////////////////////////////////////////////////////////////////////
// mousePosition()
// ---------------
// Return logical mouse position

KDecoration::Position DeKoratorClient::mousePosition( const QPoint &point ) const
{
    //    bool res = TRUE;
    Position pos;
    if ( isShade() )
    {
        return PositionCenter;
    }

    if ( point.y() <= 5 )
    {
        // inside top frame
        if ( point.x() <= decoFactory_->midLeftFrameBg_.width() ) pos = PositionTopLeft;
        else if ( point.x() >= ( width() - decoFactory_->midRightFrameBg_.width() ) ) pos = PositionTopRight;
        else pos = PositionTop;
    }
    else if ( point.y() >= ( height() - decoFactory_->midButtomFrameBg_.height() ) )
    {
        // inside handle
        if ( point.x() <= decoFactory_->midLeftFrameBg_.width() ) pos = PositionBottomLeft;
        else if ( point.x() >= ( width() - decoFactory_->midRightFrameBg_.width() ) ) pos = PositionBottomRight;
        else pos = PositionBottom;
    }
    else if ( point.x() <= decoFactory_->midLeftFrameBg_.width() )
    {
        // on left frame
        if ( point.y() <= decoFactory_->midTitleBg_.height() ) pos = PositionTopLeft;
        else if ( point.y() >= ( height() - decoFactory_->midButtomFrameBg_.height() ) ) pos = PositionBottomLeft;
        else pos = PositionLeft;
    }
    else if ( point.x() >= width() - decoFactory_->midRightFrameBg_.width() )
    {
        // on right frame
        if ( point.y() <= decoFactory_->midTitleBg_.height() ) pos = PositionTopRight;
        else if ( point.y() >= ( height() - decoFactory_->midButtomFrameBg_.height() ) ) pos = PositionBottomRight;
        else pos = PositionRight;
    }
    else
    {
        // inside the frame
        pos = PositionCenter;
    }
    return pos;

    //     const int corner = 24;
    //     Position pos;
    //
    //     if (point.y() <= MARGIN) {
    //         // inside top frame
    //         if (point.x() <= corner)                 pos = PositionTopLeft;
    //         else if (point.x() >= (width()-corner))  pos = PositionTopRight;
    //         else                                     pos = PositionTop;
    //     } else if (point.y() >= (height()-MARGIN*2)) {
    //         // inside handle
    //         if (point.x() <= corner)                 pos = PositionBottomLeft;
    //         else if (point.x() >= (width()-corner))  pos = PositionBottomRight;
    //         else                                     pos = PositionBottom;
    //     } else if (point.x() <= MARGIN) {
    //         // on left frame
    //         if (point.y() <= corner)                 pos = PositionTopLeft;
    //         else if (point.y() >= (height()-corner)) pos = PositionBottomLeft;
    //         else                                     pos = PositionLeft;
    //     } else if (point.x() >= width()-MARGIN) {
    //         // on right frame
    //         if (point.y() <= corner)                 pos = PositionTopRight;
    //         else if (point.y() >= (height()-corner)) pos = PositionBottomRight;
    //         else                                     pos = PositionRight;
    //     } else {
    //         // inside the frame
    //         pos = PositionCenter;
    //     }
    //     return pos;

}

//////////////////////////////////////////////////////////////////////////////
// eventFilter()
// -------------
// Event filter

bool DeKoratorClient::eventFilter( QObject *obj, QEvent *e )
{
    if ( obj != widget() ) return FALSE;

    switch ( e->type() )
    {

    case QEvent::MouseButtonDblClick:
        {
            mouseDoubleClickEvent( static_cast<QMouseEvent *>( e ) );
            return TRUE;
        }
    case QEvent::MouseButtonPress:
        {
            processMousePressEvent( static_cast<QMouseEvent *>( e ) );
            if ( USEMASKS )
                doShape();
            return TRUE;
        }
    case QEvent::Paint:
        {
            paintEvent( static_cast<QPaintEvent *>( e ) );
            return TRUE;
        }
    case QEvent::Resize:
        {
            resizeEvent( static_cast<QResizeEvent *>( e ) );
            return TRUE;
        }
    case QEvent::Show:
        {
            showEvent( static_cast<QShowEvent *>( e ) );
            return TRUE;
        }
    default:
        {
            return FALSE;
        }
    }

    return FALSE;
}

//////////////////////////////////////////////////////////////////////////////
// mouseDoubleClickEvent()
// -----------------------
// Doubleclick on title

void DeKoratorClient::mouseDoubleClickEvent( QMouseEvent *e )
{
    if ( titleBarSpacer_->geometry().contains( e->pos() ) ) titlebarDblClickOperation();
}

//////////////////////////////////////////////////////////////////////////////
// paintEvent()
// ------------
// Repaint the window

void DeKoratorClient::paintEvent( QPaintEvent* )
{
    if ( !DeKoratorFactory::initialized() ) return ;
    if ( TITLESIZE > 0 )
    {
        if ( captionBufferDirty_ && USESHDTEXT )
            updateCaptionBuffer();

        QPainter painter( widget() );
        int tx, ty, tw, th;
        int w = width() , h = height();
        QRect title( titleBarSpacer_->geometry() );
        QRect leftTitle( leftTitleBarSpacer_->geometry() );
        QRect rightTitle( rightTitleBarSpacer_->geometry() );
        title.rect( &tx, &ty, &tw, &th );
        QRect rect;

        QPainter painter2;
        QPixmap pix( w, TITLESIZE );
        painter2.begin( &pix );
        {
            // topLeftCorner
            rect.setRect( 0, 0, TOPLEFTCORNERWIDTH, TITLESIZE );
            painter2.drawTiledPixmap( rect, isActive() ? decoFactory_->topLeftCornerBg_ : decoFactory_->topLeftCornerBgInAct_ );

            // Space under the left button group
            painter2.drawTiledPixmap( leftTitle.right() + 1, title.top(),
                                      ( title.left() - 1 ) - leftTitle.right(), title.height(), isActive() ? decoFactory_->leftButtonsBg_ : decoFactory_->leftButtonsBgInAct_ );

            if ( tw > 0 )
            {
                //qWarning("%d",title.width());

                //leftTitle
                rect.setRect( tx, 0, QMIN( LEFTTITLEWIDTH, tw ), TITLESIZE );
                painter2.drawTiledPixmap( rect, isActive() ? decoFactory_->leftTitleBg_ : decoFactory_->leftTitleBgInAct_ );

                //midTitle
                if ( tw > LEFTTITLEWIDTH + RIGHTTITLEWIDTH )
                {
                    rect.setRect( tx + LEFTTITLEWIDTH, 0, tw - ( RIGHTTITLEWIDTH + LEFTTITLEWIDTH ), th );

                    painter2.drawTiledPixmap( rect, isActive() ? decoFactory_->midTitleBg_ : decoFactory_->midTitleBgInAct_ );
                }

                //rightTitle
                if ( tw > LEFTTITLEWIDTH )
                {
                    rect.setRect( QMAX( tx + tw - RIGHTTITLEWIDTH, tx + LEFTTITLEWIDTH ), 0, QMIN( RIGHTTITLEWIDTH, tw - LEFTTITLEWIDTH ), th );

                    painter2.drawTiledPixmap( rect.x(), rect.y(), rect.width(), rect.height(), isActive() ? decoFactory_->rightTitleBg_ : decoFactory_->rightTitleBgInAct_, ( tw > LEFTTITLEWIDTH + RIGHTTITLEWIDTH ) ? 0 : LEFTTITLEWIDTH - ( tw - RIGHTTITLEWIDTH ), 0 );
                }
            }

            // Space under the right button group
            painter2.drawTiledPixmap( title.right() + 1, title.top(),
                                      ( rightTitle.left() - 1 ) - title.right(), title.height(), isActive() ? decoFactory_->rightButtonsBg_ : decoFactory_->rightButtonsBgInAct_ );


            //topRightCorner
            rect.setRect( widget() ->width() - TOPRIGHTCORNERWIDTH, 0, TOPRIGHTCORNERWIDTH, TITLESIZE );
            painter2.drawTiledPixmap( rect, isActive() ? decoFactory_->topRightCornerBg_ : decoFactory_->topRightCornerBgInAct_ );


            QString c( caption() );
            QFontMetrics fm( options() ->font( isActive() ) );
            int captionWidth = fm.width( c );
            // shadow text effect
            if ( USESHDTEXT )
            {

                int captionHeight = fm.height( );
                int dx = 0, dy = 0;

                if ( TITLEALIGN == Qt::AlignLeft || captionWidth > title.width() )
                {
                    dx = tx + 1 + ( isActive() ? ACTIVESHDTEXTX : INACTIVESHDTEXTX ) ;
                    dy = ( TITLESIZE / 2 ) - ( captionHeight / 2 ) + ( isActive() ? ACTIVESHDTEXTY : INACTIVESHDTEXTY ) ;
                }
                else if ( TITLEALIGN == Qt::AlignHCenter )
                {
                    dx = tx + ( tw / 2 ) - ( ( captionWidth + ( MARGIN * 2 ) ) / 2 ) + ( isActive() ? ACTIVESHDTEXTX : INACTIVESHDTEXTX ) ;
                    dy = ( TITLESIZE / 2 ) - ( captionHeight / 2 ) + ( isActive() ? ACTIVESHDTEXTY : INACTIVESHDTEXTY ) ;
                }
                else if ( TITLEALIGN == Qt::AlignRight )
                {
                    dx = tx + tw - ( captionWidth + ( MARGIN * 2 ) ) - 1 + ( isActive() ? ACTIVESHDTEXTX : INACTIVESHDTEXTX ) ;
                    dy = ( TITLESIZE / 2 ) - ( captionHeight / 2 ) + ( isActive() ? ACTIVESHDTEXTY : INACTIVESHDTEXTY ) ;
                }

                painter2.drawImage( dx, dy, isActive() ? activeShadowImg_ : inActiveShadowImg_, 0, 0, isActive() ? QMIN( activeShadowImg_.width(), title.width() ) : QMIN( inActiveShadowImg_.width(), title.width() ), isActive() ? activeShadowImg_.height() : inActiveShadowImg_.height() );
            }


            //draw title text
            painter2.setFont( options() ->font( isActive(), FALSE ) );
            painter2.setPen( options() ->color( KDecoration::ColorFont, isActive() ) );

            Qt::AlignmentFlags titleAlignBak = TITLEALIGN;
            if ( captionWidth > title.width() )
                titleAlignBak = Qt::AlignLeft;

            painter2.drawText( tx + MARGIN, ty, tw - ( MARGIN * 2 ), th, titleAlignBak | AlignVCenter, caption() );
        }
        painter2.end();
        painter.drawPixmap( 0, 0, pix );


        // draw frames
        if ( ! isShade() || SHOWBTMBORDER )
        {

            if ( h - TITLESIZE - BUTTOMFRAMESIZE > 0 )
            {
                int leftRightFramesHeight = h - TITLESIZE - BUTTOMFRAMESIZE ;

                //left frame
                //top
                rect.setRect( 0, TITLESIZE , LEFTFRAMESIZE, QMIN( TOPLEFTFRAMEHEIGHT, leftRightFramesHeight ) );

                painter.drawTiledPixmap( rect, isActive() ? decoFactory_->topLeftFrameBg_ : decoFactory_->topLeftFrameBgInAct_ );

                // mid
                if ( leftRightFramesHeight > TOPLEFTFRAMEHEIGHT + BOTTOMLEFTFRAMEHEIGHT )
                {
                    rect.setRect( 0, TITLESIZE + TOPLEFTFRAMEHEIGHT , LEFTFRAMESIZE, leftRightFramesHeight - TOPLEFTFRAMEHEIGHT - BOTTOMLEFTFRAMEHEIGHT );

                    painter.drawTiledPixmap( rect, isActive() ? decoFactory_->midLeftFrameBg_ : decoFactory_->midLeftFrameBgInAct_ );
                }

                // buttom
                if ( leftRightFramesHeight > TOPLEFTFRAMEHEIGHT )
                {
                    rect.setRect( 0, QMAX( h - BUTTOMFRAMESIZE - BOTTOMLEFTFRAMEHEIGHT, TITLESIZE + TOPLEFTFRAMEHEIGHT ) , LEFTFRAMESIZE, QMIN( BOTTOMLEFTFRAMEHEIGHT, leftRightFramesHeight - TOPLEFTFRAMEHEIGHT ) );

                    painter.drawTiledPixmap( rect.x(), rect.y(), rect.width(), rect.height(), isActive() ? decoFactory_->buttomLeftFrameBg_ : decoFactory_->buttomLeftFrameBgInAct_, 0, ( leftRightFramesHeight > TOPLEFTFRAMEHEIGHT + BOTTOMLEFTFRAMEHEIGHT ) ? 0 : TITLESIZE + TOPLEFTFRAMEHEIGHT - ( h - BUTTOMFRAMESIZE - BOTTOMLEFTFRAMEHEIGHT ) );
                }


                //rightFrame
                // top
                rect.setRect( w - RIGHTFRAMESIZE, TITLESIZE , RIGHTFRAMESIZE, QMIN( TOPRIGHTFRAMEHEIGHT, leftRightFramesHeight ) );

                painter.drawTiledPixmap( rect, isActive() ? decoFactory_->topRightFrameBg_ : decoFactory_->topRightFrameBgInAct_ );

                // mid
                if ( leftRightFramesHeight > TOPRIGHTFRAMEHEIGHT + BOTTOMRIGHTFRAMEHEIGHT )
                {
                    rect.setRect( w - RIGHTFRAMESIZE, TITLESIZE + TOPRIGHTFRAMEHEIGHT, RIGHTFRAMESIZE, leftRightFramesHeight - TOPRIGHTFRAMEHEIGHT - BOTTOMRIGHTFRAMEHEIGHT );

                    painter.drawTiledPixmap( rect, isActive() ? decoFactory_->midRightFrameBg_ : decoFactory_->rightFrameBgInAct_ );
                }

                // bottom
                if ( leftRightFramesHeight > TOPRIGHTFRAMEHEIGHT )
                {
                    rect.setRect( w - RIGHTFRAMESIZE, QMAX( h - BUTTOMFRAMESIZE - BOTTOMRIGHTFRAMEHEIGHT, TITLESIZE + TOPRIGHTFRAMEHEIGHT ) , RIGHTFRAMESIZE, QMIN( BOTTOMRIGHTFRAMEHEIGHT, leftRightFramesHeight - TOPRIGHTFRAMEHEIGHT ) );

                    painter.drawTiledPixmap( rect.x(), rect.y(), rect.width(), rect.height(), isActive() ? decoFactory_->buttomRightFrameBg_ : decoFactory_->buttomRightFrameBgInAct_, 0, ( leftRightFramesHeight > TOPRIGHTFRAMEHEIGHT + BOTTOMRIGHTFRAMEHEIGHT ) ? 0 : TITLESIZE + TOPRIGHTFRAMEHEIGHT - ( h - BUTTOMFRAMESIZE - BOTTOMRIGHTFRAMEHEIGHT ) );
                }
            }


            // buttom frame
            if ( w > 0 )
            {
                // left
                rect.setRect( 0 , h - BUTTOMFRAMESIZE, QMIN( LEFTBOTTOMFRAMEWIDTH, w ) , BUTTOMFRAMESIZE );

                painter.drawTiledPixmap( rect, isActive() ? decoFactory_->leftButtomFrameBg_ : decoFactory_->leftButtomFrameBgInAct_ );

                // mid
                if ( w > LEFTBOTTOMFRAMEWIDTH + RIGHTBOTTOMFRAMEWIDTH )
                {
                    rect.setRect( LEFTBOTTOMFRAMEWIDTH , h - BUTTOMFRAMESIZE, w - LEFTBOTTOMFRAMEWIDTH - RIGHTBOTTOMFRAMEWIDTH, BUTTOMFRAMESIZE );

                    painter.drawTiledPixmap( rect, isActive() ? decoFactory_->midButtomFrameBg_ : decoFactory_->midButtomFrameBgInAct_ );
                }

                // right
                if ( w > LEFTBOTTOMFRAMEWIDTH )
                {
                    rect.setRect( QMAX( w - RIGHTBOTTOMFRAMEWIDTH, LEFTBOTTOMFRAMEWIDTH ) , h - BUTTOMFRAMESIZE, QMIN( RIGHTBOTTOMFRAMEWIDTH, w - LEFTBOTTOMFRAMEWIDTH ) , BUTTOMFRAMESIZE );

                    painter.drawTiledPixmap( rect.x(), rect.y(), rect.width(), rect.height(), isActive() ? decoFactory_->rightButtomFrameBg_ : decoFactory_->rightButtomFrameBgInAct_, ( w > LEFTBOTTOMFRAMEWIDTH + RIGHTBOTTOMFRAMEWIDTH ) ? 0 : LEFTBOTTOMFRAMEWIDTH - ( w - RIGHTBOTTOMFRAMEWIDTH ), 0 );
                }
            }
        }
        else
        {
            painter.setPen( QColor( 70, 70, 70 ) );
            painter.drawLine( 0 , h - 1, w, h - 1 );
        }
    }
}

//////////////////////////////////////////////////////////////////////////////
// update_captionBuffer()
// ------------
//
void DeKoratorClient::updateCaptionBuffer()
{
    if ( !DeKoratorFactory::initialized() ) return ;

    QPainter painter;
    QString c( caption() );
    QFontMetrics fm( options() ->font( isActive() ) );
    int captionWidth = fm.width( c );
    int captionHeight = fm.height( );
    QPixmap textPixmap;

    // prepare the shadow
    textPixmap = QPixmap( captionWidth + ( MARGIN * 2 ) , captionHeight ); // 2*2 px shadow space
    textPixmap.fill( QColor( 0, 0, 0 ) );
    textPixmap.setMask( textPixmap.createHeuristicMask( TRUE ) );
    painter.begin( &textPixmap );
    painter.setFont( options() ->font( isActive(), FALSE ) );
    painter.setPen( white );
    painter.drawText( textPixmap.rect(), AlignCenter, caption() );
    painter.end();


    ShadowEngine se;
    //if ( isActive() )
    activeShadowImg_ = se.makeShadow( textPixmap, ACTIVESHADECOLOR );
    //else
    inActiveShadowImg_ = se.makeShadow( textPixmap, INACTIVESHADECOLOR );

    captionBufferDirty_ = false;
}



//////////////////////////////////////////////////////////////////////////////
// resizeEvent()
// -------------
// Window is being resized

void DeKoratorClient::resizeEvent( QResizeEvent * )
{
    if ( widget() ->isShown() )
    {
        QRegion region = widget() ->rect();
        region = region.subtract( titleBarSpacer_->geometry() );
        widget() ->erase( region );
    }
    if ( USEMASKS )
        doShape();
}

//////////////////////////////////////////////////////////////////////////////
// showEvent()
// -----------
// Window is being shown

void DeKoratorClient::showEvent( QShowEvent * )
{
    widget() ->repaint();
    if ( USEMASKS )
        doShape();
}

//////////////////////////////////////////////////////////////////////////////
// maxButtonPressed()
// -----------------
// Max button was pressed

void DeKoratorClient::maxButtonPressed()
{
    if ( button[ ButtonMax ] )
    {
#if KDE_IS_VERSION(3, 3, 0)
        maximize( button[ ButtonMax ] ->lastMousePress() );
#else
        switch ( button[ ButtonMax ] ->lastMousePress() )
        {
        case MidButton:
            maximize( maximizeMode() ^ MaximizeVertical );
            break;
        case RightButton:
            maximize( maximizeMode() ^ MaximizeHorizontal );
            break;
        default:
            ( maximizeMode() == MaximizeFull ) ? maximize( MaximizeRestore )
            : maximize( MaximizeFull );
        }
#endif

    }
}

//////////////////////////////////////////////////////////////////////////////
// shadeButtonPressed()
// -----------------
// Shade button was pressed

void DeKoratorClient::shadeButtonPressed()
{
    if ( button[ ButtonShade ] )
    {
        setShade( !isSetShade() );
    }
}

//////////////////////////////////////////////////////////////////////////////
// aboveButtonPressed()
// -----------------
// Above button was pressed

void DeKoratorClient::aboveButtonPressed()
{
    if ( button[ ButtonAbove ] )
    {
        setKeepAbove( !keepAbove() );
    }
}

//////////////////////////////////////////////////////////////////////////////
// belowButtonPressed()
// -----------------
// Below buttQt::green; //on was pressed

void DeKoratorClient::belowButtonPressed()
{
    if ( button[ ButtonBelow ] )
    {
        setKeepBelow( !keepBelow() );
    }
}

//////////////////////////////////////////////////////////////////////////////
// menuButtonPressed()
// -------------------
// Menu button was pressed (popup the menu)

void DeKoratorClient::menuButtonPressed()
{
    //     if ( button[ ButtonMenu ] )
    //     {
    //         QPoint p( button[ ButtonMenu ] ->rect().bottomLeft().x(),
    //                   button[ ButtonMenu ] ->rect().bottomLeft().y() );
    //         KDecorationFactory* f = factory();
    //         showWindowMenu( button[ ButtonMenu ] ->mapToGlobal( p ) );
    //         if ( !f->exists( this ) ) return ; // decoration was destroyed
    //         button[ ButtonMenu ] ->setDown( FALSE );
    //     }

    static QTime * t = NULL;
    static DeKoratorClient* lastClient = NULL;
    if ( t == NULL )
        t = new QTime;
    bool dbl = ( lastClient == this && t->elapsed() <= QApplication::doubleClickInterval() );
    lastClient = this;
    t->start();
    if ( !dbl || !DBLCLKCLOSE )
    {
        QPoint p( button[ ButtonMenu ] ->rect().bottomLeft().x(),
                  button[ ButtonMenu ] ->rect().bottomLeft().y() );
        KDecorationFactory* f = factory();
        showWindowMenu( button[ ButtonMenu ] ->mapToGlobal( p ) );
        if ( !f->exists( this ) ) return ; // decoration was destroyed
        button[ ButtonMenu ] ->setDown( FALSE );
    }
    else
        closing_ = true;
}

//////////////////////////////////////////////////////////////////////////////
// menuButtonReleased()
// -------------------
//
void DeKoratorClient::menuButtonReleased()
{
    if ( closing_ )
        closeWindow();
}

//////////////////////////////////////////////////////////////////////////////
// doShape()
// -------------------
//

void DeKoratorClient::doShape()
{
    QRegion mask( 0, 0, width(), height() );
    // QRegion m(width()-MARGIN, 0, MARGIN, TITLESIZE );
    // m.subtract((QRegion( decoFactory_->topRightCornerBitmap_ ) );

    // top left
    QRegion m = QRegion( decoFactory_->topLeftCornerBitmap_ );
    mask -= QRegion( m );

    //top right
    m = QRegion( decoFactory_->topRightCornerBitmap_ );
    m.translate( width() - decoFactory_->topRightCornerBitmap_.width(), 0 );
    mask -= QRegion( m );

    if ( !isShade() || SHOWBTMBORDER )
    {
        //buttom left
        m = QRegion( decoFactory_->buttomLeftCornerBitmap_ );
        m.translate( 0, height() - decoFactory_->buttomLeftCornerBitmap_.height() );
        mask -= QRegion( m );

        //buttom right
        m = QRegion( decoFactory_->buttomRightCornerBitmap_ );
        m.translate( width() - decoFactory_->buttomRightCornerBitmap_.width(), height() - decoFactory_->buttomRightCornerBitmap_.height() );
        mask -= QRegion( m );
    }

    setMask( mask );


    // Remove top-right corner.
    //     mask -= QRegion( r - 5, 0, 5, 1 );
    //     mask -= QRegion( r - 3, 1, 3, 1 );
    //     mask -= QRegion( r - 2, 2, 2, 1 );
    //     mask -= QRegion( r - 1, 3, 1, 2 );


    //     // Remove bottom-left corner.
    //     mask -= QRegion( 0, b - 0, 5, 1 );
    //     mask -= QRegion( 0, b - 1, 3, 1 );
    //     mask -= QRegion( 0, b - 2, 2, 1 );
    //     mask -= QRegion( 0, b - 4, 1, 2 );
    //
    //     // Remove bottom-right corner.
    //     mask -= QRegion( r - 5, b - 0, 5, 1 );
    //     mask -= QRegion( r - 3, b - 1, 3, 1 );
    //     mask -= QRegion( r - 2, b - 2, 2, 1 );
    //     mask -= QRegion( r - 1, b - 4, 1, 2 );

    //     setMask( mask );
}


#include "deKoratorclient.moc"
