/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License, Version 2.  See the file "COPYING" in the main directory of this
 * archive for more details.
 */

/* ELF header e_flags defines. MIPS architecture level. */
#define EF_MIPS_ARCH_1      0x00000000  /* -mips1 code.  */
#define EF_MIPS_ARCH_2      0x10000000  /* -mips2 code.  */
#define EF_MIPS_ARCH_3      0x20000000  /* -mips3 code.  */
#define EF_MIPS_ARCH_4      0x30000000  /* -mips4 code.  */
#define EF_MIPS_ARCH_5      0x40000000  /* -mips5 code.  */
#define EF_MIPS_ARCH_32     0x50000000  /* MIPS32 code.  */
#define EF_MIPS_ARCH_64     0x60000000  /* MIPS64 code.  */
/* The ABI of a file. */
#define EF_MIPS_ABI_O32     0x00001000  /* O32 ABI.  */
#define EF_MIPS_ABI_O64     0x00002000  /* O32 extended for 64 bit.  */

/*
 * These are used to set parameters in the core dumps.
 */
#define ELF_CLASS	ELFCLASS32
#ifdef __MIPSEB__
#define ELF_DATA	ELFDATA2MSB
#elif __MIPSEL__
#define ELF_DATA	ELFDATA2LSB
#endif
#define ELF_ARCH	EM_MIPS
