#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

class plugin_CPUMonitor:

	def __init__(self, parent, location):
		self.parent = parent
		self.location = location 

		import os
		self.os = os

		self.warningLevel = self.parent.preferences.get('plugin_cpumonitor_warn')
		self.fatalLevel   = self.parent.preferences.get('plugin_cpumonitor_fatal')
		self.maxTimer     = self.parent.preferences.get('plugin_cpumonitor_persist')	

		if self.warningLevel is None:
			self.warningLevel = 40
		if self.fatalLevel is None:
			self.fatalLevel = 80
		if self.maxTimer is None:
			self.maxTimer = 10

		self.warningLevel = int(float(self.warningLevel))
		self.fatalLevel	= int(float(self.fatalLevel))
		self.maxTimer     = int((1000*float(self.maxTimer))/dc.UPDATE_INTERVAL)

		self.warningTimer = 0
		self.fatalTimer = 0

		# Detect the Jiffy parameter, in a really bad way
		dc.debugmsg("Detecting Jiffy...")
		p = self.os.popen('grep -r "define HZ" /usr/include/asm*')
		data = p.readlines()
		p.close()

		HZ = 0
		for line in data:
			currHZ = line.split(" ")[-1]
			if HZ == 0:
				HZ = currHZ
			else:
				if not currHZ == HZ:
					HZ = 0
					break

		if HZ == 0:
			self.parent.addMessage("CPU Monitor: Cannot determine Jiffy; aborting. Dump: " + str(data), "C")

			dc.debugmsg("CPU Monitor: Cannot determine Jiffy; aborting. Dump: " + str(data))

		self.HZ = int(HZ)

		dc.debugmsg("          Jiffy: " + str(self.HZ))

		self.oldJiffies = 0

	def shutdown(self):
		pass

	def update(self):
		if self.HZ == 0:
			self.parent.statusBarTempMessage = self.parent.statusBarTempMessage + dc.STATUSBAR_DIVIDER + "[CPU: X" + "]"
			return

		pid = self.os.getpid()

##### Old method, with PS. But PS smooths it out
#		p = self.os.popen("ps -p " + str(pid) + " -o pcpu")
#		data = p.readlines()
#		cpu = float(data[-1].replace("\n", ""))

		p = self.os.popen("cat /proc/" + str(pid) + "/stat")
		data = p.readline()
		p.close()

		fields = data.split(" ")
		newJiffies = int(fields[13]) + int(fields[14])
		cpu = newJiffies - self.oldJiffies
		self.oldJiffies = newJiffies

		cpu = (100*1000*cpu) / (self.HZ * dc.UPDATE_INTERVAL)

		if cpu > 110: # If we are really really far off, then we should just ignore it all
			cpu = -1

		severity = ""

		(passed, self.warningTimer, message) = self.checkOne(cpu, self.warningLevel, 
																			  self.warningTimer, self.maxTimer)
		if passed:
			severity = "W"

		(passed, self.fatalTimer, message2) = self.checkOne(cpu, self.fatalLevel, 
																			self.fatalTimer, self.maxTimer)
		if passed:
			severity = "F"
		if not message2 == "":
			message = message2 + "\n\n" + _("Shutting down Deluge immediately.")

		if not severity == "":
			severityText = " (" + severity + ")"
		else:
			severityText = ""

		self.parent.statusBarTempMessage = self.parent.statusBarTempMessage + dc.STATUSBAR_DIVIDER + "[CPU: " + str(cpu) + "%" + severityText + "]"

		if not message == "":
			self.parent.addMessage(message, severity)

		if not message2 == "":
			print _("Shutting down Deluge immediately (CPU overload).") # NOT a debug msg on purpose
			self.parent.ShutDown()
			self.parent.SafeDestroy(None)

	def checkOne(self, cpu, level, timer, maxTimer):
		if cpu > level:
#			print cpu, "is more than", level
			timer = timer + 1
			if timer >= maxTimer:
				message = _("CPU usage warning: more than") + " " + str(level) + "% " + _("CPU usage for") + " " + str(maxTimer) + " " + _("seconds")
				return (True, 0, message)
			else:
				return (True, timer, "")
		else:
#			print cpu, "<", level
			timer = max(timer - 1, 0)
			return (False, timer, "")

	def configure(self):
		self.gladefile = self.location + "/" + "CPUMonitorConfig.glade"
		self.wTree = gtk.glade.XML(self.gladefile, "CPUMonitorConfig")
		self.dlg = self.wTree.get_widget("CPUMonitorConfig")

		self.spinWarn    = self.wTree.get_widget("spin_warn")
		self.spinFatal   = self.wTree.get_widget("spin_fatal")
		self.spinPersist = self.wTree.get_widget("spin_persist")

		self.spinWarn.set_value(self.warningLevel)
		self.spinFatal.set_value(self.fatalLevel)
		self.spinPersist.set_value(self.maxTimer)

		# Show and run

		self.dlg.show_all()

		if self.dlg.run() == 1:
			self.parent.preferences.set('plugin_cpumonitor_warn',    self.spinWarn.get_value())
			self.parent.preferences.set('plugin_cpumonitor_fatal',   self.spinFatal.get_value())
			self.parent.preferences.set('plugin_cpumonitor_persist', self.spinPersist.get_value())

			self.warningLevel = self.spinWarn.get_value()
			self.fatalLevel   = self.spinFatal.get_value()
			self.maxTimer     = self.spinPersist.get_value()

		self.dlg.destroy()


PLUGINregister("CPU Monitor", # Name to appear on plugin in plugin manager
               plugin_CPUMonitor,		# The plugin class defined before
               True,
               False, # whether this plugin should be activated by default, for
                      # users with no preference for this plugin as of yet. This
                      # is only of effect the FIRST time a user loads a plugin,
                      # afterwards the user's preferences are the default. Thus,
                      # this is of use in the scenario where you roll out a new
                      # plugin, and want users to have it activated automatically
               "CPU Monitor v0.1\n\nMonitors Deluge's CPU usage. May be useful on Edgy.\n\nWARNING: if CPU usage passes the 'Fatal' line (80% by default) then Deluge will be shut down immediately.\n\nWritten by Kripkenstein")
