#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

#!/usr/bin/python
#
# dnetworkgraph.py
# The Preferences Class
#

class plugin_NetworkGraph:
	def __init__(self, parent, location):
		self.parent   = parent
		self.location = location

		self.icon  = gtk.Image()
		self.icon.set_from_file(dc.get_icon("netgraph-16.png"))

		self.image  = gtk.Image()

		self.viewPort = gtk.Viewport()
		self.viewPort.add(self.image)

		self.scrolledWindow = gtk.ScrolledWindow()
		self.scrolledWindow.add(self.viewPort)
		self.scrolledWindow.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)

		self.topWidget = self.scrolledWindow

		self.parentNotebook = self.parent.sidebar
#		print "Parent NOTEBOOK:", self.parentNotebook
		self.parentNotebook.append_page(self.topWidget, self.icon)
#		print "My INDEX in parentNoteBook:", self.index

		self.image.show()
		self.viewPort.show()
		self.scrolledWindow.show()

		self.length = 60

		self.width  = -1
		self.height = -1

		import pango

		self.pangoContext = self.parent.window.get_pango_context()
		self.pangoLayout = pango.Layout(self.pangoContext)

		self.savedUpSpeeds   = []
		self.savedDownSpeeds = []

		self.bootupRuns = 3  # This ensures that we pass the resizing phase, with scrollbars, etc.
									# So the first time it is viewed, we are all ready

	def shutdown(self): # Shutdown is called when the plugin is deactivated
		numPages = self.parentNotebook.get_n_pages()
		for page in range(numPages):
			if self.parentNotebook.get_nth_page(page) == self.topWidget:
				self.parentNotebook.remove_page(page)
				break

	def configure(self):
		pass

	def update(self):
		self.savedUpSpeeds.insert(0, self.parent.sessionInfo['uploadRate'])
		if len(self.savedUpSpeeds) > self.length:
			self.savedUpSpeeds.pop()
		self.savedDownSpeeds.insert(0, self.parent.sessionInfo['downloadRate'])
		if len(self.savedDownSpeeds) > self.length:
			self.savedDownSpeeds.pop()

		if not self.parentNotebook.get_nth_page(self.parentNotebook.get_current_page()) == \
				 self.topWidget and not self.bootupRuns > 0:
			return

		self.bootupRuns = max(self.bootupRuns - 1, 0)

		extraWidth  = self.scrolledWindow.get_vscrollbar().get_allocation().width  * 1.5
		extraHeight = self.scrolledWindow.get_hscrollbar().get_allocation().height * 1.5
		allocation = self.scrolledWindow.get_allocation()
		allocation.width  = int(allocation.width)  - extraWidth
		allocation.height = int(allocation.height) - extraHeight

		# Don't try to allocate a size too small, or you might crash
		if allocation.width < 2 or allocation.height < 2:
			return

#		savedDownSpeeds = [1,2,3,2,1]
#		savedUpSpeeds = [5,8,0,0,1,2]

#		allocation = self.image.get_allocation()
#		allocation.width  = 300
#		allocation.height = 200

		if not allocation.width == self.width or not allocation.height == self.height:
#			print "New Pixmap!"
			self.width  = allocation.width
			self.height = allocation.height

			self.networkPixmap = gtk.gdk.Pixmap(None, self.width, self.height, 24)
			self.image.set_from_pixmap(self.networkPixmap, None)
			self.ctx = self.networkPixmap.cairo_create()

		self.networkPixmap.draw_rectangle(self.image.get_style().white_gc,True, 0, 0, self.width, self.height)

		maxSpeed = max(max(self.savedDownSpeeds),max(self.savedUpSpeeds))

		if maxSpeed == 0:
			return

		maxSpeed = maxSpeed*1.1 # Give some extra room on top

		self.drawSpeedPoly(self.savedDownSpeeds, (0.5,1,   0.5, 1.0),    maxSpeed, True)
		self.drawSpeedPoly(self.savedDownSpeeds, (0,  0.75,0,   1.0),    maxSpeed, False)

		self.drawSpeedPoly(self.savedUpSpeeds,   (0.33,0.33,1.0,  0.5),  maxSpeed, True)
		self.drawSpeedPoly(self.savedUpSpeeds,   (0,   0,   1.0,  0.75), maxSpeed, False)

		meanUpSpeed   = sum(self.savedUpSpeeds)  /len(self.savedUpSpeeds)
		meanDownSpeed = sum(self.savedDownSpeeds)/len(self.savedDownSpeeds)
		shownSpeed    = max(meanUpSpeed, meanDownSpeed)

		self.pangoLayout.set_text(dc.getDataRate(shownSpeed))
		self.networkPixmap.draw_layout(self.image.get_style().black_gc,
												 4,
												 int(self.height - 1 - (self.height*shownSpeed/maxSpeed)),
												 self.pangoLayout)

		self.networkPixmap.draw_line(self.image.get_style().black_gc,
											  0,			  int(self.height - (self.height*shownSpeed/maxSpeed)),
											  self.width, int(self.height - (self.height*shownSpeed/maxSpeed)))

		self.networkPixmap.draw_rectangle(self.image.get_style().black_gc,False, 0, 0, self.width-1, self.height-1)

		self.image.queue_draw()

	def tracePath(self, speeds, maxSpeed):
		lineWidth = 4

		self.ctx.set_line_width(lineWidth)

		self.ctx.move_to(self.width + lineWidth,self.height + lineWidth)
		self.ctx.line_to(self.width + lineWidth,int(self.height-(self.height*speeds[0]/maxSpeed)))

		for i in range(len(speeds)):
			self.ctx.line_to(int(self.width-1-((i*self.width)/(self.length-1))),
									int(self.height-1-(self.height*speeds[i]/maxSpeed)))

		self.ctx.line_to(int(self.width-1-(((len(speeds)-1)*self.width)/(self.length-1))),
								int(self.height)-1 + lineWidth)

		self.ctx.close_path()

	def drawSpeedPoly(self, speeds, color, maxSpeed, fill):

		self.tracePath(speeds, maxSpeed)
		self.ctx.set_source_rgba(color[0],color[1],color[2], color[3])

		if fill:
			self.ctx.fill()
		else:
			self.ctx.stroke()


### Register plugin with Deluge

PLUGINregister("Network Activity Graph",
					plugin_NetworkGraph,
					False, # whether this plugin has a 'configuration' option
					False,
					"Network Activity Graph plugin v0.1\n\nWritten by Kripkenstein")
