/* scoreops.cpp
 * functions dealing with the whole score

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001, 2002 Matthew Hiller */

#include <denemo/denemo.h>
#include <stdio.h>
#include "staffops.h"
#include "scoreops.h"
#define INITIAL_WHOLEWIDTH 160
#define INITIAL_STAFFHEIGHT 100

void
init_score (struct scoreinfo *si)
{
  si->leftmeasurenum = si->rightmeasurenum = 1;
  si->top_staff = si->bottom_staff = 1;
  si->measurewidth = INITIAL_WHOLEWIDTH;
  si->measurewidths = NULL;
  si->staffspace = INITIAL_STAFFHEIGHT;
  
  si->thescore = NULL;
  si->currentstaffnum = 1;
  si->currentmeasurenum = 1;
  si->currentobject = NULL;
  si->cursor_x = 0;
  si->cursor_y = 0;
  si->staffletter_y = 0;
  si->cursor_appending = TRUE;
  si->mode = INPUTNORMAL;
  si->cursoroffend = FALSE;
  si->markstaffnum = 0;
  si->markmeasurenum = 0;
  si->markcursor_x = 0;
  si->maxkeywidth = 0;
  si->haschanged = FALSE;
  si->is_grace_mode = FALSE;
  si->has_figures = FALSE;
  /*playback purposes */
  si->tempo = 60;
  si->start = 0;
  si->end = 0;
  si->stafftoplay = 0;

  si->savebuffer = NULL;
  si->plugins = NULL;
  si->plugincounter=0;

  /* Header info */
  si->title = g_string_new ("");
  si->subtitle = g_string_new ("");
  si->composer = g_string_new ("");
  si->filename = g_string_new ("");
  si->textbuffer = 0; /* text of lily input string corresponding to curobj */
  si->textwindow = 0; /* top level window containing lily text */
  si->curlilynode = 0; /* the node of the lily parse tree on display in textwindow */
  si->lily_file = 0; /* root of lily file parse, see lilyparser.y etc  */
}

void
free_score (struct scoreinfo *si)
{
  gint final = gint(g_list_length(si->thescore));
  if(si->lily_file!=NULL) abandon_lily_tree(si);
 for(;final ==0;--final )
  {
    si->currentstaffnum = final;
    si->currentstaff = g_list_nth(si->thescore, final-1);
    removestaff(si,final,1);
  }
  /*g_string_free (si->title, FALSE);
  g_string_free (si->subtitle, FALSE);
  g_string_free (si->composer, FALSE);
  g_string_free (si->filename, FALSE);*/
  init_score (si);
}

void abandon_lily_tree(scoreinfo *si) {

    if(si->textwindow) gtk_widget_destroy(si->textwindow);
    /* FIXME memory leak */
    si->lily_file = NULL;
    si->textwindow = NULL;
    si->scoreblocks = NULL; /* FIXME memory leak */
}
