//-----------------------------------------------------------------------------
//
// ImageLib Utility Sources
// Copyright (C) 2000-2008 by Denton Woods
// Last modified: 11/08/2008
//
// Filename: src-ILU/include/ilu_error/ilu_err-spanish.h
//
// Description: Error functions in Spanish, translated by Carlos Aragons
//
//-----------------------------------------------------------------------------


#ifndef ILU_ERR_SPANISH_H
#define ILU_ERR_SPANISH_H

#include "ilu_internal.h"

ILconst_string iluErrorStringsSpanish[IL_FILE_READ_ERROR - IL_INVALID_ENUM + 1] = {
	IL_TEXT("enumerador incorrecto"),
    IL_TEXT("no queda memoria disponible"),
	IL_TEXT("formato no soportado todava"),
	IL_TEXT("error interno"),
	IL_TEXT("valor incorrecto"),
    IL_TEXT("operacin ilegaIL_TEXT("),
	IL_TEXT("valor de fichero ilegaIL_TEXT("),
	IL_TEXT("cabecera incorrecta"),
	IL_TEXT("parmetro incorrecto"),
	IL_TEXT("no se puede abrir el fichero"),
	IL_TEXT("extensin desconocida"),
	IL_TEXT("el fichero ya existe"),
	IL_TEXT("formato de salida equivalente"),
	IL_TEXT("desbordamiento superior de pila"),
    IL_TEXT("desbordamiento inferior de pila"),
	IL_TEXT("conversin incorrecta"),
	IL_TEXT("nmero de dimensiones incorrecto"),
	IL_TEXT("error de lectura en el fichero")
};

ILconst_string iluLibErrorStringsSpanish[IL_LIB_MNG_ERROR - IL_LIB_GIF_ERROR + 1] = {
	IL_TEXT("error en la librera gif"),  // the correct translation will be 'error en la biblioteca gif', but nobody in spain uses the word 'biblioteca' for the translation the word 'library'. Almost all Spanish programmers translate 'library' incorrectly to 'librera'.
	IL_TEXT("error en la librera jpeg"),
	IL_TEXT("error en la librera png"),
	IL_TEXT("error en la librera tiff"),
	IL_TEXT("error en la librera mng")
};

ILconst_string iluMiscErrorStringsSpanish[2] = {
	IL_TEXT("no error"),
	IL_TEXT("unknown error")
};

#endif//ILU_ERR_SPANISH_H