with Ada.Environment_Variables;

package body Environment_Variable_Backups is

   use Variable_Maps;

   procedure Restore
     (Changes : in Backup)
   is
      Var : Cursor := First (Changes);
   begin
      while Var /= No_Element loop
         if Element (Var).Was_Set then
            Ada.Environment_Variables.Set (Key (Var), Element (Var).Value);
         else
            Ada.Environment_Variables.Clear (Key (Var));
         end if;
         Next (Var);
      end loop;
   end Restore;

   procedure Set
     (Name      : in     String;
      New_Value : in     String;
      Changes   : in out Backup)
   is
      --  This curious call to Insert is such that no overwrite occurs
      --  if the Key has allready been changed.
      Indifferent_Cursor : Cursor;
      Spiceless_Boolean  : Boolean;
   begin
      if Ada.Environment_Variables.Exists (Name) then
         declare
            Old_Value : constant String
              := Ada.Environment_Variables.Value (Name);
         begin
            Insert (Container => Changes,
                    Key       => Name,
                    New_Item  => (True, Old_Value'Length, Old_Value),
                    Position  => Indifferent_Cursor,
                    Inserted  => Spiceless_Boolean);
         end;
      else
         Insert (Container => Changes,
                 Key       => Name,
                 New_Item  => (False, 0),
                 Position  => Indifferent_Cursor,
                 Inserted  => Spiceless_Boolean);
      end if;
      Ada.Environment_Variables.Set (Name, New_Value);
      pragma Unreferenced (Indifferent_Cursor);
      pragma Unreferenced (Spiceless_Boolean);
   end Set;

end Environment_Variable_Backups;
