#!/usr/bin/env ruby

require 'xapian'

class Index
  def initialize(path)
    @path = path
    @xapian_database = Xapian::Database.new(@path)
  end

  def search(terms, user_opts={})
    opts = {:offset => 0, :limit => 10}.merge(user_opts)

    query_parser = Xapian::QueryParser.new
    query_parser.database = @xapian_database
    query_parser.stemmer = Xapian::Stem.new("english")
    query_parser.stemming_strategy = Xapian::QueryParser::STEM_SOME

    enquire = Xapian::Enquire.new(@xapian_database)
    enquire.query = query_parser.parse_query(terms)
    return XapianResultSet.new(enquire.mset(opts[:offset], opts[:limit]))
  end
end

class SearchResultSet; end

class XapianResultSet < SearchResultSet
  def initialize(mset)
    @mset = mset
  end

  def each(&blk)
    @mset.matches.each &blk
  end

  def page_size
    @mset.size
  end

  def total_results
    @mset.matches_estimated
  end
end

if ARGV.size < 2
  $stderr.puts "Usage: #{$0} PATH_TO_DATABASE QUERY"
  exit 99
end

# Open the database for searching.
database = Index.new(ARGV[0])
result_set = database.search(ARGV[1..-1].join(' '))

# Display the results.
puts "#{result_set.total_results} results found."
puts "Matches 1-#{result_set.page_size}:\n"

result_set.each {|m|
  puts "#{m.rank + 1}: #{m.percent}% docid=#{m.docid} [#{m.document.data}]\n"
}
