#!/bin/sh
#
# $Id: cflags.sh,v 1.16 2004-02-26 10:19:20-08 bll Exp $
# $Source: /home/bll/DI/features.base/RCS/cflags.sh,v $
# Copyright 2001-2002 Brad Lanam, Walnut Creek, California USA
#

bit64="0"
case $1 in
    -64)
        bit64="1"
        ;;
esac

## need path separator...
tpath=`echo $PATH | sed 's/:/ /g'`
set ${tpath}
for i in $@
do
    if [ -x "$i/uname" ]
    then
        xuname="$i/uname"
    fi
    if [ -x "$i/getconf" ]
    then
        xgetconf="$i/getconf"
    fi
done

if [ "${xuname}" != "" ]
then
    SYSTYPE=`${xuname} -s`
    SYSREV=`${xuname} -r`
    SYSARCH=`${xuname} -m`
    case ${SYSTYPE} in
        AIX)
            tmp=`( (oslevel) 2>/dev/null || echo "not found") 2>&1`
            case "$tmp" in
                'not found') SYSREV="$4"."$3" ;;
                '<3240'|'<>3240') SYSREV=3.2.0 ;;
                '=3240'|'>3240'|'<3250'|'<>3250') SYSREV=3.2.4 ;;
                '=3250'|'>3250') SYSREV=3.2.5 ;;
                *) SYSREV=$tmp;;
            esac
            ;;
    esac
fi

CC=${CC:-cc}
ccflags="${CFLAGS:--O}"
ldflags="${LDFLAGS:-}"
libs="${LIBS:-}"

libs="$libs -lm"

vers="`${CC} -v 2>&1`" # attempt to get version...

if [ "${xgetconf}" != "" ]
then
    tccflags="`${xgetconf} LFS_CFLAGS 2>/dev/null`"
    tldflags="`${xgetconf} LFS_LDFLAGS 2>/dev/null`"
    tlibs="`${xgetconf} LFS_LIBS 2>/dev/null`"
fi

case ${CC} in
    *gcc)
        ccflags="-Wall -Waggregate-return -Wconversion -Wformat -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Wpointer-arith -Wshadow -Wstrict-prototypes -Wtraditional -Wunused $ccflags"
        vers=""  # we know it's gcc...don't run again
        case "${bit64}" in
            1)
                ccflags="-m64 $ccflags"
                ;;
        esac
        ;;
esac

case ${vers} in     # gcc in disguise...
    *gcc*)
        ccflags="-Wall -Waggregate-return -Wconversion -Wformat -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Wpointer-arith -Wshadow -Wstrict-prototypes -Wtraditional -Wunused $ccflags"
        case "${bit64}" in
            1)
                ccflags="-m64 $ccflags"
                ;;
        esac
        ;;
esac

case ${SYSTYPE} in
    AIX)
        ccflags="-qhalt=e $ccflags"
        case ${SYSREV} in
            4.*)
                ccflags="-DUSE_ETC_FILESYSTEMS=1 $ccflags"
                ;;
        esac
        ;;
    BeOS)
        case ${SYSARCH} in
            BePC)
                #libpth="/boot/develop/lib/x86"
                #libc="/boot/develop/lib/x86/libroot.so"
                libs="-lroot -lbe $libs"
                ;;
            *)
                #libpth="/boot/develop/lib/ppc" #???
                #libc="/boot/develop/lib/ppc/libroot.so" #???
                libs="-lroot -lbe $libs"
                ;;
        esac
        ;;
    OSF1)
        ccflags="-std1 $ccflags"
        ;;
    DYNIX)
        libs="-lseq $libs"
        ;;
    DYNIX/ptx)
        libs="-lseq $libs"
        ;;
    HP-UX)
        if [ "${tccflags}" = "" ]
        then
            ccflags="-D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64 $ccflags"
        fi
        case ${CC} in
            cc)
#                ccflags="+DAportable $ccflags"
                ccflags="-Ae $ccflags"
                ;;
        esac
        ;;
    IRIX*)
        case ${SYSREV} in
            [45].*)
                libs="-lsun"
                ;;
        esac
        ;;
    SunOS)
        case ${SYSREV} in
            5.*)
                case ${CC} in
                    cc)
                        # If solaris is compile w/strict ansi, we get
                        # a work-around for the long long type with
                        # large files.  So we compile w/extensions.
                        ccflags="-Xa -v $ccflags"
                        # optimization
                        ccflags="`echo $ccflags | sed 's,-xO. *,-xO4 ,'`"
                        ccflags="`echo $ccflags | sed 's,-O *,-xO4 ,'`"
                        echo $ccflags | grep -- '-xO4' >/dev/null 2>&1
                        case $rc in
                            0)
                                ldflags="-fast $ldflags"
                                ;;
                        esac

                        case "${bit64}" in
                            1)
                                ccflags="-xarch=v9 $ccflags"
                                ;;
                        esac
                        ;;
                esac
                ;;
        esac
        ;;
esac

# largefile stuff
ccflags="$ccflags $tccflags"
ldflags="$ldflags $tldflags"
libs="$libs $tlibs"

echo "CC=\"${CC}\""
echo "CFLAGS=\"$ccflags\""
echo "LDFLAGS=\"$ldflags\""
echo "LIBS=\"$libs\""
echo "export CC"
echo "export CFLAGS"
echo "export LDFLAGS"
echo "export LIBS"
exit 0
