# $Id: solaris.sh,v 1.7 2003-01-06 03:42:40-08 bll Exp $

libs="-lm"

case "$osvers" in
    2.[6-9]*)
		ccflags="`/usr/bin/getconf LFS_CFLAGS`"
		ldflags="`/usr/bin/getconf LFS_LDFLAGS`"
		libs="$libs `/usr/bin/getconf LFS_LIBS`"
		;;
    2.*|1*)	;;
    *)
		ccflags="`/usr/bin/getconf LFS_CFLAGS`"
		ldflags="`/usr/bin/getconf LFS_LDFLAGS`"
		libs="$libs `/usr/bin/getconf LFS_LIBS`"
		;;
esac

case "$cc" in
    *gcc*)      ccflags="-Wall -Waggregate-return -Wconversion -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Wpointer-arith -Wshadow -Wstrict-prototypes -Wtraditional $ccflags"
		;;
    *)          ccflags="-Xa -v -fast $ccflags"
                ldflags="-fast $ldflags"
                optimize=""
                case "$osvers" in
                    2.[7-9]*)
                        if [ -x /usr/bin/isainfo -a \
                            `uname -m` = sun4u -a \
                            `/usr/bin/isainfo -b` = 64 ]
                        then
                            cc64flags="-xarch=v9"
                            ld64flags="-xarch=v9"
                        fi
		        ;;
                esac
		;;
esac

