#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

/* include this first, before NO_IMPORT_PYGOBJECT is defined */
#include <pygobject.h>
#include <diacanvas/dia-canvas.h>


void pydiacanvas_add_constants (PyObject *module, const gchar *strip_prefix);
void pydiacanvas_register_classes (PyObject *d);

extern PyMethodDef pydiacanvas_functions[];

DL_EXPORT(void)
init_canvas (void)
{
	PyObject *m, *d, *tuple;

	/* Standard initialization: */
	init_pygobject ();

	if (!PyImport_ImportModule ("diacanvas.geometry")) {
		Py_FatalError ("could not import diacanvas.geometry");
		return;
	}

	if (!PyImport_ImportModule ("diacanvas.shape")) {
		Py_FatalError ("could not import diacanvas.shape");
		return;
	}

	m = Py_InitModule ("diacanvas._canvas", pydiacanvas_functions);
	d = PyModule_GetDict (m);

	/* diacanvas2 version */
	tuple = Py_BuildValue ("(iii)", DIACANVAS_MAJOR_VERSION,
				DIACANVAS_MINOR_VERSION,
				DIACANVAS_MICRO_VERSION);
	PyDict_SetItemString (d, "diacanvas_version", tuple);
	Py_DECREF (tuple);

	pydiacanvas_register_classes (d);
	pydiacanvas_add_constants (m, "DIA_");

	if (PyErr_Occurred ()) {
		Py_FatalError ("can't initialise module diacanvas._canvas");
	}
}

