/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/logger/intending_stream_logger.hpp
 *
 * @brief [LEVEL: beta] The @ref diagnostics::Intending_Stream_Logger class
 *
 * $Id: intending_stream_logger.hpp,v 1.4 2005/06/23 09:54:21 esdentem Exp $
 *
 * @test diagnostics/logger/intending_stream_logger.t.cpp
 *
 * @author Christian Schallhart
 */

#ifndef DIAGNOSTICS__LOGGER__INTENDING_STREAM_LOGGER_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__LOGGER__INTENDING_STREAM_LOGGER_HPP__INCLUDE_GUARD

// used as base class
#include <diagnostics/frame/logger.hpp>

// used in the interface by reference
#include <iostream>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Intending_Stream_Logger diagnostics/logger/intending_stream_logger.hpp
 *
 * @brief logs each @ref Record into a ::std::ostream. Only the level,
 * type, nr_what and str_what are logged. The records are intended
 * accordingly under the assumption that only thread is logging.
 *
 * @nosubgrouping
 */
class Intending_Stream_Logger :
    public Logger
{
	////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Types
     * @{
     */
private:
	typedef Intending_Stream_Logger Self;
	// @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
public:
    /**
     * @brief noop
     *
     * @throw never
     */
    virtual ~Intending_Stream_Logger();
    

    /**
     * @brief constructs the logger to write onto @a stream
     *
     * @throw never
     */
    explicit Intending_Stream_Logger(::std::ostream & stream);

private:
	/**
	 * @brief not available 
	 */
	Self & operator=(Self const & other);
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Implementation of the @ref Logger Interface
     * @{
     */
public:
    /**
     * @brief write @a record onto the internal stream.  In case of an
     * error @ref DIAGNOSTICS_PANIC_LOG is invoked.
     *
     * @throw never
     */
    virtual void log(Record const & record);

    /**
     * @brief noop
     *
     * @throw never
     */
    virtual void close();
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Encapsulated State
     * @{
     */
private:
    ::std::ostream & m_stream;
    int m_intend;
    // @}
};


DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
