/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/memory.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Use-Case: The include file is used in a
 * main-component (i.e., a component which contains the main()
 * procedure) to switch on memory analysis. 
 *
 * @attention: Causes Memory Allocations/Deallocations to be slow!
 */


#ifndef DIAGNOSTICS__MEMORY__INCLUDE_GUARD
#define DIAGNOSTICS__MEMORY__INCLUDE_GUARD

#include <diagnostics/extensions/memory/operators.hpp>
#include <diagnostics/extensions/memory/annotations.hpp>

#endif

// vim:ts=4:sw=4
