#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#include "parameters.h"
#include "struct.h"

extern void error(char *message);
extern void merror(char *msg1, char *msg2);
extern inline void calc_weight(struct diag* dg, struct scr_matrix* smatrix, 
			struct prob_dist *pdist);
extern inline void calc_ov_weight(struct diag* dg, struct diag_col *dcol, struct scr_matrix* smatrix, 
		    struct prob_dist *pdist);
//extern struct seq_part* create_seq_part(int num, struct seq* aSeq, unsigned int startpos);
extern struct diag* create_diag(struct seq_part* part1, struct seq_part* part2, 
			 int dlength);
extern void free_diag(struct diag* dg);

/**
 *
 * alig.c: Takes care of the alignment data structure
 *
 * 2003-10-31  A.R.Subramanian
 *             (Initial)
 */

/**
 * creates initial empty alignment data structure
 *
 * The pointer returned (and the ones included in the struct) 
 * has to be deallocted explicitely from memory.
 */
struct alignment* create_empty_alignment(struct seq_col *scol) {
  /*
  printf("before\n");
  sleep(5);
  */
  struct alignment* algn = calloc(1, sizeof(struct alignment));
  if(algn==NULL) error("create_empty_alignment(): (1) Out of memory !");

  algn->max_pos = -1;
  algn->scol = scol;
  
  unsigned int slen = scol->length;
  algn->seq_is_orphane = calloc(slen, sizeof(char));
  if(algn->seq_is_orphane==NULL) error("create_empty_alignment(): (2) Out of memory !");
  //  memset(algn->seq_is_orphane, 1, slen*sizeof(char));
  
  algn->algn = calloc(slen, sizeof(struct algn_pos *));
  if(algn->algn==NULL) error("create_empty_alignment(): (3) Out of memory !");
  //algn->redo_seqs = calloc(slen*slen, sizeof(char));
  int i,j;
  struct seq* sq;
  for(i=0;i<slen;i++) {
    sq = &(scol->seqs[i]);
    algn->seq_is_orphane[i]=1;
    algn->algn[i] = calloc(sq->length, sizeof(struct algn_pos));
    if(algn->algn[i]==NULL) error("create_empty_alignment(): (4) Out of memory !");

    for(j=0;j<sq->length;j++) {
      algn->algn[i][j].state = para->STATE_ORPHANE;
      //      algn->algn[i][j].isInherited = 0;
      algn->algn[i][j].predFPos = -1;
      algn->algn[i][j].succFPos = -1;

      algn->algn[i][j].eqcParent= &(algn->algn[i][j]);
      //if(j==442) printf(" parent: %i\n", algn->algn[i][j].eqcParent);
      algn->algn[i][j].eqcRank= 0;
      algn->algn[i][j].eqcAlgnPos=calloc(1, sizeof(int));;
      *algn->algn[i][j].eqcAlgnPos=j;
      algn->algn[i][j].proceed=calloc(1, sizeof(char));;
      *algn->algn[i][j].proceed = 0;

      algn->algn[i][j].predF = NULL;
      algn->algn[i][j].succF = NULL;
    }
  }
  /*
  printf("after\n");
  sleep(5);
  printf("gone\n");
  */
  return algn;
}



/**
 * returnes the representative of the equivalence class
 */
struct algn_pos *_find_eqc(struct algn_pos *ap, char doprint) {
  if(ap!=ap->eqcParent) {
    //    if(doprint) printf("    FIND: %i %i\n", ap, ap->eqcParent);
    
    /**
    if(ap->eqcParent->eqcAlgnPos!=NULL) {
      if( (ap->eqcAlgnPos!=NULL) && *ap->eqcParent->eqcAlgnPos < *ap->eqcAlgnPos) {
	//	if(doprint)  printf("    1.1 ALGNPOS: %i %i\n", ap, ap->eqcParent);
        *ap->eqcParent->eqcAlgnPos = *ap->eqcAlgnPos;
      } 
    } else {
      //	ap->eqcParent->eqcAlgnPos = ap->eqcAlgnPos;
    }
    */
    ap->eqcParent = _find_eqc(ap->eqcParent,doprint);
  }
  //  if(doprint)   printf("    1.ALGNPOS: %i %i\n", ap, ap->eqcParent);
  //  if(doprint)   printf("    2.ALGNPOS: %i %i\n", ap, ap->eqcParent);
  return ap->eqcParent;
}

/**
 * returnes the representative of the equivalence class
 */
struct algn_pos *find_eqc(struct algn_pos **ap, int seqnum, int pos) {
  //if(1) printf("%i %i %i\n", ap, seqnum,pos);
  struct algn_pos *tap = &ap[seqnum][pos];
  struct algn_pos *eq_ap;
  //if(pos==442) printf(" pre old %i %i\n",tap, tap->eqcParent);
  //char oldparentIsInherited = tap->eqcParent->isInherited;
  //if(pos==442) printf(" pre _eqc\n");
  eq_ap = _find_eqc(tap,0);
  //if(pos==442) printf(" after _eqc\n");
  //if(1) printf("after %i %i %i\n", ap, seqnum,pos);

  
  if(eq_ap->eqcAlgnPos != tap->eqcAlgnPos) {

    //if((tap->eqcAlgnPos!=NULL) && (*tap->eqcAlgnPos > *eq_ap->eqcAlgnPos))
    //  *eq_ap->eqcAlgnPos = *tap->eqcAlgnPos;

    //    if(eq_ap->eqcAlgnPos != tap->eqcAlgnPos) 
    if( (!(tap->state & para->STATE_INHERITED))) { //&& !oldparentIsInherited) {
      if(tap->eqcAlgnPos !=NULL) {
	//if(pos==175) printf("free eqcAlgnPos: %i\n", tap->eqcAlgnPos);
	free(tap->eqcAlgnPos);
	tap->eqcAlgnPos = NULL;
      }

      if(tap->proceed !=NULL) {
	//printf("free proceed: %i\n", tap->proceed);
	free(tap->proceed);
	//printf("after free proceed: %i\n", tap->proceed);
	tap->proceed = NULL;
      }
      
      //if(tap->predFPos>=0) 
      if( (eq_ap->predF != tap->predF) && (tap->predFPos<0) && (tap->predF!=NULL)){
	//printf("          free predF: %i %i %i %i\n", tap->predF, tap->isInherited, seqnum, pos);
	free(tap->predF);
	//printf("          after free predF: %i\n", tap->predF);
	tap->predF=NULL;
      }
      //if(tap->succFPos>=0) 
      if((eq_ap->succF != tap->succF) && (tap->succFPos<0) && (tap->succF!=NULL)) {
	//printf("free succ: %i\n", tap->succF);
	free(tap->succF);
	//printf("after free succ: %i\n", tap->succF);
	tap->succF=NULL;
      }
    }
    *tap = *eq_ap;
    tap->state = (tap->state | para->STATE_INHERITED);
  }
  //if(seqnum==0 &&pos==175)  printf("after !=\n");
  // tap = eq_ap;

  struct algn_pos *ttap;
  if(tap->predFPos>=0 ) {
    //if(seqnum==0 && pos==175) printf("          alarm predF: %i %i %i %i\n", tap->predF, tap->predFPos, seqnum, pos);
    //    printf ("PRE Pos %i %i \n", tap->predFPos, pos);
    if(tap->predFPos==pos) {
      printf("pred ALARM %i %i\n", tap->predFPos, pos);
      exit(99);
    }
    ttap=find_eqc(ap, seqnum, tap->predFPos);
    tap->predF = ttap->predF;
  }
  if(tap->succFPos>=0) {
    //if(seqnum==0 && pos==175) printf("          alarm succF: %i %i %i %i\n", tap->succF, tap->succFPos, seqnum, pos);
    //printf ("2. PRE Pos %i %i \n", tap->predFPos, tap->succFPos);
    if(tap->succFPos==pos) {
      printf("succ ALARM %i %i\n", tap->succFPos, pos);
      exit(99);
    }
    ttap = find_eqc(ap, seqnum, tap->succFPos);
    tap->succF = ttap->succF;
  }
  //if(seqnum==0 && pos==175) printf(" end qgc\n");
  return tap;
}




/**
 * changes the startpos's and length of the diag such that
 * it becomes consistent with the given alignment. If the diag
 * has more than one part that is consistent the leftmost will be chosen
 * The return value is 1 if any changes were made otherwise 0. 
 * (The weight of the diag is not recalculated !).
 *
 * Sets the weight to -1.0 if real conflict otherwise to 0.0
 */
char adapt_diag(struct alignment *algn, struct scr_matrix *smatrix, struct diag* dg) {
//char adapt_diag(struct alignment *algn, struct diag* dg) {
  //printf(" ENTER adapt\n");
  unsigned int s1 = dg->seq_p1.num;
  unsigned int s2 = dg->seq_p2.num;

  char o1 = algn->seq_is_orphane[s1];
  char o2 = algn->seq_is_orphane[s2];
  // if any sequence is orphane the diag is always consistent
  if( o1 || o2) return 0; 

  int sp1 = dg->seq_p1.startpos;
  int sp2 = dg->seq_p2.startpos;
  int ep1 = sp1+dg->length-1;
  int ep2 = sp2+dg->length-1;

  struct algn_pos **ap=algn->algn;
  int predF, succF;
  int rlen;
  
  
  // cut off the beginning of the diag
  struct algn_pos *tap;// = find_eqc(ap, s1, sp1);

  sp1--;
  sp2--;
  // jump to a consistent position
  //char included = 1;
  do {
    sp1++; sp2++;
    if(sp1<=ep1) {
      tap = find_eqc(ap, s1, sp1);
      if(tap->predF!=NULL) { //&& tap->succF!=NULL) {
	predF = tap->predF[s2];
      } else {
	predF=-1; 
      }
      if(tap->succF!=NULL) {
	succF = tap->succF[s2];
      } else {
	succF = ep2+1;
      }
    }
    //if(predF!=sp2 || succF!=sp2) included = 0;
  } while( ( (predF>=sp2)|| (succF<=sp2) ) && !(predF==sp2 && succF==sp2) && sp1<=ep1);

  // cutoff low scoring positions at the beginning
  /*
  while( (sp1<=ep1)) {
      a1 = c2n[data1[sp1]];
      a2 = c2n[data2[sp2]];
      score1 = sdata[smatrixlen*a1+a2];
      
      if(score1<PROT_SIM_SCORE_THRESHOLD) {
	//printf(" SHORT1 ALARM %i %i %i %i %i %i\n",sp1,ep1, sp2,ep2,dg->length, score1);
	sp1++;
	sp2++;
      } else {
	break;
      }
  }
  */
  
  // check whether the diagonal has been cut off to zero length
  if(sp1>ep1) {
    //    printf(" OUT OF RANGE %i %i %i \n",predF, succF, sp2);
    //if(included) 
    //  dg->weight = 0.0;
    //else
    //  dg->weight = -1.0;
		  
    dg->length=0;
    return 1;
  }

  // cut off the end of the diag
  rlen=0;
  do {
    rlen++;
    //printf("   rlen: %i %i %i %i %i\n", ep1, sp1, sp2, dg->length, sp1+rlen-1);
    if((sp1+rlen-1)>ep1) {
      break;
    }else {
      tap = find_eqc(ap, s1, sp1+rlen-1);
      //printf("   after rlen: %i\n", rlen);
      if(tap->predF!=NULL) { 
	predF = tap->predF[s2];
      } else {
	predF=-1; 
      }
      if(tap->succF!=NULL) {
	succF = tap->succF[s2];
      } else {
	succF = sp2+rlen;
      }
    }
  } while( ( ((succF>=(sp2+rlen)) && (predF<(sp2+rlen-1))) || ((succF==(sp2+rlen-1)) && (predF==(sp2+rlen-1))))
	   && ((sp1+rlen-1)<=ep1));
  rlen--;
  
  // cutoff low scoring positions at the end
  /*
  while(rlen>0) {
    a1 = c2n[data1[sp1+rlen-1]];
    a2 = c2n[data2[sp2+rlen-1]];
    //printf(" %i %i %i\n", a1, a2,smatrixlen);
    score1 = sdata[smatrixlen*a1+a2];
    break;
    
    if(score1<PROT_SIM_SCORE_THRESHOLD) {
      //printf(" SHORTENING ALARM %i %i %i %i !\n", sp1,sp2,rlen,score1);
      rlen--;
    } else {
      break;
    }
  }
  */
  
  if(rlen<=0) {
    dg->length=0;
    //printf("sp1: %i\n", sp1);
    return 1;
  }
  int oldlen = dg->length;
  //printf("sp1: %i\n", sp1);
  dg->length = rlen;
  dg->seq_p1.startpos=sp1;
  dg->seq_p2.startpos=sp2;
  
  if(oldlen==rlen) {
    return 0;
  }

  return 1;
}


/**
 * adds the given diagional to the given alignment and updates the
 * datastructure (i.e. frontiers). The given diag must be consistent
 * to the given alignment !
 */
inline char align_diag(struct alignment *algn, struct scr_matrix *smatrix, struct diag* dg) {
  if(dg->length==0)return('\0');

  struct seq_col *scol = algn->scol;
  int s1 = dg->seq_p1.num;
  int s2 = dg->seq_p2.num;

  //printf("%i %i\n", s1,s2);

  //char o1 = algn->seq_is_orphane[s1];
  //char o2 = algn->seq_is_orphane[s2];

  int length = dg->length;
  int sp1 = dg->seq_p1.startpos;
  int sp2 = dg->seq_p2.startpos;

  struct algn_pos **ap=algn->algn;
  struct algn_pos *tp;
  
  int i,j,k;
  struct algn_pos *apos1, *apos2, *tpos;

  int p1, p2,plen;
  int p;
  struct seq *sq = scol->seqs;
  int s, slen = scol->length;
  int *oldpredF, *oldsuccF, *otherpredF, *othersuccF;
  int pF,sF;
  /*
  int *c2n = smatrix->char2num;
  int *sdata = smatrix ->data;
  char *data1 = dg->seq_p1.sq->data;
  char *data2 = dg->seq_p2.sq->data;
  int smatrixlen = smatrix->length;
  */
  
  char seenNonOrphane;
  int opos;
  int ms;
  char skip = 0;
  char alignedSomething = 0;

  for(i=0;i<length;i++) {
    p1 = sp1+i; p2 = sp2+i;

    //    printf("pos %i %i %i %i\n",s1,s2,p1,p2);
    //printf(" %i \n", scol->length);
    skip = 0;
    
    //if(sp1==30) printf("%i %i %i %i %i \n", p1,p2,dg->length, dg->seq_p1.sq->length, dg->seq_p2.sq->length);
    /*
    //    if(dg->onlyOverThres==1) {
      a1 = c2n[data1[p1]];
      a2 = c2n[data2[p2]];
      score1 = sdata[smatrixlen*a1+a2];
      
      if(score1<=1) {
	skip = 1;
      }
      //}
      */
    //    printf(" %i %i %i\n",p1,p2,skip);
	//} else {
    if(! skip) {
      //printf("apos1 %i %i\n", s1, p1);
      apos1 = find_eqc(ap, s1,p1);//&(ap[s1][p1]);
      //printf("apos2 %i %i %i\n", s2, p2, scol->seqs[s2].length);
      apos2 = find_eqc(ap, s2,p2); //&(ap[s2][p2]);
      //printf("after apos2 %i %i\n", s2, p2);
      // check whether already aligned
      oldpredF = apos1->predF;
      oldsuccF = apos1->succF;
      if(oldpredF!=NULL && oldsuccF!=NULL)
	if(oldpredF[s2]==p2 && oldsuccF[s2]==p2) skip = 1;

      if(para->DEBUG>5) {
	if(!skip) {
	  if(oldpredF!=NULL) if(oldpredF[s2]>=p2) printf(" Incons1 %i %i\n", p2,oldpredF[p2]);
	  if(oldsuccF!=NULL) if(oldsuccF[s2]<=p2) printf(" Incons2 %i %i\n",p2,oldsuccF[p2]);
	  oldpredF=apos2->predF;
	  oldsuccF=apos2->succF;
	  if(oldpredF!=NULL) if(oldpredF[s1]>=p1) printf(" Incons3 %i %i\n", p1,oldpredF[p1]);
	  if(oldsuccF!=NULL) if(oldsuccF[s1]<=p1) printf(" Incons4 %i %i\n",p1,oldsuccF[p1]);
	}
      }
    }
      //}
    if(! skip) {
      alignedSomething = 1;
      for(k=0;k<2;k++) {
	tpos = (k==0 ? apos1 : apos2);
	//printf("tpos %i\n", tpos);
	oldpredF = tpos->predF;
	oldsuccF = tpos->succF;
	otherpredF = (k==0 ? apos2->predF : apos1->predF);
	othersuccF = (k==0 ? apos2->succF : apos1->succF);
	//printf("pre isorphane %i\n", tpos);
	if(tpos->state & para->STATE_ORPHANE) {
	  //if(scol->length>21) printf("isorphane %i %i\n", tpos,sizeof(int)*scol->length);
	  //printf("step 1\n");
	  tpos->predF = malloc(sizeof(int)*scol->length);
	  //if(k==0) printf("           apos1->predF = %i\n",tpos->predF),
	  //printf("pre succForphane %i %i\n", tpos->succF, scol->length);
	  //printf(" step 2\n");
	  tpos->succF = malloc(sizeof(int)*scol->length);
	  //printf("  step 3\n");
	  //printf("succForphane %i\n", tpos);
	  if( (tpos->predF==NULL) || (tpos->succF==NULL)) error("align_diag(): (1) Out of memory !");
	  
	}
	//      printf("init loop %i\n", tpos);
	
	for(j=0;j<scol->length;j++) {
	  pF = -1;
	  sF = sq[j].length;
	  
	  
	  // propagate predF and succF
	  if(oldpredF!=NULL && oldpredF[j]>pF) pF = oldpredF[j];
	  //if(j==0) printf("1 pf=%i\n", pF);
	  if(otherpredF!=NULL && otherpredF[j]> pF) pF = otherpredF[j];
	  //if(j==0) printf("2 pf=%i\n", pF);
	  
	  if(oldsuccF!=NULL && oldsuccF[j]<sF) sF = oldsuccF[j];
	  if(othersuccF!=NULL && othersuccF[j]<sF) sF = othersuccF[j];
	  //}
	  if(j==s1) {
	    pF  =  p1;
	    sF  =  p1;
	  } else if(j==s2) {
	    pF  =  p2;
	    sF  =  p2;
	  }
	  /*
	    if(pF > sF) {
	    if(oldpredF!=NULL) printf(" PRE 1. ALARM oldpredF: %i \n",oldpredF[j] );
	    if(oldsuccF!=NULL) printf(" PRE 1. ALARM oldsuccF: %i \n",oldsuccF[j] );
	    if(otherpredF!=NULL) printf(" PRE 1. ALARM otherpredF: %i \n",otherpredF[j] );
	    if(othersuccF!=NULL) printf(" PRE 1. ALARM othersuccF: %i \n",othersuccF[j] );
	    
	    printf("1. ALARM j=%i %i %i %i %i %i %i %i\n",
	    j,
	    (k==0 ? s1 : s2), 
	    (k==0 ? p1 : p2),
	    (k==0 ? p2 : p1), 
	    oldpredF!=NULL ? oldpredF[k==0 ? s2 : s1] : -2, 
	    oldsuccF!=NULL ? oldsuccF[k==0 ? s2 : s1]: 99999, 
	    tpos->predFPos, 
	    tpos->succFPos);
	    exit(1);
	    }
	  */
	  //if(pF==sF && pF==0 && j==0) printf("pf=%i sf=%i j=%i s1=%i s2=%i p1=%i p2=%i iso=%i opf=%i osf=%i otpf=%i otsf=%i\n", pF,sF,j,s1,s2,p1,p2,tpos->isOrphane,oldpredF, oldsuccF, otherpredF, othersuccF);
	  tpos->predF[j]=pF;
	  tpos->succF[j]=sF;
	}
	//if(s1==0 && p1==0) printf(" SET IT 1\n");
	//if(s2==0 && p2==0) printf(" SET IT 2\n");
	//if(tpos->state & para->STATE_ORPHANE) 
	tpos->state = tpos->state & (tpos->state ^ para->STATE_ORPHANE);
	tpos->predFPos = -1;
	tpos->succFPos = -1;
      }
      
      //printf("end pre/succ %i\n", tpos);
      apos1->predF[s1]=p1;
      apos1->succF[s1]=p1;
      apos2->predF[s2]=p2;
      apos2->succF[s2]=p2;
      
      apos1->predF[s2]=p2;
      apos1->succF[s2]=p2;
      apos2->predF[s1]=p1;
      apos2->succF[s1]=p1;
      
      
      
      if(apos2->eqcRank< apos1->eqcRank) {
	apos2->eqcParent = apos1;
      } else {
	apos1->eqcParent = apos2;
	if(apos2->eqcRank==apos1->eqcRank) 
	  apos2->eqcRank++;
      }
      //printf("end ranking %i, %i    %i\n", s1,p1,apos1->predF);
      apos1 = find_eqc(ap, s1,p1);//&(ap[s1][p1]);
      //printf("end first egc %i\n", tpos);
      apos2 = find_eqc(ap, s2,p2); //&(ap[s2][p2]);
      //printf("end second egc %i\n", tpos);
      
      
      // update the other affected sites
      for(ms=0;ms<slen;ms++) {
	// spaeter ueberlegen: if((ms!=s1 && ms!=s2) || ( (ms==s1 || ms==s2) && (i==0 || i== (length-1) ))) {
	//	if(apos1->predF[ms]==apos1->succF[ms]) {
	
	p = apos1->predF[ms]; // -( (apos1->predF[ms]==apos1->succF[ms]) ? 1 : 0); // GOGOGOGO 
	opos=apos1->predF[ms];
	//    printf("SUPERPRE WHILE %i %i %i\n",k,s1,s2);
	tp = ap[ms];
	//printf("PRE WHILE %i\n",k);
	seenNonOrphane=0;
	
	while(p>=0) { // && tp[p].isOrphane) {
	  //printf(" WHILE %i\n",p); 
	  if(tp[p].state & para->STATE_ORPHANE) {
	    if( (! seenNonOrphane)) {
	      //	      if(ms==0 && p==0) printf("setting s1=%i p1=%i iso=%i ms=%i p=%i opos=%i\n",s1,p1, tp[p].isOrphane, ms,p,opos);
	      tp[p].succFPos = opos;
	    }
	  } else {
	    if( (p!=opos) || (apos1->succF[ms]!=apos1->predF[ms])) 
	      seenNonOrphane = 1;
	    //if(p==442) printf("  pre find %i %i %i\n",s1, ms,p);
	    tpos = find_eqc(ap, ms,p);//&(ap[s1][p1]);
	    //if(p==442)printf("  post find %i %i\n",ms,p);
	    if(! (tpos->state & para->STATE_ORPHANE) && ! (tpos->state & para->STATE_INHERITED)) {
	      for(s=0;s<slen;s++) {
		if(tpos->succF[s]>apos1->succF[s]) tpos->succF[s]=apos1->succF[s];
	      }
	    }
	  }
	  p--;
	}
	
	//printf("END WHILE\n");
	
	//printf(" PRE 2 %i %i %i\n", apos1->predF, apos1->succF,ms );
	p = apos1->succF[ms]; // +( (apos1->predF[ms]==apos1->succF[ms]) ? 1 : 0); // GOGOGOGO ;
	opos= apos1->succF[ms];
	plen = scol->seqs[ms].length;
	seenNonOrphane=0;
	//printf("2. PRE WHILE %i\n",k);
	// if(opos>=plen) opos = -1;
	while(p<plen ) {
	  //      step = (int)(p-tep);
	  if(tp[p].state & para->STATE_ORPHANE) {
	    if( (! seenNonOrphane)) {
	      if(p==opos) {
		printf("ALARM set predFPos s1=%i s2=%i p1=%i p2=%i ms=%i sF=%i pF=%i p=%i opos=%i iso=%i %i %i %i\n",
                   s1,s2,p1,p2,ms, apos1->succF[ms],
                   apos1->predF[ms],p,opos, tp[p].state,(int) &tp[p],(int) apos1, (int) apos2);
                   /* MATHOG, added (int) to preceding 3 arguments to match type to printf statement.
                      Output will probably be garbage, no idea what the original intent was.*/
		exit(98);
	      }
	      tp[p].predFPos = opos;
	    } 
	  } else {
	    if( (p!=opos)|| (apos1->succF[ms]!=apos1->predF[ms])) 
	      seenNonOrphane = 1;
	    //printf("  pre find %i %i\n",ms,p);
	    tpos = find_eqc(ap, ms,p);//&(ap[s1][p1]);
	    //printf("  end find\n");
	    if(! (tpos->state & para->STATE_ORPHANE)  && !(tpos->state & para->STATE_INHERITED)) {
	      for(s=0;s<slen;s++) {
		if( tpos->predF[s]<apos1->predF[s]) {
		  tpos->predF[s]=apos1->predF[s];
		}
	      }
	    }
	  }
	  p++;
	}
	//printf("2. END WHILE %i\n",k);
      }
    }
  }
  
  
  // printf("s1: %i s2: %i\n", algn->seq_is_orphane[s2],s2);
  algn->seq_is_orphane[s1]=0;
  algn->seq_is_orphane[s2]=0;
  return(alignedSomething);
}



/**
 *
 * prepares the alignment: calculates the position number of each residue 
 *  
 */
void prepare_alignment(struct alignment *algn) {
  struct seq_col *scol = algn->scol;
  unsigned int slen = scol->length;

  unsigned int i,j,s,ts, hasmore, max;
  int *predF, *succF;
  struct seq* sq;
  struct algn_pos **ap = algn->algn;
  int  tproc[slen];
  //  char proceed[slen];

  for(i=0;i<slen;i++) {
    tproc[i]=0;
  }

  //
  // prepare block
  //
  struct algn_pos *ap1;
  hasmore = 1;
  char alarmHasProceed;

  for(j=0;hasmore;j++) {
    hasmore = 0;
    //memset(proceed, 0, slen*sizeof(char));
    //    printf("Position: %i\n", j);
    //    for(k=0;k<2;k++) {
    for(s=0;s<slen;s++) {
      sq = &scol->seqs[s];
      if(tproc[s]<sq->length) {
        ap1 = find_eqc(ap,s,tproc[s]);
	*ap1->proceed = 1;
	
      }
    }
    for(s=0;s<slen;s++) {
      sq = &scol->seqs[s];
      if(tproc[s]<sq->length) {
	//printf(" DO IT %i %i %i %i\n",j,s,tproc[s], *ap1->eqcAlgnPos);
        ap1 = find_eqc(ap,s,tproc[s]);
//		printf("alig.c ap1 = %d\tap = %d\n",ap1,ap);
	
	if(j>=*ap1->eqcAlgnPos) {
	  predF = ap1->predF;
	  succF = ap1->succF;
	  
	  *ap1->eqcAlgnPos=j;// *tap1->eqcAlgnPos;
	  if(predF!=NULL) {
	    for(ts=0;ts<slen;ts++) {
	      //printf(" MIST %i %i %i %i %i %i %i\n",j,s,ts,tproc[s], tproc[ts], predF[ts], succF!=NULL ? succF[ts]: 99999);
	      if( (tproc[ts]<predF[ts]) && !(tproc[ts]==predF[ts] && succF!=NULL && succF[ts]==predF[ts])) {
		*ap1->eqcAlgnPos=j+1;// *tap1->eqcAlgnPos;
		//printf(" 2. MIST %i %i %i %i %i %i %i\n",j,s,ts,tproc[s], tproc[ts], predF[ts], succF!=NULL ? succF[ts]: 99999);
		*ap1->proceed = 0;
		break;
	      } else {
		/*
		 *ap1->eqcAlgnPos=j;// *tap1->eqcAlgnPos;
		 *ap1->proceed = 1;
		 */
	      }
	    }
	  }
	} else {
	  *ap1->proceed = 0;
	}
	/*
	  if(j>=143) {
	  printf("ALARM j=%i s=%i tproc[s]=%i algnPos=%i\n",j,s,tproc[s],*ap[s][tproc[s]].eqcAlgnPos);
	  }
	*/
      }
    }
    alarmHasProceed=0;
    for(s=0;s<slen;s++) {
      sq = &scol->seqs[s];
      if(tproc[s]<sq->length) {
	ap1 = find_eqc(ap,s,tproc[s]);
	if(*ap1->proceed) {
	  alarmHasProceed = 1;
	  tproc[s]++;
	}
      }
      if(tproc[s]<sq->length) hasmore = 1;
      //printf("%i %i\n", sq->length,tproc[s]);
    }
    if(! alarmHasProceed && hasmore) {
      printf("IO ALARM! %i\n",j);
      exit(1);
      hasmore=0;
    }
    if(!hasmore) max = j+1;
  }
  algn->max_pos= max;
}



/**
 *------------------------------------------------------------------------------------------
 *                                SIMPLE ALIGNER SECTION
 *------------------------------------------------------------------------------------------
 */


/**
 * heapify 
 */
void heapify_diag_array(struct diag **diags, int pos, int length, int up) {
  struct diag *dg = diags[pos];
  if(up) {
    if(pos<=3) return; 
    int parent = (pos-1)/2;
    struct diag *pdg = diags[parent];
    if(pdg->total_weight<dg->total_weight) {
      diags[parent]=dg;
      diags[pos] = pdg;
      //      printf("heapify: %i %i %i %i %i\n", pos,parent, length, dg, pdg);
            heapify_diag_array(diags, parent,length,up);
    }

  } else {
    int lchild = 2*pos+1;
    if( (lchild)>=length) return;
    int rchild = lchild+1;
    //struct diag *dg = diags[pos];
    struct diag *ldg = diags[lchild];
    struct diag *rdg = (rchild>=length ? ldg : diags[rchild]);
    int greatest = pos;
    if(ldg->total_weight > diags[greatest]->total_weight) greatest = lchild;
    if( (rchild<length) && (rdg->total_weight > diags[greatest]->total_weight)) greatest = rchild;
    if(greatest != pos) {
      diags[pos] = diags[greatest];
      diags[greatest] = dg;
      
      heapify_diag_array(diags, greatest,length,up);
      
    }
  }
}


/**
 * test function that constructs an arbitrary consistent alignment.this function
 * is used to check the the correctness of adapt_diag() and align_diag()
 *
 * Returns whether something new could be aligned
 */
char simple_aligner(struct seq_col *scol, struct diag_col *dcol, 
			    struct scr_matrix* smatrix, 
			    struct prob_dist *pdist, 
			    struct alignment *algn, int round) {
  int dlen = dcol->diag_amount;
  int i;
  
  struct diag * dg,*tdg;
  char changed;
  char alignedSomething = 0;
  // compute counter weights

  // heapify
  struct diag **diags = dcol->diags; //calloc(dlen, sizeof(struct diag *));
  int alloc_dlen = dlen;
  for(i= (dlen+1)/2-1;i>=0;i--) {
    heapify_diag_array(diags, i, dlen,0);
  }
  //memset(algn->redo_seqs, 0, sizeof(char)*slen*slen);

  double oldweight=0.0, prevweight;
  
  i=0;
  double total_weight = 0.0;
  double alig_time = 0.0;
  double tclock;
  struct diag tmp_diag;
  int tmp_end;
  int offset;
  struct diag *hookdg;
  while(dlen>0) {
    //    printf(" dlen %i\n", dlen);
    dg = diags[0];
    //if(dg->score==217) print_diag(dg);
    changed = 0;
    //    print_diag(dg);
    //    hookdg = NULL;
    if(dg->length>0) {
      //      printf(" %.20f %.20f\n", dg->weight, dg->total_weight);
      if(oldweight > 0.0)
	if(dg->weight > oldweight) {
	  printf(" ALARM %.20f %.20f\n", oldweight, dg->weight);
	  //print_diag(&odg);
	  //print_diag(dg);
	  //intf("       %i %i      \n", odg, dg);
	}
      //odg = *dg;
      //printf(" pre changed\n");
      prevweight = dg->weight;
      tmp_diag = *dg;
      changed= adapt_diag(algn,smatrix, dg);
      //changed= adapt_diag(algn,NULL, dg);
      //print_diag(dg);
      //printf(" after changed %i\n", dg->length);
      if(changed) {
	//printf("\nCHANGED\n");
	//print_diag(dg);
	//printf("   pre recalc\n");
	calc_weight(dg, smatrix, pdist);
	
	if(dg->length > 0) {
	  tmp_end = tmp_diag.seq_p1.startpos+tmp_diag.length-1;
	  if((dg->seq_p1.startpos+dg->length-1)< (tmp_end)) {
	    offset = dg->seq_p1.startpos+dg->length-tmp_diag.seq_p1.startpos;
	    tmp_diag.seq_p1.startpos += offset;
	    tmp_diag.seq_p2.startpos += offset;
	    tmp_diag.length -= offset;

	    adapt_diag(algn,smatrix, &tmp_diag);
	    tmp_diag.length = tmp_end - tmp_diag.seq_p1.startpos+1;
	    calc_weight(&tmp_diag, smatrix, pdist);

	    if((tmp_diag.length>0)&& tmp_diag.meetsThreshold) {
	      
	      hookdg = malloc(sizeof(struct diag));
	      *hookdg = tmp_diag;
	      
	      dcol->diag_amount++;
	      if(dcol->diag_amount>alloc_dlen) {
		//printf("\n\n\nresize %i %i\n\n\n", dlen, alloc_dlen);
		alloc_dlen += 8;
		dcol->diags = (diags = realloc(diags, sizeof(struct diag*)*alloc_dlen));
		if(diags==NULL) error("Error increasing diag heap durign aligning.");
	      }
	      //print_diag(hookdg);
	      //printf("dlen %i damount %i %i\n", dlen, dcol->diag_amount, hookdg);
	      //free(diags[dcol->diag_amount-1]);
	      dlen++;
	      diags[dcol->diag_amount-1] = diags[dlen-1];
	      diags[dlen-1]=hookdg;
	      
	      if(dlen>=2) {
		//printf("heapify: %i\n", dlen-1);
		heapify_diag_array(diags,dlen-1,dlen,1);
	      }
	      
	      //print_diag(hookdg);
	    }
	  }
	} else {
	  dg->meetsThreshold=0;
	}
	
	//printf("   \nafter recalc %i %.20f %.20f\n",dg->length,  oldweight, dg->weight);
	
	//printf("%.20f %.20f\n", oldweight, dg->weight);

	//if(dg->weight<prevweight*0.5) dg->meetsThreshold = 0;

	// TODO: reactivate !!!
	//(dg->weight<oldweight*0.5) {
	//if(dg->weight>oldweight) printf(" WEIGHT %e %e\n", dg->weight, oldweight);
	//algn->redo_seqs[dg->seq_p1.num*slen+dg->seq_p2.num] = 1;
	//algn->redo_seqs[dg->seq_p2.num*slen+dg->seq_p1.num] = 1;

	// DELETE THIS:
	//dg->meetsThreshold = 0;

	if(para->DO_OVERLAP) calc_ov_weight(dg, dcol, smatrix, pdist); 
      } else {
	//printf("  Pre align\n");
	//print_diag(dg);
	if(para->DEBUG >1) tclock = clock();

	alignedSomething =  align_diag(algn, smatrix, dg) || alignedSomething;
	if(para->DEBUG >1) alig_time += clock()-tclock;

	if(para->DEBUG >1) total_weight += dg->total_weight;
	//printf("  After align\n");
	if(para->DEBUG >2) printf("  aligned diag %i %e\n", i, dg->weight);
	//dg->length = 0;
	//dg->weight = 0.0;
	dg->meetsThreshold = 0;
      }
    } else {
      //      printf("ALARM %i %i %Le\n", i, dg->length, dg->weight);
      oldweight = dg->weight;
    }
    
    if(!dg->meetsThreshold) {
    //if(dg->length==0) {
      //free(dg);
      tdg = diags[dlen-1];
      diags[dlen-1]=dg;
      diags[0] = tdg;
      dlen--;
    } 
    //    if(hookdg==NULL) {
    heapify_diag_array(diags, 0, dlen,0);
      //} else {
      //heapify_diag_array(diags, 0, dlen-1,0);
      // }
  }
  if(para->DEBUG >1)   printf(" Total Weight: %.20f  with pure alignment time %f \n", total_weight, alig_time/CLOCKS_PER_SEC);
  //  return algn;
  return alignedSomething;
}
