/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef AUDIENCESELECTOR_H
#define AUDIENCESELECTOR_H

#include <QFrame>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QIcon>
#include <QGroupBox>
#include <QListWidget>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QKeyEvent>

#include <QDebug>

#include "pumpcontroller.h"


class AudienceSelector : public QFrame
{
    Q_OBJECT

public:
    explicit AudienceSelector(PumpController *pumpController,
                              QString selectorType,
                              QWidget *parent = 0);
    ~AudienceSelector();

    void resetLists();


protected:
    virtual void keyPressEvent(QKeyEvent *event);

signals:
    void audienceSelected(QString selectorType,
                          QStringList contactsList);


public slots:
    void filterList(QString searchTerms);
    void updateAllContactsList(QString listType,
                               QVariantList contactsVariantList);
    void copyToSelected();
    void copyClickedToSelected(QModelIndex modelIndex);

    void setAudience();



private:
    PumpController *pController;

    QString selectorType;

    QHBoxLayout *mainLayout;


    QVBoxLayout *allGroupboxLayout;
    QGroupBox *allContactsGroupbox;

    QLabel *searchLabel;
    QLineEdit *searchLineEdit;
    QListWidget *allContactsListWidget;

    QStringList allContactsStringList;

    QPushButton *addToSelectedButton;



    QVBoxLayout *selectedGroupboxLayout;
    QGroupBox *selectedListGroupbox;

    QLabel *explanationLabel;
    QListWidget *selectedListWidget;

    QPushButton *clearSelectedListButton;

    QHBoxLayout *buttonsLayout;
    QPushButton *doneButton;
    QPushButton *cancelButton;
};

#endif // AUDIENCESELECTOR_H
