/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include <QApplication>
#include <QTranslator>
#include <iostream>

#include "mainwindow.h"





#if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
void customMessageHandlerQt4(QtMsgType type, const char *msg)
{
    // do nothing
    Q_UNUSED(type)
    Q_UNUSED(msg)  // FIXME, memory leak?

    return;
}
#else
void customMessageHandlerQt5(QtMsgType type, const QMessageLogContext &context, const QString &msg)
{
    Q_UNUSED(type)
    Q_UNUSED(context)
    Q_UNUSED(msg)

    // Do nothing

    return;
}
#endif



int main(int argc, char *argv[])
{
    QApplication dianaraApp(argc, argv);
    dianaraApp.setApplicationName("Dianara");
    dianaraApp.setApplicationVersion("1.2.5");
    dianaraApp.setOrganizationName("JanCoding");
    dianaraApp.setOrganizationDomain("jancoding.wordpress.com");

    std::cout << QString("Dianara v%1 - JanKusanagi 2012-2014\n")
                        .arg(dianaraApp.applicationVersion()).toStdString();
    std::cout << QString("- Built with Qt v%1\n").arg(QT_VERSION_STR).toStdString();
    //  ... + ("on %2, %3").arg(__DATE__).arg(__TIME__)
    std::cout << QString("- Running with Qt v%1\n\n").arg(qVersion()).toStdString();
    std::cout.flush();

    // To make the mswin version of Dianara distributable as a standalone package
#ifdef Q_OS_WIN
    dianaraApp.addLibraryPath("./plugins/");
#endif


    QStringList cmdLine = qApp->arguments();
    cmdLine.removeFirst();

    bool debugMode = false;
    bool nextParameterIsConfig = false;

    // Parse command line parameters
    if (!cmdLine.isEmpty())
    {
        foreach (QString argument, cmdLine)
        {
            // Help
            if (argument.startsWith("--help", Qt::CaseInsensitive))
            {
                std::cout << "\nHelp:\n";
                std::cout << "    " << argv[0] << " [options]\n\n";
                std::cout << "Options:\n";
                std::cout << "    --debug           Show debug messages in the terminal\n";
                std::cout << "    --config [name]   Use a different configuration file\n";
                std::cout << "\n";

                return 0; // Exit to shell
            }

            // Use different config file, by setting a different applicationName
            if (argument.startsWith("--config", Qt::CaseInsensitive))
            {
                nextParameterIsConfig = true;
                cmdLine.removeAll(argument);
            }
            else if (nextParameterIsConfig)
            {
                QString configName = "Dianara_" + argument.toLower();
                dianaraApp.setApplicationName(configName);
                nextParameterIsConfig = false;

                std::cout << "Using alternate config file: "
                          << configName.toStdString() << "\n";
            }

            // Debug mode
            if (argument.startsWith("--debug", Qt::CaseInsensitive))
            {
                debugMode = true;
                cmdLine.removeAll(argument);

                std::cout << "Debug messages enabled\n";
            }
        }
    }


    // Register custom message handler, to hide debug messages unless specified
    if (!debugMode)
    {
    #ifdef Q_OS_WIN
        FreeConsole();
    #endif

        std::cout << "To see debug messages while running, use --debug\n";

    #if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
        qInstallMsgHandler(customMessageHandlerQt4);
    #else
        qInstallMessageHandler(customMessageHandlerQt5);
    #endif
    }


    // Load translation files
    QTranslator translator;
    // Get language from LANG environment variable or system's locale
    QString languageString = qgetenv("LANG");
    if (languageString.isEmpty())
    {
        languageString = QLocale::system().name();
    }
    QString languageFile;
    languageFile = QString(":/translations/dianara_%1")
                   .arg(languageString);
    std::cout << "Using translation file: "
              << languageFile.toStdString() << "\n";

    translator.load(languageFile);
    dianaraApp.installTranslator(&translator);

    std::cout.flush();


    MainWindow dianaraWindow;
    dianaraWindow.toggleMainWindow();  // show()


    return dianaraApp.exec();
}
