/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

enum e_librerias {LXML=0,LGTK,LORBIT,LX11,LGNOME,LGLIB,LGETTEXT,LGNOMEUI,LGNORBA,LAUDIOFILE,LESD,LGMODULE,LIMLIB,LELECTRIC_FENCE};

struct s_proyecto
{
	xmlDocPtr xml;
	xmlDocPtr xml_viejo;
	gchar *archivo;
};

//*******************************************************************

struct s_proyecto proyecto;
GtkWidget *ventana_propiedades_proyecto;
GtkWidget *ventana_seleccion_proyecto;
gboolean pro_forzando_librerias;
gchar *pro_proyecto_cargar;

//*******************************************************************

void pro_inicializar(void);

void pro_crear(void);

void pro_actualizar(GtkWidget *widget);

void pro_mostrar(GtkWidget *widget);

void pro_guardar(void);

gboolean pro_abrir(void);

void pro_anadir(gchar *nombre);

gchar *pro_nombre(void);

gchar *pro_fuentes(xmlNodePtr *xmlnode);

gchar *pro_cabeceras(xmlNodePtr *xmlnode);

gchar *pro_otros(xmlNodePtr *xmlnode);

gchar *pro_nombre_completo_archivo(gchar *nombre,gboolean cambiar_directorio);

gchar *pro_librerias_lincado(void);

gchar *pro_opciones_compilacion(void);

void pro_eliminar(gchar *nombre);

gboolean pro_existe_archivo(gchar *nombre);

gchar *pro_version(void);

gchar *pro_lenguaje(void);

gchar *pro_librerias_usuario(void);

gchar *pro_opciones_cflags(void);

gchar *pro_includes(void);

gchar *pro_warnings(void);

gchar *pro_srcdir(void);

gchar *pro_prodir(void);

gchar *pro_pixdir(void);

gchar *pro_glade_file(void);

gchar *pro_ejecutable(void);

gchar *pro_cabecera_gnu(void);

gboolean pro_crear_h(void);

gboolean pro_defines(void);

void pro_actualizar_librerias_lincado(GtkWidget *widget);

void pro_mostrar_librerias_lincado(GtkWidget *widget);
