///////////////////////////////////////////////////////////////////////////////
// For Firebird

var gDigglerPrefSvc;

function digglerFBInitSettings()
{
    if (!gDigglerPrefSvc) {
        gDigglerPrefSvc = Components
            .classes["@mozilla.org/preferences-service;1"]
            .getService(Components.interfaces.nsIPrefService).getBranch("");
    }
    var i;
    try {
        for (i = 0; i < _elementIDs.length; i++) {
            var e = document.getElementById(_elementIDs[i]);
            if (e) {
                var prefstring = e.getAttribute("prefstring");
                if (prefstring && gDigglerPrefSvc.prefHasUserValue(prefstring)) {
                    var prefattribute = "checked"; // TODO only handles checkboxes so far!
                    var value = gDigglerPrefSvc.getBoolPref(prefstring);
                    e.setAttribute(prefattribute, value);
                }
            }
         }
    }
    catch (e) {
        // alert("exception : " + e);
    }
}

function digglerFBSaveSettings()
{
    for (i = 0; i < _elementIDs.length; i++) {
        var e = document.getElementById(_elementIDs[i]);
        if (e) {
            var prefstring = e.getAttribute("prefstring");
            if (prefstring) {
                var prefattribute = "checked"; // TODO only handles checkboxes so far!
                var value = e.getAttribute(prefattribute);
                if (typeof(value) == "string") {
                    if (value == "true")
                        value = true;
                    else if (value == "false")
                        value = false;
                }
                gDigglerPrefSvc.setBoolPref(prefstring, value);
            }
        }
    }
    window.close();
}
