#!/usr/bin/perl

require LWP::Protocol::http;
require LWP::UserAgent;
use Image::Magick;
use FileHandle;
use DDJDB;
use CGI;
use strict;

my ($single_disc_id)=@ARGV;

my $album_dir="/mp3/album_covers";

my $ddjdb=DDJDB->new(dbname=>"ddj_new",
		     dbserver=>"mp3box",
		     dbuser=>"ddj",
		     dbpswd=>"ddj");

die "unable to connect to db" if(!$ddjdb);

my $result;

if($single_disc_id) {
  $result=$ddjdb->DBCmd("SELECT artist,title,disc.id FROM disc,artist WHERE ".
			"disc.id=$single_disc_id AND disc.artistid=artist.id");
}
else {
  $result=$ddjdb->DBCmd("SELECT artist,title,disc.id FROM disc,artist WHERE ".
			"disc.artistid=artist.id");
}

my $artist;
my $title;
my $disc_id;

while(($artist,$title,$disc_id)=$result->fetchrow) {
  my $image_file="$album_dir/$disc_id.jpg";
  my $auto_image_file="$image_file.auto";

#  if($single_disc_id || !-e $image_file || -e $auto_image_file) {
  if($single_disc_id || !-e $image_file) {
    my $searchstr="$artist $title";
    $searchstr=~s/[^a-zA-Z0-9 _-]//g;
    $searchstr=~s/ /+/g;
    print "ID: $disc_id -- search: $searchstr\n";

    # Put a file here to indicate that this image was automatically grabbed
    `touch $auto_image_file`;

    my $image=GetAlbumImage($searchstr);

    if($image) {
      $image->Write("$image_file");
    }
  }
}

sub GetAlbumImage
{
  my ($searchstr)=@_;
  
  my $urls=GetImageURLs($searchstr,10);
    
  my $num_images=@$urls;

  print "got $num_images urls\n";
  
  foreach my $url (@$urls) {
    $url=CGI::unescape($url);
    $url=CGI::unescape($url);

    my @one_array=($url);

    my $image=GrabImages(\@one_array)->[0];
  
    my $score=0;

    my ($width,$height)=$image->Get('width','height');

    if(abs($width-$height)<5 && $width>99) {
      return $image;
    }
  }
}

sub GetImageURLs
{
  my ($searchstr,$num)=@_;

  my $ua=LWP::UserAgent->new;

  $ua->agent("Mozilla/5.001 (windows; U; NT4.0; en-us) Gecko/25250101");

  my $url="http://images.google.com/images?num=$num&imgsafe=off&q=$searchstr";
#  my $url="http://images.google.com/images?hl=en&lr=&ie=UTF-8&oe=UTF-8&q=$searchstr&btnG=Google+Search";
  
  my $request=HTTP::Request->new(GET=>$url);
  
  my $response=$ua->request($request,undef,undef);
  
  my $html=$response->as_string;

  my @lines=split '\n',$html;
  
  my @urls;
  
  foreach my $line (@lines) {
    if($line=~/.*\/imgres\?imgurl=(.*)\&img.*/) {
      my $url="http://".$1;

      push @urls,$url;
    }
  }

  return \@urls;
}

sub GrabImages
{
  my ($urls)=@_;

  my @handles;

  foreach my $url (@$urls) {
    my $handle=new FileHandle;
    push @handles,$handle;

    if(pipe_from_fork($handle)) {
    }
    else {
      my $image=GrabImage($url);

      print $image;

      close STDOUT;
      exit(0);
    }
  }
 
  my @images;

  foreach my $handle (@handles) {
    my $image=Image::Magick->new(magick=>'jpg');

    my $data;

    while (<$handle>) {
      $data.=$_;
    }

    $image->BlobToImage($data);    

    close $handle;

    push @images,$image;
  }
 

  return \@images;
}

sub GrabImage
{
  my ($url)=@_;

  my $ua=LWP::UserAgent->new;
  
  $ua->agent("Mozilla/5.001 (windows; U; NT4.0; en-us) Gecko/25250101");
  $ua->timeout(10);

  my $request=HTTP::Request->new(GET=>$url);
  
  my $response=$ua->request($request,undef,undef);
  
  return $response->content;
}

sub pipe_from_fork {
  my ($handle)=@_;

  pipe $handle, my $child or die;
  my $pid = fork();
  die "fork() failed: $!" unless defined $pid;
  if ($pid) {
    close $child;
  }
  else {
    close $handle;
    open(STDOUT, ">&=" . fileno($child)) or die;
  }
  $pid;
}
