/* song.h -- header file for song.c
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef DDJ_SONG_H
#define DDJ_SONG_H

#include <mysql.h>
#include <glib.h>

/* Song data stucture */
typedef struct _song
{
  int id;
  char filename[256];
  char title[80];
  int artistid;
  int discid;
  char genre[20];
  int track_num;
  int start_frame;
  int num_frames;
  int mins;
  int secs;
  int bpm;
  int year;
  int gain_adjustment;
} Song;

void GetAllSongs(MYSQL *mysql,IDList *slist);
void GetSongs(MYSQL *mysql,IDList *slist,char *query);
gboolean LookUpSong(MYSQL *mysql,int id,Song *song);
void SongListTimeCalc(MYSQL *mysql,IDList *slist,unsigned long long *bytes,
		      unsigned long long *secs);

#endif /* DDJ_SONG_H */
