/* artist.c --
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <mysql.h>
#include <glib.h>
#include <stdio.h>
#include "artist.h"
#include "mp3db.h"

/* Grab all of the artist in the database, and put them in a list */
void GetAllArtists(MYSQL *mysql,IDList *slist)
{
  GetListFromQuery(mysql,slist,"SELECT id FROM artist",TRUE);
}

gboolean LookUpArtist(MYSQL *mysql,int id,Artist *artist)
{
  MYSQL_RES *res=NULL;
  MYSQL_ROW row;
  char query[256];

  g_snprintf(query,80,"SELECT * FROM artist where id=%d",id);

  if(mysql_query(mysql,query)||
     !(res = mysql_store_result(mysql))||
     !(row=mysql_fetch_row(res))) {
    printf("Query error\n");
    
    return TRUE;
  }

  artist->id=id;
  DBString(artist->name,row[1],80);

  mysql_free_result(res);

  return TRUE;
}

/* Take an Artist idlist and make a song idlist from it */
void ArtistListToSongList(MYSQL *mysql,IDList *alist,IDList *slist)
{
  int pos;
  int num_songs;
  int tot_num_songs=0;
  char query[1024];

  /* First find out how many songs we're dealing with */
  for(pos=0;pos<alist->num_ids;pos++) {
    g_snprintf(query,1024,"SELECT count(*) FROM song WHERE artistid=%d",
	       alist->ids[pos]);

    if(SingleIntQuery(mysql,query,&num_songs)) {
      tot_num_songs+=num_songs;
    }
  }

  slist->ids=g_new(int,tot_num_songs);

  slist->num_ids=0;

  /* Now grab the songs */
  for(pos=0;pos<alist->num_ids;pos++) {
    g_snprintf(query,1024,"SELECT id FROM song WHERE artistid=%d",
	       alist->ids[pos]);

    GetListFromQuery(mysql,slist,query,FALSE);
  }

  UniqeIDList(slist);
}

/* Take an Artist idlist and make a disc idlist from it */
void ArtistListToDiscList(MYSQL *mysql,IDList *alist,IDList *dlist)
{
  int pos;
  int num_discs;
  int tot_num_discs=0;
  char query[1024];

  /* First find out how many discs we're dealing with */
  for(pos=0;pos<alist->num_ids;pos++) {
    g_snprintf(query,1024,"SELECT count(*) FROM disc WHERE artistid=%d",
	       alist->ids[pos]);

    if(SingleIntQuery(mysql,query,&num_discs)) {
      tot_num_discs+=num_discs;
    }
  }

  dlist->num_ids=0;
  
  if(!tot_num_discs)
    dlist->ids=NULL;
  else {
    dlist->ids=g_new(int,tot_num_discs);

    /* Now grab the discs */
    for(pos=0;pos<alist->num_ids;pos++) {
      g_snprintf(query,1024,"SELECT id FROM disc WHERE artistid=%d",
		 alist->ids[pos]);
      
      GetListFromQuery(mysql,dlist,query,FALSE);
    }

    UniqeIDList(dlist);
  }
}
