/*
 * Dpi for HTTPS.
 *
 * THIS IS A PROTOTYPE to illustrate how it is done. Feel free to polish!
 *
 *
 *                            W A R N I N G
 *
 * Maybe the more important thing yet to be discussed is about whether
 * unix domain sockets (UDS) are secure for https. I mean, root can always
 * snoop on sockets (regardless of permissions) so he'd be able to "see" all
 * the traffic. OTOH, if someone has root access on a machine he can do
 * anything, and that includes modifying the binaries or peeking-up in 
 * memory space...
 *
 *
 * Copyright 2003 Jorge Arellano Cid <jcid@dillo.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

/*
 * TODO: a lot of things, this is just a bare bones example.
 *
 * For instance:
 * - Handle cookies (requires cookies to be made a dpi first)
 * - Certificate authentication (asking the user in case it can't be verified)
 * - ...
 *
 */

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>
#include <sys/time.h>
#include <glib.h>

#define BUFLEN 256
#define TOUT 300

/*---------------------------------------------------------------------------*/

/*
 * Task: given a tag and an attribute name, return its value.
 *       (character stuffing is removed here)
 * Return value: the attribute value, or NULL if not present or malformed.
 * (copied from bookmarks.c)
 */          
char *Get_attr_value(char *tag, int tagsize, char *attrname)
{            
   char *p, *q, *ltag, quote, *start, *val = NULL;

   ltag = g_strndup(tag, tagsize);
   if ((p = strstr(ltag, attrname)) &&
       (p = strchr(p, '=')) &&
       (p = strpbrk(p, "'\"")) ) {
      quote = *p;                 
      start = ++p;
      while ((q = strchr(p, quote)) && q[1] == quote)
         p = q + 2;
      if (q) {
         val = g_strndup(start, q - start);
         for (p = q = val; (*q = *p); ++p, ++q)
            if ((*p == '"' || *p == '\'') && p[1] == p[0])
               ++p;
      }
   }         
   g_free(ltag);

   return val;
}


/*---------------------------------------------------------------------------*/

/*
 * Build a shell command using wget for this URL.
 */
gchar *make_wget_cmd(gchar *url)
{
   return g_strdup_printf("wget -O - '%s' 2>/dev/null", url);
}

/*
 * Send the stream with coarse buffering (fastest)
 * Return value: 1: data sent,  0: nothing sent
 */
gint send_stream_3(FILE *in_stream, gchar *url)
{
   gint header = 0;
   gchar buf[4096];
   size_t n;

   while ((n = fread (buf, 1, 4096, in_stream)) > 0) {
      if (n > 0 && !header) {
         printf("<dpi cmd='start_send_page' url='%s'>", url);
      // printf("Content-type: text/html\n\n");
         printf("\n\n");
         header = 1;
      }
      fwrite(buf, 1, n, stdout);
      //fwrite(buf, 1, n, stderr);
   }

   return header;
}

/*
 *
 */
int main(void)
{
   FILE *F_stdin;
   gchar *dpip_tag = NULL, *cmd = NULL, *url = NULL, *http_query = NULL;
   gint rd_len;
   gchar buf[4096];

   /* Read the dpi command from STDIN */
   F_stdin = fdopen (STDIN_FILENO, "r");
   rd_len = read(STDIN_FILENO, buf, 4096);
   dpip_tag = g_strndup(buf, rd_len);
   fclose(F_stdin);
// close(STDIN_FILENO); /* Necessary? */
// g_printerr("[%s]\n", dpip_tag);

g_printerr("{In https.filter.dpi}\n");

   cmd = Get_attr_value(dpip_tag, strlen(dpip_tag), "cmd");
   url = Get_attr_value(dpip_tag, strlen(dpip_tag), "url");
   http_query = Get_attr_value(dpip_tag, strlen(dpip_tag), "query");

g_printerr("{ cmd: %s}\n", cmd);
g_printerr("{ url: %s}\n", url);
g_printerr("{ http_query:\n%s}\n", http_query);

g_printerr("{ sending dpip cmd...}\n");

   printf("<dpi cmd='start_send_page' url='%s'>", url);

g_printerr("{ dpip cmd sent.}\n");


g_printerr("{ sending HTML...}\n");

   printf("Content-type: text/html\n\n");
   printf("<html><body><pre>\n");
   printf("<b>Hi!\n\n");
   printf("  This is the https dpi that just got a request to send\n");
   printf("  the following HTTP query:\n{</b>\n");
   printf("<code>%s</code>\n", http_query);
   printf("<b>}</b>\n\n");
   printf("  <b>*** Dillo doesn't support https yet,");
   printf(" but we're working on it.</b>\n\n");
   printf("  If you're a developer willing to help having https in dillo,\n");
   printf("  please contact our mailing list. We have a working prototype\n");
   printf("  to work with.\n\n");
   printf("  --\n");
   printf("</pre></body></html>\n");

g_printerr("{ HTML content sent.}\n");

   g_free(cmd);
   g_free(url);
   g_free(http_query);
   g_free(dpip_tag);

g_printerr("{ exiting https.dpi}\n");

   return 0;
}

