<?php
require_once 'diogenes.common.inc.php';
require_once 'diogenes.admin.inc.php';

$page = new DiogenesAdmin;

// rcs handle
$rcs = $page->getRcs();

// translations
$page->assign('greeting',__("Page manager"));
$page->assign('msg_submit',__("Submit"));
$page->assign('msg_reset',__("Reset"));
$page->assign('msg_properties',__("Page properties"));
$page->assign('msg_location',__("location"));
$page->assign('msg_title',__("title"));
$page->assign('msg_page_template',__("page template"));
$page->assign('msg_status',__("status"));
$page->assign('msg_perms',__("read access"));
$page->assign('msg_wperms',__("write access"));
$page->assign('msg_actions',__("actions"));
$page->assign('msg_add', array(__("Add a page"),"?action=edit") );

$page->assign('post',$page->script_self());
$page->assign('table',$page->table_page);

$action = (isset($_REQUEST["action"])) ? $_REQUEST["action"] : "";
if (isset($_REQUEST["PID"])) {
  $PID = $_REQUEST["PID"];
  if (!$action) $action="edit";
} else {
  $PID = 0;
}
$doedit = false;


if ($action == "import") {

  // if needed, import a file
  if (isset($_FILES['wordfile']) && is_uploaded_file($_FILES['wordfile']['tmp_name'])) {
    $userfile = strtolower($_FILES['wordfile']['name']);
    if (!substr($userfile,-4,4) == ".doc") {
      $page->info(__("Document name does not end in .doc"));
    } else {
      $mydir = $page->spool->spoolPath($PID);
      $page->info(__("Checking in Word file") . " $userfile");
      $rcs->commit($PID, $globals->wordfile,
                          file_get_contents($_FILES['wordfile']['tmp_name']),
                          "Word file update $userfile" );

      $page->info(__("Importing Word file") . " $userfile");
      $rcs->importWordFile($PID, $globals->htmlfile, $_FILES['wordfile']['tmp_name']);
    }
  } else if (isset($_FILES['htmlfile']) && is_uploaded_file($_FILES['htmlfile']['tmp_name'])) {
    $userfile = strtolower($_FILES['htmlfile']['name']);
    if ( (substr($userfile,-4,4) == ".htm") || (substr($userfile,-5,5) == ".html") ) {
      $page->info(__("Importing HTML file") . " $userfile");
      $rcs->commit( $PID, $globals->htmlfile,
                 $rcs->importHtmlString(file_get_contents($_FILES['htmlfile']['tmp_name'])),
                 "html file import of $userfile" );
    } else {
      $page->info(__("Raw file import") . " $userfile");
      $rcs->commit( $PID, $globals->htmlfile,
                 file_get_contents($_FILES['htmlfile']['tmp_name']),
                 "raw file import of $userfile" );
    }
  }
  $action = "edit";
}

/* add or update a page */
switch ($action) {
case "update":
    $title = $_REQUEST['title'];
    $perms = $_REQUEST['perms'];
    $wperms = $_REQUEST['wperms'];
    $status = $_REQUEST['status'];
    $template = $_REQUEST['template'];

    // check we are not creating a publicly writable page
    // on a barrel with PHP execution enabled!
    if ($page->flags->hasFlag("exec") && ($wperms == 'public')) {
      $page->info(__("world-writable pages are not allowed with PHP execution enabled!"));
      break;
    }

    // check that the location is valid
    if (isset($_REQUEST['location'])) 
    {
      if (!preg_match("/^[a-zA-Z0-9_\-]*$/",$_REQUEST['location'])) {
        $page->info(__("the page location cannot contain spaces or special characters"));
        break;
      } 
      if (in_array($_REQUEST['location'], $globals->invalidlocations)) {
        $page->info(__("this location cannot be used, it is reserved by Diogenes"));
        break;
      }
    }
    
    // this is a new entry, initialise
    if ($PID == 0) {
      // new entry
      $globals->db->query("insert into {$page->table_page} set location='temp'");
      $PID = mysql_insert_id();
      if ($page->checkLogger())
        $_SESSION['log']->log("page_create","{$page->alias}:$PID");
      // initialise the page
      $rcs->newdir("",$PID);
      $rcs->commit($PID,$globals->htmlfile,"");
    }

    // update data fields
    if (!isset($_REQUEST['location'])) {
      // homepage
      $location = '';
    } else {
      // other page
      $location = empty($_REQUEST['location']) ? $PID : $_REQUEST['location'];
    }

    $globals->db->query("update {$page->table_page} set location='$location',title='$title',".
                "perms='$perms',wperms='$wperms',status='$status',template='$template' where PID='$PID'");
    break;
case "edit":
    if ($PID != 0) {
      $result = $globals->db->query("select location,title,perms,status,wperms,template from {$page->table_page} where PID=$PID");
      list($location, $title, $perms, $status, $wperms, $template) = mysql_fetch_row($result);
      mysql_free_result($result);
    } else {
      $location = "";
      $title = "";
      $perms = "public";
      $wperms = "admin";
      $status = 0;
    }
    $doedit = true;
    break;
case "delete":
    $globals->db->query("delete from {$page->table_page} where PID=$PID");
    if ($page->checkLogger())
      $_SESSION['log']->log("page_delete","{$page->alias}:$PID");
    system("rm -rf ". escapeshellarg($rcs->rcsPath($PID)));
    system("rm -rf ". escapeshellarg($rcs->spoolPath($PID)));
    break;
}

$page->assign('doedit',$doedit);
if ($doedit) {
  $canedit = $_SESSION['session']->hasPerms($wperms);

  // "Page" toolbar
  $toolbar = array( array( __("pages catalog"), $page->script_self()) );
  if ($PID != 0) {
    array_push($toolbar, array( __("page properties")) );
    array_push($toolbar, array( __("view page"), $page->urlSite($location ? "$location/" : "")) );
    array_push($toolbar, array( __("browse files"), "files?dir=$PID" ) );
  }
  $page->toolbar(__("Page"), $toolbar);

  // "File" toolbar
  if ($PID != 0) {
    if ( file_exists($page->spool->spoolPath($PID,$globals->wordfile)) ) {
      $toolbar = array( array( __("file revisions"), "files?action=revs&amp;dir=$PID&amp;target={$globals->wordfile}" )); 
    } else {
      $toolbar = array();
      if ($canedit) {
        array_push($toolbar, array( __("raw editor"), "edit?dir=$PID&amp;file={$globals->htmlfile}" ));
        array_push($toolbar, array( __("HTML editor"), "ekit?dir=$PID&amp;file={$globals->htmlfile}" ));
      }
      array_push($toolbar, array( __("file revisions"), "files?action=revs&amp;dir=$PID&amp;target={$globals->htmlfile}" ));
    }
    $page->toolbar(__("File"), $toolbar);
    
  }

  //display form
  $page->assign('PID',$PID);
  $page->assign('location',stripslashes($location));
  $page->assign('title',stripslashes($title));
  $page->assign('perms',$perms);
  $page->assign('wperms',$wperms);
  $page->assign('canedit', $canedit);
  $page->assign('status_val',$status);
  $page->assign('status_opts',array(0=>__("visible"), 1=>__("under construction"), 2=>__("disabled"), 3=>__("archived")));
  $page->assign('template',$template);
  $page->assign('templates',$page->getTemplates());

} else {

  // $doedit == false
  /* build the page catalog */
  $result = $globals->db->query("select PID,location,title,perms from {$page->table_page} ORDER BY location");
  $odd = false;
  while (list($PID,$location,$title,$perms) = mysql_fetch_array($result)) {
    $actions = array(
      array( __("view"), $page->urlSite($location ? "$location/" : "") ),
      array( __("properties"), "?action=edit&amp;PID=$PID"),
      array( __("files"), "files?dir=$PID","action"),
      array( __("revisions"), "files?action=revs&amp;dir=$PID&amp;target={$globals->htmlfile}","action")
     );
     if ($location != '')
       array_push($actions, array( __("delete"), "javascript:del('$PID','$location');","action"));
    $page->append('pages',array(($odd ? 'odd' : 'even'),$location,$title,$actions,$perms));
    $odd = !$odd;
  }
  mysql_free_result($result);

} // $doedit

$page->assign('send',__("Send"));
$page->assign('word',__("Import a Word document"));

if ( file_exists($page->spool->spoolPath($PID,$globals->wordfile)) ) {
  $page->assign('wordblab', __("This page's master document is currently a Word document."));
  $page->assign('wordsend', __("You can upload a new version of the Word document below."));
  $page->assign('wordfile', __("You can get the current version of the file here"));
  $page->assign('wordlnk', array($globals->wordfile,$page->urlSite(($location ? "$location/" : "") . $globals->wordfile)) );
} else {
  $page->assign('wordblab', __("If you wish, you can set this page's content from a Word document."));
  $page->assign('wordsend', __("To do so, simply upload the Word document below."));
}
$page->assign('html',__("Import HTML"));
$page->assign('htmlblab',__("You can replace the current page's contents by uploading an HTML file below."));
$page->assign('htmlstrip',__("If the file name ends with .htm or .html, anything outside the &lt;body&gt;&lt;/body&gt; pair will be stripped."));
$page->display('admin-pages.tpl');
?>
