/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class RelativeImageView
extends View
implements ImageObserver,
MouseListener,
MouseMotionListener {
    public static final String TOP = "top";
    public static final String TEXTTOP = "texttop";
    public static final String MIDDLE = "middle";
    public static final String ABSMIDDLE = "absmiddle";
    public static final String CENTER = "center";
    public static final String BOTTOM = "bottom";
    public static final String IMAGE_CACHE_PROPERTY = "imageCache";
    private static Icon sPendingImageIcon;
    private static Icon sMissingImageIcon;
    private static final String PENDING_IMAGE_SRC = "icons/ImagePendingHK.gif";
    private static final String MISSING_IMAGE_SRC = "icons/ImageMissingHK.gif";
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 32;
    private static final int DEFAULT_BORDER = 1;
    private AttributeSet attr;
    private Element fElement;
    private Image fImage;
    private int fHeight;
    private int fWidth;
    private Container fContainer;
    private Rectangle fBounds;
    private Component fComponent;
    private Point fGrowBase;
    private boolean fGrowProportionally;
    private String BaseUrl;
    private boolean bLoading;
    private static boolean sIsInc;
    private static int sIncRate;
    static /* synthetic */ Class class$com$hexidec$ekit$component$RelativeImageView;

    public RelativeImageView(Element element, String string) {
        super(element);
        this.BaseUrl = string;
        this.initialize(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Element element) {
        Object object;
        RelativeImageView relativeImageView = this;
        synchronized (relativeImageView) {
            this.bLoading = true;
            this.fWidth = 0;
            this.fHeight = 0;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.fElement = element;
            object = element.getAttributes();
            URL uRL = this.getSourceURL();
            if (uRL != null) {
                Dictionary dictionary = (Dictionary)this.getDocument().getProperty(IMAGE_CACHE_PROPERTY);
                this.fImage = dictionary != null ? (Image)dictionary.get(uRL) : Toolkit.getDefaultToolkit().getImage(uRL);
            }
            boolean bl3 = bl2 = (n2 = this.getIntAttr(HTML.Attribute.HEIGHT, -1)) > 0;
            if (!bl2 && this.fImage != null) {
                n2 = this.fImage.getHeight(this);
            }
            if (n2 <= 0) {
                n2 = 32;
            }
            boolean bl4 = bl = (n = this.getIntAttr(HTML.Attribute.WIDTH, -1)) > 0;
            if (!bl && this.fImage != null) {
                n = this.fImage.getWidth(this);
            }
            if (n <= 0) {
                n = 32;
            }
            if (this.fImage != null) {
                if (bl2 && bl) {
                    Toolkit.getDefaultToolkit().prepareImage(this.fImage, n2, n, this);
                } else {
                    Toolkit.getDefaultToolkit().prepareImage(this.fImage, -1, -1, this);
                }
            }
        }
        finally {
            object = this;
            synchronized (object) {
                this.bLoading = false;
                if (bl2 || this.fHeight == 0) {
                    this.fHeight = n2;
                }
                if (bl || this.fWidth == 0) {
                    this.fWidth = n;
                }
            }
        }
    }

    private boolean isURL() {
        String string = (String)this.fElement.getAttributes().getAttribute(HTML.Attribute.SRC);
        return string.toLowerCase().startsWith("file") || string.toLowerCase().startsWith("http");
    }

    private String processSrcPath(String string) {
        String string2;
        String string3 = string;
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        boolean bl = false;
        Document document = this.getDocument();
        if (document != null && (string2 = (String)document.getProperty("com.hexidec.ekit.docsource")) != null) {
            File file2 = new File(string2);
            string3 = new File(file2.getParent(), file.getPath().toString()).toString();
            bl = true;
        }
        if (!bl && (string2 = System.getProperty("system.image.path.key")) != null) {
            string3 = new File(string2, file.getPath()).toString();
        }
        return string3;
    }

    private void waitForImage() throws InterruptedException {
        int n = this.fImage.getWidth(this);
        int n2 = this.fImage.getHeight(this);
        while (true) {
            int n3;
            if (((n3 = Toolkit.getDefaultToolkit().checkImage(this.fImage, n, n2, this)) & 0x40) != 0 || (n3 & 0x80) != 0) {
                throw new InterruptedException();
            }
            if ((n3 & 0x30) != 0) {
                return;
            }
            Thread.sleep(10L);
        }
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    boolean isLink() {
        AttributeSet attributeSet = (AttributeSet)this.fElement.getAttributes().getAttribute(HTML.Tag.A);
        if (attributeSet != null) {
            return attributeSet.isDefined(HTML.Attribute.HREF);
        }
        return false;
    }

    int getBorder() {
        return this.getIntAttr(HTML.Attribute.BORDER, this.isLink() ? 1 : 0);
    }

    int getSpace(int n) {
        return this.getIntAttr(n == 0 ? HTML.Attribute.HSPACE : HTML.Attribute.VSPACE, 0);
    }

    Color getBorderColor() {
        StyledDocument styledDocument = (StyledDocument)this.getDocument();
        return styledDocument.getForeground(this.getAttributes());
    }

    float getVerticalAlignment() {
        String string = (String)this.fElement.getAttributes().getAttribute(HTML.Attribute.ALIGN);
        if (string != null) {
            if ((string = string.toLowerCase()).equals(TOP) || string.equals(TEXTTOP)) {
                return 0.0f;
            }
            if (string.equals(CENTER) || string.equals(MIDDLE) || string.equals(ABSMIDDLE)) {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    boolean hasPixels(ImageObserver imageObserver) {
        return this.fImage != null && this.fImage.getHeight(imageObserver) > 0 && this.fImage.getWidth(imageObserver) > 0;
    }

    private URL getSourceURL() {
        String string = (String)this.fElement.getAttributes().getAttribute(HTML.Attribute.SRC);
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.BaseUrl);
            URL uRL2 = new URL(uRL, string);
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private int getIntAttr(HTML.Attribute attribute, int n) {
        AttributeSet attributeSet = this.fElement.getAttributes();
        if (attributeSet.isDefined(attribute)) {
            int n2;
            String string = (String)attributeSet.getAttribute(attribute);
            if (string == null) {
                n2 = n;
            } else {
                try {
                    n2 = Math.max(0, Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                }
            }
            return n2;
        }
        return n;
    }

    public void setParent(View view) {
        super.setParent(view);
        Container container = this.fContainer = view != null ? this.getContainer() : null;
        if (view == null && this.fComponent != null) {
            this.fComponent.getParent().remove(this.fComponent);
            this.fComponent = null;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        boolean bl;
        super.changedUpdate(documentEvent, shape, viewFactory);
        float f = this.getVerticalAlignment();
        int n = this.fHeight;
        int n2 = this.fWidth;
        this.initialize(this.getElement());
        boolean bl2 = this.fHeight != n;
        boolean bl3 = bl = this.fWidth != n2;
        if (bl2 || bl || this.getVerticalAlignment() != f) {
            this.getParent().preferenceChanged(this, bl2, bl);
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        int n;
        Object object;
        Color color = graphics.getColor();
        this.fBounds = shape.getBounds();
        int n2 = this.getBorder();
        int n3 = this.fBounds.x + n2 + this.getSpace(0);
        int n4 = this.fBounds.y + n2 + this.getSpace(1);
        int n5 = this.fWidth;
        int n6 = this.fHeight;
        int n7 = this.getSelectionState();
        if (!this.hasPixels(this)) {
            graphics.setColor(Color.lightGray);
            graphics.drawRect(n3, n4, n5 - 1, n6 - 1);
            graphics.setColor(color);
            this.loadImageStatusIcons();
            Object object2 = object = this.fImage == null ? sMissingImageIcon : sPendingImageIcon;
            if (object != null) {
                object.paintIcon(this.getContainer(), graphics, n3, n4);
            }
        }
        if (this.fImage != null) {
            graphics.drawImage(this.fImage, n3, n4, n5, n6, this);
        }
        object = this.getBorderColor();
        if (n7 == 2) {
            n = 2 - n2;
            if (n > 0) {
                n3 += n;
                n4 += n;
                n5 -= n << 1;
                n6 -= n << 1;
                n2 = 2;
            }
            object = null;
            graphics.setColor(Color.black);
            graphics.fillRect(n3 + n5 - 5, n4 + n6 - 5, 5, 5);
        }
        if (n2 > 0) {
            if (object != null) {
                graphics.setColor((Color)object);
            }
            n = 1;
            while (n <= n2) {
                graphics.drawRect(n3 - n, n4 - n, n5 - 1 + n + n, n6 - 1 + n + n);
                ++n;
            }
            graphics.setColor(color);
        }
    }

    protected void repaint(long l) {
        if (this.fContainer != null && this.fBounds != null) {
            this.fContainer.repaint(l, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
        }
    }

    protected int getSelectionState() {
        int n = this.fElement.getStartOffset();
        int n2 = this.fElement.getEndOffset();
        if (this.fContainer instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)this.fContainer;
            int n3 = jTextComponent.getSelectionStart();
            int n4 = jTextComponent.getSelectionEnd();
            if (n3 <= n && n4 >= n2) {
                if (n3 == n && n4 == n2 && this.isEditable()) {
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    protected boolean isEditable() {
        return this.fContainer instanceof JEditorPane && ((JEditorPane)this.fContainer).isEditable();
    }

    protected Color getHighlightColor() {
        JTextComponent jTextComponent = (JTextComponent)this.fContainer;
        return jTextComponent.getSelectionColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        block18: {
            if (this.fImage == null || this.fImage != image) {
                return false;
            }
            if ((n & 0xC0) != 0) {
                this.fImage = null;
                this.repaint(0L);
                return false;
            }
            short s = 0;
            if ((n & 2) != 0 && !this.getElement().getAttributes().isDefined(HTML.Attribute.HEIGHT)) {
                s = (short)(s | 1);
            }
            if ((n & 1) != 0 && !this.getElement().getAttributes().isDefined(HTML.Attribute.WIDTH)) {
                s = (short)(s | 2);
            }
            RelativeImageView relativeImageView = this;
            synchronized (relativeImageView) {
                if ((s & 1) == 1) {
                    this.fWidth = n4;
                }
                if ((s & 2) == 2) {
                    this.fHeight = n5;
                }
                if (this.bLoading) {
                    return true;
                }
            }
            if (s == 0) break block18;
            Document document = this.getDocument();
            try {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                this.preferenceChanged(this, true, true);
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            return true;
        }
        if ((n & 0x30) != 0) {
            this.repaint(0L);
        } else if ((n & 8) != 0 && sIsInc) {
            this.repaint(sIncRate);
        }
        return (n & 0x20) == 0;
    }

    public float getPreferredSpan(int n) {
        int n2 = 2 * (this.getBorder() + this.getSpace(n));
        switch (n) {
            case 0: {
                return this.fWidth + n2;
            }
            case 1: {
                return this.fHeight + n2;
            }
        }
        throw new IllegalArgumentException("Invalid axis in getPreferredSpan() : " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                return this.getVerticalAlignment();
            }
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n <= n3) {
            Rectangle rectangle = shape.getBounds();
            if (n == n3) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    protected void resize(int n, int n2) {
        if (n == this.fWidth && n2 == this.fHeight) {
            return;
        }
        this.fWidth = n;
        this.fHeight = n2;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(HTML.Attribute.WIDTH, Integer.toString(n));
        simpleAttributeSet.addAttribute(HTML.Attribute.HEIGHT, Integer.toString(n2));
        ((StyledDocument)this.getDocument()).setCharacterAttributes(this.fElement.getStartOffset(), this.fElement.getEndOffset(), simpleAttributeSet, false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Dimension dimension = this.fComponent.getSize();
        if (mouseEvent.getX() >= dimension.width - 7 && mouseEvent.getY() >= dimension.height - 7 && this.getSelectionState() == 2) {
            Point point = this.fComponent.getLocationOnScreen();
            this.fGrowBase = new Point(point.x + mouseEvent.getX() - this.fWidth, point.y + mouseEvent.getY() - this.fHeight);
            this.fGrowProportionally = mouseEvent.isShiftDown();
        } else {
            this.fGrowBase = null;
            JTextComponent jTextComponent = (JTextComponent)this.fContainer;
            int n = this.fElement.getStartOffset();
            int n2 = this.fElement.getEndOffset();
            int n3 = jTextComponent.getCaret().getMark();
            int n4 = jTextComponent.getCaret().getDot();
            if (mouseEvent.isShiftDown()) {
                if (n3 <= n) {
                    jTextComponent.moveCaretPosition(n2);
                } else {
                    jTextComponent.moveCaretPosition(n);
                }
            } else {
                if (n3 != n) {
                    jTextComponent.setCaretPosition(n);
                }
                if (n4 != n2) {
                    jTextComponent.moveCaretPosition(n2);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fGrowBase != null) {
            Point point = this.fComponent.getLocationOnScreen();
            int n = Math.max(2, point.x + mouseEvent.getX() - this.fGrowBase.x);
            int n2 = Math.max(2, point.y + mouseEvent.getY() - this.fGrowBase.y);
            if (mouseEvent.isShiftDown() && this.fImage != null) {
                float f = this.fImage.getWidth(this);
                float f2 = this.fImage.getHeight(this);
                if (f > 0.0f && f2 > 0.0f) {
                    float f3 = f2 / f;
                    float f4 = (float)n2 / f3;
                    float f5 = (float)n * f3;
                    if (f4 > (float)n) {
                        n = (int)f4;
                    } else {
                        n2 = (int)f5;
                    }
                }
            }
            this.resize(n, n2);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.fGrowBase = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            // empty if block
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private Icon makeIcon(String string) throws IOException {
        int n;
        InputStream inputStream = (class$com$hexidec$ekit$component$RelativeImageView == null ? (class$com$hexidec$ekit$component$RelativeImageView = RelativeImageView.class$("com.hexidec.ekit.component.RelativeImageView")) : class$com$hexidec$ekit$component$RelativeImageView).getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        byteArrayOutputStream.flush();
        byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length == 0) {
            System.err.println("WARNING : " + string + " is zero-length");
            return null;
        }
        return new ImageIcon(byArray);
    }

    private void loadImageStatusIcons() {
        try {
            if (sPendingImageIcon == null) {
                sPendingImageIcon = this.makeIcon(PENDING_IMAGE_SRC);
            }
            if (sMissingImageIcon == null) {
                sMissingImageIcon = this.makeIcon(MISSING_IMAGE_SRC);
            }
        }
        catch (Exception exception) {
            System.err.println("ImageView : Couldn't load image icons");
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sIsInc = true;
        sIncRate = 100;
    }
}

