/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com 
*/


#ifndef __icon_entry_h
#define __icon_entry_h 1

#include <glib.h>
#include <gnome.h>

typedef struct _icon_entry icon_entry;

typedef enum _icon_entry_type icon_entry_type;

enum _icon_entry_type
{ DIRADMIN_UNDEFINED, DIRADMIN_USER, DIRADMIN_GROUP };

struct _icon_entry
{
  gchar *dn;
  gchar *name;
  icon_entry_type type;
};

void icon_entry_destroy (icon_entry * entry);

icon_entry *icon_entry_new (icon_entry * entry);

icon_entry *icon_entry_new_with_parms (gchar * name, gchar * dn,
				       icon_entry_type type);

gboolean
icon_list_click_event (GnomeIconList * widget,
		       GdkEventButton * event, gpointer user_data);

#endif
