/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include <errno.h>
#include <lber.h>
#include <ldap.h>
#include <gnome.h>
#include "profile.h"

GtkWidget *app;
GtkWidget *app_reference;
guint preferences_profile_list_signal_reference;
guint preferences_profile_list_signal_reference2;
guint preferences_loginshells_signal_reference;
guint preferences_loginshells_signal_reference2;
guint preferences_loginshells_signal_reference3;

GList *connection_profile_list;
GList *cached_dir_entries;

connection_profile *current_connection_profile;

typedef struct LoginDefaults
{
  guint PASS_MIN_DAYS;
  guint PASS_MAX_DAYS;
  guint PASS_WARN_AGE;
  guint PASS_INACTIVE_AGE;
  guint PASS_MIN_LEN;
  guint VUID_MIN;
  guint VUID_MAX;
  guint VGID_MIN;
  guint VGID_MAX;
  GList *shells;
}
LoginDefaults;

typedef enum
{ CRYPT, MD5, CLEARTEXT, EXTENDED }
PasswordCryptType;

typedef enum
{ ORGUNIT,ENTIREDIR }
AvoidConflictScope;


typedef struct Userbox
{
  gchar * lastgroup;
  gboolean sambaused;
}
Userbox;



typedef struct Preferences
{
  LoginDefaults logindefaults;
  PasswordCryptType passwordcrypttype;
  Userbox userbox;
  gboolean rfc2307bis;
  gboolean avoidconflicts;
  AvoidConflictScope avoidconflictscope;
}
Preferences;

Preferences preferences;





#define ELEMENTS(x) (sizeof (x) / sizeof (x[0]))

enum
{
  TARGET_USER_DN,
  TARGET_GROUP_DN
};

#define OK 1
#define ERROR 0
