/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include <gnome.h>
#include "profile.h"
#include "dir_entry.h"

gboolean objectview_has_selection (void);

gboolean objectview_icon_has_selection (GnomeIconList* list);

int objectview_num_entries (void);
int objectview_icon_num_entries (GnomeIconList* list);

void objectview_icon_add_begun(GnomeIconList * list);
void objectview_icon_add_finished(GnomeIconList * list);
void objectview_add_finished(void);
void objectview_add_begun(void);
void objectview_clear(void);
void objectview_icon_clear(GnomeIconList *list);

void objectview_fill (void);
void objectview_icon_fill (GnomeIconList * list, GList* entrylist);
void objectview_icon_add (GnomeIconList * list, dir_entry * entry);
void objectview_add (dir_entry * entry);
void objectview_icon_remove_bydn (GnomeIconList * list, gchar * dn);
void objectview_remove_bydn (gchar * dn);

GList *
refresh_directory_data (connection_profile * usethisone);


void
objectview_move_left (void);

void objectview_icon_move_left( GnomeIconList * list );

void
objectview_move_right (void);

void objectview_icon_move_right( GnomeIconList * list );
void
objectview_move_up (void);

void objectview_icon_move_up( GnomeIconList * list );
void
objectview_move_down (void);

void objectview_icon_move_down( GnomeIconList * list );

void objectview_select_first (void);
void objectview_icon_select_first (GnomeIconList* list);

gboolean objectview_keypress(GdkEventKey* event);
void objectview_icon_keypress(GnomeIconList* list, GdkEventKey* event);
void objectview_icon_dump_selections(GnomeIconList* list);
void objectview_icon_clear_selection(GnomeIconList* list);
void objectview_icon_select_by_entry(GnomeIconList* list, dir_entry* entry);
void objectview_typeahead_find(gchar *s);
void objectview_icon_select_all (GnomeIconList*list);
void objectview_select_all(void);
void objectview_clear_selection (void);


