#! /bin/sh

### BEGIN INIT INFO
# Provides:          dirmngr
# Required-Start:    $local_fs $network $remote_fs
# Required-Stop:     $local_fs $network $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: start DirMngr daemon
# Description: DirMngr is a server for managing and downloading certificate
#              revocation lists.
### END INIT INFO

PATH=/sbin:/bin:/usr/sbin:/usr/bin
NAME=dirmngr
DAEMON=/usr/bin/$NAME
PIDFILE=/var/run/$NAME.pid

test -x $DAEMON || exit 5

if [ -r /etc/default/$NAME ]; then
	. /etc/default/$NAME
fi

. /lib/lsb/init-functions


d_start() {
	if pidofproc $DAEMON >/dev/null; then
		:
	else
		mkdir -p /var/run/dirmngr || return 1
		chown dirmngr:dirmngr /var/run/dirmngr || return 1

		output=$(su -c ". /lib/lsb/init-functions && umask 027 && start_daemon -p $PIDFILE $DAEMON --daemon --sh" - dirmngr) || return 1
		eval "$output" || return 1
		pid=$(echo "$DIRMNGR_INFO" | cut -d : -f 2) || return 1
		echo "$pid" >$PIDFILE || return 1

		chmod ${DIRMNGR_SOCKET_MODE:-0777} /var/run/dirmngr/socket || return 1
	fi

	return 0
}


case "$1" in
    start)
	log_daemon_msg "Starting DirMngr" $NAME
	d_start
	log_end_msg $?
	;;
    stop)
	log_daemon_msg "Stopping DirMngr" $NAME
	killproc $DAEMON
	log_end_msg $?
	;;
    status)
	status_of_proc $DAEMON DirMngr
	;;
    restart)
	$0 stop && sleep 1 && $0 start
	;;
    try-restart)
	if $0 status >/dev/null; then
		$0 restart
	else
		exit 0
	fi
	;;
    reload|force-reload)
	log_daemon_msg "Reloading DirMngr configuration" $NAME
	killproc $DAEMON HUP
	log_end_msg $?
	;;
    *)
	log_failure_msg "Usage: $0 {start|stop|status|restart|try-restart|reload|force-reload}"
	exit 2
	;;
esac
