/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "config.h"
#include "linepanel-background.xpm"
#include <bitmapbutton.h>
#include <bitmapslider.h>

void LinePanel::init()
{
    background=new QPixmap((const char **)linepanel_background_xpm);
    eq=0;
    pfl_mix=0;
    mic_mix=0;
    processor=0;
    Gain->setValue(30);
}

void LinePanel::destroy()
{
    client->removeProcessor(processor);
    delete in_left;
    delete in_right;
    delete out_left;
    delete out_right;
#ifdef HAVE_LADSPA
    if(eq)
    {
	processor->removeEffect(eq);
	delete eq;
    }
#endif
    if(pfl_mix)
    {
	processor->removeEffect(pfl_mix);
	delete pfl_mix;
    }
    if(main_mix)
    {
	processor->removeEffect(main_mix);
	delete main_mix;
    }
    if(mic_mix)
    {
	processor->removePostFaderEffect(mic_mix);
	delete mic_mix;
    }
    delete processor;
    delete background;
}

void LinePanel::setInfo(Frame *f, Client *c, Port *mix_l, Port *mix_r, int channel_number)
{
    frame=f;
    client=c;
    
    QString title;
    title.sprintf("Line %d", channel_number);
//    Box->setTitle(title);
    
    QString left_name;
    left_name.sprintf("line_in_%d_left", channel_number);
    QString right_name;
    right_name.sprintf("line_in_%d_right", channel_number);
    
    in_left=new Port(client, left_name, -1, Port::Input);
    in_right=new Port(client, right_name, -1, Port::Input);
    
    left_name.sprintf("line_out_%d_left", channel_number);
    right_name.sprintf("line_out_%d_right", channel_number);
    
    out_left=new Port(client, left_name, -1, Port::Output);
    out_right=new Port(client, right_name, -1, Port::Output);
    
    processor=new LineProcessor(in_left, in_right, out_left, out_right);
    
    client->addProcessor(processor);
    
    Gain_valueChanged(Gain->value());
    
    pfl_mix=new MixEffect;
    pfl_mix->left()->setPort(frame->pfl_left);
    pfl_mix->right()->setPort(frame->pfl_right);
    pfl_mix->setControl(0, 0.0);
    processor->addEffect(pfl_mix);
    main_mix=new MixEffect;
    main_mix->left()->setPort(mix_l);
    main_mix->right()->setPort(mix_r);
    main_mix->setControl(2, 0.0);
    processor->addPostFaderEffect(main_mix);
    mic_mix=new MixEffect;
    mic_mix->left()->setPort(0);
    mic_mix->right()->setPort(0);
    processor->addPostFaderEffect(mic_mix);
    
#ifdef HAVE_LADSPA
    eq=new LadspaEffect;
    eq->loadEffect(client->rate(), 1901, "dj_eq");
    if(!eq || eq->ports() == 0)
    {
	if(eq)
		delete eq;
	eq=0;
	Low->hide();
	Mid->hide();
	High->hide();
    }
    else
    {
	processor->addEffect(eq);
	connect(Low, SIGNAL(valueChanged(int)), this, SLOT(lowChanged(int)));
	connect(Mid, SIGNAL(valueChanged(int)), this, SLOT(midChanged(int)));
	connect(High, SIGNAL(valueChanged(int)), this, SLOT(highChanged(int)));
    }
#else
	Low->hide();
	Mid->hide();
	High->hide();
#endif
}



void LinePanel::lowChanged( int val )
{
    portChanged(0, val);
}


void LinePanel::midChanged( int val )
{
    portChanged(1, val);
}


void LinePanel::highChanged( int val )
{
    portChanged(2, val);
}


void LinePanel::portChanged( int port, int val )
{
#ifdef HAVE_LADSPA
    float v;
    if(val <= 0)
	v=(float)val/100.0*70.0;
    else
	v=(float)val/100.0*24.0;
    eq->setControl(port, v);
#endif
}


void LinePanel::Reset_clicked()
{
    if(eq)
    {
	Low->setValue(0);
	Mid->setValue(0);
	High->setValue(0);
    }
}


void LinePanel::Gain_valueChanged( int val )
{
    val=100-val;
    double gain;
    if(val <= 70)
	gain=(double)val/70;
    else
	gain=1.0+(double)(val-70)/20;
    if(processor)
	processor->setGain(gain);
}


void LinePanel::Pfl_toggled( bool on)
{
    if(pfl_mix)
	pfl_mix->setControl(0, on ? 1.0 : 0.0);
}


Effect * LinePanel::effect()
{
    return pfl_mix;
}



void LinePanel::pflCrossfaderValueChanged( int val )
{
    pfl_mix->setControl(2, (100.0-(float)val)/100.0);
    main_mix->setControl(2, (float)val/100.0);
}


void LinePanel::paintEvent( QPaintEvent *e )
{
    bitBlt(this, 0, 0, background);
}


void LinePanel::setMicMixGain( float val )
{
    if(!mic_mix)
	return;
    mic_mix->setControl(0, val);
}
