#include "metatracker.h"

#include "frame.h"
#include "mainwnd.h"
#include "cfgfile.h"
#include <bitmapbutton.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

Metatracker::Metatracker(Frame *parent)
{
	s_locked=false;
	s_frame=parent;
	s_metadata_active=-1;
	s_locked_text="";
}

Metatracker::~Metatracker()
{
}

void Metatracker::setMetadataActive(int player)
{
	if(s_metadata_active != -1)
	{
		frame->player(s_metadata_active)->PlayMeta->setLit(false);
	}
	s_metadata_active=player;
	frame->player(s_metadata_active)->PlayMeta->setLit(true);
}

bool Metatracker::isMetadataActive(int player)
{
	if(s_metadata_active == player)
		return true;
	return false;
}

void Metatracker::clearMetadata(int player)
{
	if(s_metadata_active != -1)
	{
		if(player == -1 || s_metadata_active == player)
		{
			frame->player(s_metadata_active)->PlayMeta->setLit(false);
			if(config->getValue("MetadataFile", "") != "")
				unlink(config->getValue("MetadataFile", ""));
			if(config->getValue("MetadataCommand", "") != "")
				system(config->getValue("MetadataCommand", ""));
			s_metadata_active=-1;
		}
	}
}

bool Metatracker::isMetadataLocked()
{
	return s_locked;
}

void Metatracker::setLockedMetadata(const char *text)
{
	clearMetadata();
	s_locked=true;
	if(config->getValue("MetadataFile", "") != "")
	{
		FILE *fp=fopen(config->getValue("MetadataFile", ""), "w");
		if(fp)
		{
			fprintf(fp, "TITLE=%s\n", text);
			fclose(fp);
			s_locked_text=text;
		}
		else
		{
			s_locked=false;
			return;
		}
		if(config->getValue("MetadataCommand", "") != "")
			system(config->getValue("MetadataCommand", ""));
	}
}

QString Metatracker::getLockedText()
{
	return s_locked_text;
}

void Metatracker::clearLockedMetadata()
{
	if(!s_locked)
		return;
	s_locked=false;
	s_locked_text="";
	if(config->getValue("MetadataFile", "") != "")
		unlink(config->getValue("MetadataFile", ""));
	if(config->getValue("MetadataCommand", "") != "")
		system(config->getValue("MetadataCommand", ""));
}
