#ifndef _PLAYLIST_H_INCLUDED
#define _PLAYLIST_H_INCLUDED

#include <qwidget.h>
#include "scanthread.h"

class QTabWidget;
class PlayerList;
class QPixmap;

class Playlist : public QWidget
{
Q_OBJECT

public:
	Playlist(QWidget *parent, const char *name = 0, WFlags f = 0);
	~Playlist();

	QString getSelectedFile();
	void doubleClick();
	ScanThread *scanThread();
	void setCurrentSong(int player);
	void setCurrentSongAuto(int player);
	void clearCurrentSong(int player);
	QString getNextSong(int random);
protected:
	QTabWidget *tab_widget;
	QString def_dir;
	ScanThread *scanthread;
	PlayerList *player_list;
	QPixmap *topleft;
	QPixmap *topright;
	QPixmap *bottomleft;
	QPixmap *bottomright;

protected slots:
	void paintEvent(QPaintEvent *e);
	void closeEvent(QCloseEvent *e);
	void resizeEvent(QResizeEvent *e);
	void find_clicked();
	void cdda_clicked();
	void new_clicked();
	void close_clicked();
	void left_clicked();
	void right_clicked();
	void virtual_clicked();
};
#endif
