#ifndef _PUMP_H_INCLUDED
#define _PUMP_H_INCLUDED

#include <qthread.h>

class MeterSet;
class StreamSource;

class Pump : public QThread
{
public:
	Pump();
	~Pump();

	void run();
	void removeStream(StreamSource *s);
	void addStream(StreamSource *s);
	void work();
	void addMeters(MeterSet *m);
	void removeMeters(MeterSet *m);
protected:
	StreamSource *Source;
	QValueList<MeterSet *> meters;
	QWaitCondition pump_wait;
	QMutex clear_sync;
	char buffer[4096];
	float interleaved[2048];
	QValueList<StreamSource *>Streams;
	bool s_stop;
};

#endif
