/*
 *  Remote Network application system for DNAS -- replay-single routine
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: rnas-replay-single.c,v 1.4 2002/10/13 18:37:24 dancer Exp $
 */
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"


static void
rnas_printhelp(void)
{
  fprintf(stderr, 
	  "RNAS application, Copyright (c)2002 Junichi Uekawa.\n\n"
	  "\trnas-replay-single [DNAS options] -- [filename to replay]\n"
	  "Please specify file to replay\n\n\n"
	  );
  dmachinemon_print_commandline_help();      
}

/* load the file into memory */
static void
load_file(const char * filename)
{
  FILE* f=fopen (filename, "r");
  
  if (!f)
    {
      fprintf (stderr, PROGRAMNAME ": cannot open specified file\n");
      exit(1);
    }

  if (dm_process_nodes_input (f, &maininfo, NULL, NULL))
    {
      fprintf (stderr, PROGRAMNAME ": could not handle input...\n");
      exit (1);
    }  

  fclose(f);
}

/* send the info out to the file descriptor. */
static void
send_info(FILE*f)
{
  dm_machinelist * m;
  dm_pairstring * s;
  
  for (m=maininfo.machinedb; m; m=m->next)
    {
      fprintf(f, ":%s:\n", m->machinename);
      for (s=m->data; s; s=s->next)
	{
	  fprintf(f, "%s: %s\n", s->stringtitle, s->stringdata);
	}
    }
}

/* code nicked from -servent */
static int 
handle_clients(void * data)
{				/* access from clients. */
  int t = ( (struct dm_handle_incoming_params*) data )->t;
  FILE*f = (t!=-1)?fdopen(t, "w"):NULL;
  if (!f) 
    {
      fprintf (stderr, "Error: could not open incoming connection ? \n");
      return 0;
    }

  send_info(f);
  
  fclose(f);
  dm_tcp_free_incoming_params(data);
  return 0;
}

/*
  Creating a server interface for clients, giving out info if accessed to this port.
*/
static void
clientserver (void * parameter)
{
  dm_tcp_host_setup("rnas-reply-single", (char*)parameter,
		 (void*) handle_clients);
}

int
main(int ac, char ** av)
{
  dm_commandoption cdat;
  dmachinemon_parse_options(ac, av, &cdat);
  

  if (!av[optind])
    {
      rnas_printhelp();
      exit(1);
    }
  load_file (av[optind]);
  dm_daemonize(&cdat);
  
  clientserver(cdat.port_client);

  exit(0);
}


/*
What follows is a m4 script!
MANUAL([.TH "rnas-replay-single" 1 "2002 Sep 27" "DNAS" "RNAS"
.SH NAME
rnas-replay-single \- RNAS replay daemon
.SH SYNOPSIS
.BI "rnas-replay-single [" "DNAS-options" "] -- [" "filename-to-load" "]"
.SH DESCRIPTION
Replay a RNAS output to fool other RNAS application.
.SH "DNAS OPTIONS"
] m4_include([dmachinemon-commandlineparser.inc]) COMMAND [
.SH "AUTHOR"
Junichi Uekawa <dancer@mikilab.doshisha.ac.jp> <dancer@debian.org> <dancer@netfort.gr.jp>

This manual page is autogenerated from rnas-replay-single.c and 
dmachinemon-commandlineparser.c
.SH "SEE ALSO"
.RI "rnas-dump (" 1 "), "
.RI "rnas-dump-xml (" 1 "), "
.RI "rnas-replay-multi (" 1 "), "
.RI "rnas-monitor-xml (" 1 ")"])
*/

