/*
 * Copyright (C) 2004,2005  Heinz Mauelshagen, Red Hat GmbH.
 *                          All rights reserved.
 *
 * See file LICENSE at the top of this source tree for license information.
 */

/* Cheers utils.h */

#ifndef _BYTEORDER_H
#define _BYTEORDER_H

#ifdef __KLIBC__
#include <endian.h>
#endif

#if BYTE_ORDER == LITTLE_ENDIAN

#define	CVT32(x)
#define	CVT16(x)

#else

static inline int32_t le32_to_cpu(int32_t x)
{
	return((((u_int32_t)x & 0x000000ffU) << 24) | 
	       (((u_int32_t)x & 0x0000ff00U) <<  8) | 
	       (((u_int32_t)x & 0x00ff0000U) >>  8) | 
	       (((u_int32_t)x & 0xff000000U) >> 24));
}

static inline int16_t le16_to_cpu(int16_t x)
{
	return((((u_int16_t)x & 0x00ffU) << 8) | 
	       (((u_int16_t)x & 0xff00U) >> 8));
}

#define	CVT32(x)	do { x = le32_to_cpu(x); } while(0)
#define	CVT16(x)	do { x = le16_to_cpu(x); } while(0)

#endif /* #if BYTE_ORDER != LITTLE_ENDIAN */

#endif
