/*
 * LEDbar.c
 * implements an LED-bar widget
 * Copyright (C) Michael Stickel <michael@cubic.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "LEDbarP.h"

#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

static void btn_up (
#if NeedFunctionPrototypes
		    Widget,XEvent*,String*,Cardinal*
#endif
		    );


static void btn_down (
#if NeedFunctionPrototypes
		      Widget,XEvent*,String*,Cardinal*
#endif
		      );

static XtActionsRec actionsList[] =
{
  {"btn_up", btn_up},
  {"btn_down", btn_down},
};

static char defaultTranslations[] =
"<Btn1Down>: btn_down(1) \n"
"<Btn2Down>: btn_down(2) \n"
"<Btn3Down>: btn_down(3) \n"
"<Btn1Up>: btn_up(1) \n"
"<Btn2Up>: btn_up(2) \n"
"<Btn3Up>: btn_up(3) \n"
;


void redraw_widget (Widget self);


static void _resolve_inheritance (
#if NeedFunctionPrototypes
				  WidgetClass
#endif
				  );


static void initialize (
#if NeedFunctionPrototypes
			Widget ,Widget,ArgList ,Cardinal *
#endif
			);


static void destroy (
#if NeedFunctionPrototypes
		     Widget
#endif
		     );


static void realize (
#if NeedFunctionPrototypes
		     Widget,XtValueMask *,XSetWindowAttributes *
#endif
		     );


static Boolean  set_values (
#if NeedFunctionPrototypes
			    Widget ,Widget ,Widget,ArgList ,Cardinal *
#endif
			    );


static void expose (
#if NeedFunctionPrototypes
		    Widget,XEvent *,Region 
#endif
		    );


static void create_ongc (
#if NeedFunctionPrototypes
			 Widget
#endif
			 );


static void create_offgc (
#if NeedFunctionPrototypes
			  Widget
#endif
			  );


static void recalc_rectangles (
#if NeedFunctionPrototypes
			       Widget
#endif
			       );


/*ARGSUSED*/
#if NeedFunctionPrototypes
static void create_ongc (Widget self)
#else
static void create_ongc (self)Widget self;
#endif
{
  XtGCMask   mask;
  XGCValues  gcv;

  if (((XmsLEDbarWidget)self)->xmsLEDbar.gc_on!=NULL)
    XtReleaseGC(self, ((XmsLEDbarWidget)self)->xmsLEDbar.gc_on);
  mask = GCForeground | GCBackground;
  gcv.background = ((XmsLEDbarWidget)self)->core.background_pixel;
  gcv.foreground = ((XmsLEDbarWidget)self)->xmsLEDbar.onColor;
  ((XmsLEDbarWidget)self)->xmsLEDbar.gc_on = XtGetGC (self, mask, &gcv);
}


/*ARGSUSED*/
#if NeedFunctionPrototypes
static void create_offgc(Widget self)
#else
static void create_offgc (self)Widget self;
#endif
{
  XtGCMask   mask;
  XGCValues  gcv;
  
  if (((XmsLEDbarWidget)self)->xmsLEDbar.gc_off != NULL)
    XtReleaseGC(self, ((XmsLEDbarWidget)self)->xmsLEDbar.gc_off);

  mask = GCForeground | GCBackground;
  gcv.background = ((XmsLEDbarWidget)self)->core.background_pixel;
  gcv.foreground = ((XmsLEDbarWidget)self)->xmsLEDbar.offColor;

  ((XmsLEDbarWidget)self)->xmsLEDbar.gc_off = XtGetGC (self, mask, &gcv);
}

/*ARGSUSED*/
#if NeedFunctionPrototypes
static void recalc_rectangles(Widget self)
#else
static void recalc_rectangles(self)Widget self;
#endif
{
  int  i;

  if (((XmsLEDbarWidget)self)->xmsLEDbar.rect)
    XFree(((XmsLEDbarWidget)self)->xmsLEDbar.rect);
  ((XmsLEDbarWidget)self)->xmsLEDbar.rect = (XRectangle *)XtMalloc(sizeof(XRectangle)*((XmsLEDbarWidget)self)->xmsLEDbar.numboxes);

  for (i=0; i<((XmsLEDbarWidget)self)->xmsLEDbar.numboxes; i++)
    {
      ((XmsLEDbarWidget)self)->xmsLEDbar.rect[i].width  = ((XmsLEDbarWidget)self)->core.width-2;
      ((XmsLEDbarWidget)self)->xmsLEDbar.rect[i].height = (((XmsLEDbarWidget)self)->core.height / ((XmsLEDbarWidget)self)->xmsLEDbar.numboxes)-1;
      ((XmsLEDbarWidget)self)->xmsLEDbar.rect[i].x      = 1;
      ((XmsLEDbarWidget)self)->xmsLEDbar.rect[i].y      = (((XmsLEDbarWidget)self)->xmsLEDbar.rect[i].height+1)*i + 1;
    }
}


static XtResource resources[] =
{
  {XtNnumboxes,XtCNumboxes,XtRInt,sizeof(((XmsLEDbarRec*)NULL)->xmsLEDbar.numboxes),XtOffsetOf(XmsLEDbarRec,xmsLEDbar.numboxes),XtRImmediate,(XtPointer)10 },

  {XtNvalue,XtCValue,XtRInt,sizeof(((XmsLEDbarRec*)NULL)->xmsLEDbar.value),XtOffsetOf(XmsLEDbarRec,xmsLEDbar.value),XtRImmediate,(XtPointer)0 },

  {XtNonColor,XtCOnColor,XtRPixel,sizeof(((XmsLEDbarRec*)NULL)->xmsLEDbar.onColor),XtOffsetOf(XmsLEDbarRec,xmsLEDbar.onColor),XtRString,(XtPointer)"LightGreen"},

  {XtNoffColor,XtCOffColor,XtRPixel,sizeof(((XmsLEDbarRec*)NULL)->xmsLEDbar.offColor),XtOffsetOf(XmsLEDbarRec,xmsLEDbar.offColor),XtRString,(XtPointer)"DarkGreen"},

  {XtNselectCallback,XtCSelectCallback,XtRCallback,sizeof(((XmsLEDbarRec*)NULL)->xmsLEDbar.selectCallback),XtOffsetOf(XmsLEDbarRec,xmsLEDbar.selectCallback),XtRImmediate,(XtPointer)NULL },
};


XmsLEDbarClassRec xmsLEDbarClassRec =
{
  {
  /* core_class part    */
  /* superclass   	*/  (WidgetClass) &coreClassRec,
  /* class_name   	*/  "XmsLEDbar",
  /* widget_size  	*/  sizeof(XmsLEDbarRec),
  /* class_initialize 	*/  NULL,
  /* class_part_initialize*/  _resolve_inheritance,
  /* class_inited 	*/  FALSE,
  /* initialize   	*/  initialize,
  /* initialize_hook 	*/  NULL,
  /* realize      	*/  realize,
  /* actions      	*/  actionsList,
  /* num_actions  	*/  2,
  /* resources    	*/  resources,
  /* num_resources 	*/  5,
  /* xrm_class    	*/  NULLQUARK,
  /* compres_motion 	*/  TRUE ,
  /* compress_exposure 	*/   XtExposeCompressMaximal /*FALSE*/ ,
  /* compress_enterleave*/  TRUE ,
  /* visible_interest 	*/  TRUE ,
  /* destroy      	*/  destroy,
  /* resize       	*/  XtInheritResize,
  /* expose       	*/  expose,
  /* set_values   	*/  set_values,
  /* set_values_hook 	*/  NULL,
  /* set_values_almost 	*/  XtInheritSetValuesAlmost,
  /* get_values+hook 	*/  NULL,
  /* accept_focus 	*/  XtInheritAcceptFocus,
  /* version      	*/  XtVersion,
  /* callback_private 	*/  NULL,
  /* tm_table      	*/  defaultTranslations,
  /* query_geometry 	*/  XtInheritQueryGeometry,
  /* display_acceleator */  XtInheritDisplayAccelerator,
  /* extension    	*/  NULL 
  },
  {
    /* XmsLEDbar_class part */
    /* dummy */  0
  },
};

WidgetClass xmsLEDbarWidgetClass = (WidgetClass) &xmsLEDbarClassRec;
/*ARGSUSED*/


static void btn_up (Widget    self,
		    XEvent   *event,
		    String   *params,
		    Cardinal *num_params)
{
  int btn_nr=1;
  if (*num_params == 0 || sscanf(params[0], "%d", &btn_nr) != 1);
}


/*ARGSUSED*/
static void btn_down (Widget self,
		      XEvent*event,
		      String*params,
		      Cardinal*num_params)
{
#if 0
  int btn_nr=1;
  int tvalue=((XmsLEDbarWidget)self)->xmsLEDbar.value;

  if (*num_params == 0 || sscanf(params[0], "%d", &btn_nr) != 1);
  switch (btn_nr)
    {
    case 1: /* up */
      if (tvalue<((XmsLEDbarWidget)self)->xmsLEDbar.numboxes)  tvalue++;
      break;
    case 3:
      if (tvalue>0)  tvalue--;
      break;
    }
  if (((XmsLEDbarWidget)self)->xmsLEDbar.value!=tvalue)
    {
      XtVaSetValues(self, XtNvalue, tvalue, NULL);
      XtCallCallbackList(self, ((XmsLEDbarWidget)self)->xmsLEDbar.selectCallback, (XtPointer) ((XmsLEDbarWidget)self)->xmsLEDbar.value);
      
    }
#else
  XtCallCallbackList(self, ((XmsLEDbarWidget)self)->xmsLEDbar.selectCallback, (XtPointer) ((XmsLEDbarWidget)self)->xmsLEDbar.value);
#endif
}

static void _resolve_inheritance (WidgetClass class)
{
  /*XmsLEDbarWidgetClass c = (XmsLEDbarWidgetClass) class;*/
  XmsLEDbarWidgetClass super;
  if (class == xmsLEDbarWidgetClass)
    return;
  super = (XmsLEDbarWidgetClass)class->core_class.superclass;
}


/*ARGSUSED*/
#if NeedFunctionPrototypes
static void initialize(Widget  request,Widget self,ArgList  args,Cardinal * num_args)
#else
static void initialize(request,self,args,num_args)Widget  request;Widget self;ArgList  args;Cardinal * num_args;
#endif
{
  /*Display *disp = XtDisplay(self);*/
#if 0
  ((XmsLEDbarWidget)self)->core.width  = 20;
  ((XmsLEDbarWidget)self)->core.height = 100;
#endif
#if 0
  ((XmsLEDbarWidget)self)->xmsLEDbar.onColor = WhitePixel (disp, DefaultScreen(disp));
#endif
  ((XmsLEDbarWidget)self)->xmsLEDbar.gc_on  = NULL;
  ((XmsLEDbarWidget)self)->xmsLEDbar.gc_off = NULL;

  ((XmsLEDbarWidget)self)->xmsLEDbar.rect = NULL;

  recalc_rectangles(self);
  create_ongc (self);
  create_offgc(self);
}



/*ARGSUSED*/
#if NeedFunctionPrototypes
static void destroy(Widget self)
#else
static void destroy(self)Widget self;
#endif
{
  if (((XmsLEDbarWidget)self)->xmsLEDbar.rect) XFree(((XmsLEDbarWidget)self)->xmsLEDbar.rect);
}



/*ARGSUSED*/
#if NeedFunctionPrototypes
static void realize(Widget self,XtValueMask * mask,XSetWindowAttributes * attributes)
#else
static void realize(self,mask,attributes)Widget self;XtValueMask * mask;XSetWindowAttributes * attributes;
#endif
{
  coreClassRec.core_class.realize(self, mask, attributes);

  recalc_rectangles(self);
  create_ongc (self);
  create_offgc(self);

/*  XtVaSetValues($, XtNbackgroundPixmap, $pix[1], NULL); */
}



/*ARGSUSED*/
#if NeedFunctionPrototypes
static Boolean  set_values (Widget  old,Widget  request,Widget self,ArgList  args,Cardinal * num_args)
#else
static Boolean  set_values (old,request,self,args,num_args)Widget  old;Widget  request;Widget self;ArgList  args;Cardinal * num_args;
#endif
{
#define SELF ((XmsLEDbarWidget)self)
#define OLD  ((XmsLEDbarWidget)old)

  Boolean  need_redisplay = False;

  if (SELF->xmsLEDbar.onColor != OLD->xmsLEDbar.onColor)
    {
      create_ongc (self);
      need_redisplay = True;
    }

  if (SELF->xmsLEDbar.offColor != OLD->xmsLEDbar.offColor)
    {
      create_offgc (self);
      need_redisplay = True;
    }

  if (SELF->xmsLEDbar.value != OLD->xmsLEDbar.value)
    {
      if (SELF->xmsLEDbar.value < 0)
	SELF->xmsLEDbar.value = 0;

      if (SELF->xmsLEDbar.value > SELF->xmsLEDbar.numboxes)
	SELF->xmsLEDbar.value = SELF->xmsLEDbar.numboxes;

      if (SELF->xmsLEDbar.value != OLD->xmsLEDbar.value)
	need_redisplay = True;
    }

  if (SELF->xmsLEDbar.numboxes != OLD->xmsLEDbar.numboxes)
    {
      recalc_rectangles (self);
      need_redisplay = True;
    }

  if (SELF->core.width != OLD->core.width || SELF->core.height != OLD->core.height)
    {
      recalc_rectangles (self);
      need_redisplay = True;
    }

  if (need_redisplay)
    redraw_widget (self);

  return 0; /* don't clear the window so no flicker will be generated */
#undef SELF
#undef OLD
}


/*ARGSUSED*/
#if NeedFunctionPrototypes
static void expose(Widget self,XEvent * event,Region  region)
#else
static void expose(self,event,region)Widget self;XEvent * event;Region  region;
#endif
{
  redraw_widget (self);
}

void redraw_widget (Widget self)
{
#define SELF ((XmsLEDbarWidget)self)
#define OLD  ((XmsLEDbarWidget)old)

  Display *disp = XtDisplay(self);
  Window   win  = XtWindow(self);

  /* Display the dark LEDS */
  if (SELF->xmsLEDbar.value < SELF->xmsLEDbar.numboxes)
    XFillRectangles (disp, win, SELF->xmsLEDbar.gc_off, SELF->xmsLEDbar.rect,
		     (SELF->xmsLEDbar.value > 0)
		     ? (SELF->xmsLEDbar.numboxes - SELF->xmsLEDbar.value)
		     : (SELF->xmsLEDbar.numboxes) );


  /* Display the light LEDS */
  if (SELF->xmsLEDbar.value > 0)
    {
      if (SELF->xmsLEDbar.value < SELF->xmsLEDbar.numboxes)
	XFillRectangles (disp, win, SELF->xmsLEDbar.gc_on,
			 &(SELF->xmsLEDbar.rect[SELF->xmsLEDbar.numboxes-SELF->xmsLEDbar.value]),
			 SELF->xmsLEDbar.value);
      else
	XFillRectangles (disp, win, SELF->xmsLEDbar.gc_on, SELF->xmsLEDbar.rect, SELF->xmsLEDbar.numboxes);
    }

  XMapWindow (disp, win);
  XFlush (disp);

#undef SELF
#undef OLD
}
