#include <config.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "dnotify.h"

int quiet = 0;

void die(const char *msg, ...)
{
	va_list ap;

	va_start(ap, msg);
	fprintf(stderr, "%s: ", program_invocation_name);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);
	exit(1);
}

void warn(const char *msg, ...)
{
	va_list ap;

	if (!quiet) {
		va_start(ap, msg);
		fprintf(stderr, "%s: ", program_invocation_name);
		vfprintf(stderr, msg, ap);
		fprintf(stderr, "\n");
		va_end(ap);
	}
}

