<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
  xmlns:l="http://docbook2x.sourceforge.net/xsl/localization"
  xmlns:dl="http://docbook2x.sourceforge.net/xsl/document-localization"
  exclude-result-prefixes="doc l dl"
  version='1.0'
  xml:lang="en">

<!-- ********************************************************************
     $Id: gentext.xsl,v 1.2 2003/05/24 19:18:25 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     Templates to help l10n.
     ******************************************************************** -->
<!-- ==================================================================== -->

<xsl:template name="gentext-title">
  <xsl:param name="element-name" select="name(.)" />
  <xsl:param name="content" />
  <xsl:param name="lang">
    <xsl:call-template name="l10n-xml-actual-language">
      <xsl:with-param name="target" select="." />
    </xsl:call-template>
  </xsl:param>

  <xsl:param name="key" />

  <xsl:apply-templates
    select="($l10n-data/l:locale[@lang=$lang]/dl:title[@element=$element-name])[last()]/node()"
    mode="l10n-substitution">
    <xsl:with-param name="content" select="$content" />
  </xsl:apply-templates>

</xsl:template>

<xsl:template name="gentext-label">
  <xsl:param name="element-name" select="name(.)" />
  <xsl:param name="content" />
  <xsl:param name="lang">
    <xsl:call-template name="l10n-xml-actual-language">
      <xsl:with-param name="target" select="." />
    </xsl:call-template>
  </xsl:param>

  <xsl:param name="key" />

  <xsl:apply-templates
    select="($l10n-data/l:locale[@lang=$lang]/dl:label[@element=$element-name])[last()]/node()"
    mode="l10n-substitution">
    <xsl:with-param name="content" select="$content" />
  </xsl:apply-templates>

</xsl:template>

<xsl:template name="gentext-rendering">
  <xsl:param name="key" select="name(.)" />
  <xsl:param name="content" />
  <xsl:param name="lang">
    <xsl:call-template name="l10n-xml-actual-language">
      <xsl:with-param name="target" select="." />
    </xsl:call-template>
  </xsl:param>

  <xsl:param name="key" />

  <xsl:apply-templates
    select="($l10n-data/l:locale[@lang=$lang]/dl:rendering[@key=$key])[last()]/node()"
    mode="l10n-substitution">
    <xsl:with-param name="content" select="$content" />
  </xsl:apply-templates>

</xsl:template>


<xsl:template name="gentext-text">
  <xsl:param name="target" select="." />
  <xsl:param name="key" />
  <xsl:param name="lang">
    <xsl:call-template name="l10n-xml-actual-language">
      <xsl:with-param name="target" select="$target" />
    </xsl:call-template>
  </xsl:param>

  <xsl:value-of
    select="($l10n-data/l:locale[@lang=$lang]/dl:text[@key=$key])[last()]/node()" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="dl:content" mode="l10n-substitution">
  <xsl:param name="content" />
  <xsl:copy-of select="$content" />
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>

