<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: table.xsl,v 1.1 2003/06/15 21:39:55 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2002 Steve Cheng <stevecheng@users.sourceforge.net>

     ******************************************************************** -->

<xsl:template match="table">
  <xsl:call-template name="make-caption" />
  <table>
    <xsl:apply-templates select="@*" mode="copy" />
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="informaltable">
  <table>
    <xsl:apply-templates select="@*" mode="copy" />
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="tgroup">
  <xsl:copy>
    <xsl:apply-templates select="@*" mode="copy" />
    <xsl:apply-templates select="colspec|spanspec" />
    <xsl:apply-templates select="thead" />
    <xsl:apply-templates select="tbody" />
    <xsl:apply-templates select="tfoot" />
  </xsl:copy>
</xsl:template>

<xsl:template match="colspec|spanspec">
  <xsl:call-template name="copy-through" />
</xsl:template>

<xsl:template match="thead|tbody|tfoot">
  <xsl:call-template name="copy-through" />
</xsl:template>

<xsl:template match="row">
  <xsl:call-template name="copy-through" />
</xsl:template>

<xsl:template match="entry">
  <entryblk>
    <xsl:apply-templates select="@*" mode="copy" />
    <xsl:apply-templates />
  </entryblk>
</xsl:template>

<xsl:template name="copy-through">
  <xsl:copy>
    <xsl:apply-templates select="@*" mode="copy" />
    <xsl:apply-templates />
  </xsl:copy>
</xsl:template>

<xsl:template match="@*" mode="copy">
  <xsl:copy>
    <xsl:value-of select="." />
  </xsl:copy>
</xsl:template>


</xsl:stylesheet>
