<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                xmlns:l="http://docbook2x.sourceforge.net/xsl/localization"
                exclude-result-prefixes="doc l"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: xref.xsl,v 1.18 2003/05/24 13:52:46 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template match="anchor">
  <xsl:call-template name="anchor" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="xref">
  <xsl:variable name="target" select="key('id', @linkend)"/>

  <xsl:choose>
    <xsl:when test="not($target)">
      <!-- No such ID -->
      <xsl:call-template name="user-message">
        <xsl:with-param name="arg-1" select="@linkend" />
        <xsl:with-param name="key">Reference to non-existent ID</xsl:with-param>
        <xsl:with-param name="content">Reference to non-existent ID "<l:a1 />"</xsl:with-param>
        
      </xsl:call-template>
      <xsl:call-template name="gentext-rendering">
        <xsl:with-param name="key" select="'dangling-xref'" />
        <xsl:with-param name="content" select="string(@linkend)" />
      </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
    <ref>
      <xsl:attribute name="node">
        <xsl:call-template name="get-texinfo-node-name">
          <xsl:with-param name="node" select="$target" />
        </xsl:call-template>
      </xsl:attribute>

      <xsl:attribute name="file">
        <!-- FIXME: Theoretically, we can go to the hash for this too,
             for some speed gain -->
        <xsl:call-template name="get-texinfo-file-name">
          <xsl:with-param name="node" select="$target" />
        </xsl:call-template>
      </xsl:attribute>

      <!-- FIXME Printed manual name -->

      <xsl:apply-templates select="$target" mode="xref-to" />
    </ref>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="link">
  <xsl:variable name="target" select="key('id', @linkend)"/>

  <xsl:choose>
    <xsl:when test="not($target)">
      <!-- No such ID -->
            <xsl:call-template name="user-message">
        <xsl:with-param name="arg-1" select="@linkend" />
        <xsl:with-param name="key">Reference to non-existent ID</xsl:with-param>
        <xsl:with-param name="content">Reference to non-existent ID "<l:a1 />"</xsl:with-param>
        
      </xsl:call-template>
      <xsl:call-template name="gentext-rendering">
        <xsl:with-param name="key" select="'dangling-xref'" />
        <xsl:with-param name="content" select="string(@linkend)" />
      </xsl:call-template>
    </xsl:when>

    <xsl:when test="$links-use-pxref">
      <xsl:apply-templates />
      <xsl:text> (</xsl:text>
    
      <pxref>
        <xsl:attribute name="node">
          <xsl:call-template name="get-texinfo-node-name">
            <xsl:with-param name="node" select="$target" />
          </xsl:call-template>
        </xsl:attribute>

        <xsl:attribute name="file">
          <xsl:call-template name="get-texinfo-file-name">
            <xsl:with-param name="node" select="$target" />
          </xsl:call-template>
        </xsl:attribute>
      </pxref>
    
      <xsl:text>)</xsl:text>
    </xsl:when>

    <xsl:otherwise>
      <ref>
        <xsl:attribute name="node">
          <xsl:call-template name="get-texinfo-node-name">
            <xsl:with-param name="node" select="$target" />
          </xsl:call-template>
        </xsl:attribute>

        <xsl:attribute name="file">
          <xsl:call-template name="get-texinfo-file-name">
            <xsl:with-param name="node" select="$target" />
          </xsl:call-template>
        </xsl:attribute>

        <!-- FIXME Printed manual name -->

        <xsl:apply-templates />
      </ref>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="ulink">
  <uref>
    <xsl:attribute name="url"><xsl:value-of select="@url"/></xsl:attribute>
    <xsl:apply-templates/>
  </uref>
</xsl:template>

<xsl:template match="olink">
  <xsl:apply-templates/>
</xsl:template>

<!-- ==================================================================== -->

<doc:mode mode="xref-to" xmlns="">
<refpurpose>Give cross-reference markup</refpurpose>
<refdescription>
<para>
Processing an element with this mode returns the markup/text that should
be used for referring to it in cross-references.</para>
<para>
Since Texinfo already handles cross references to nodes, this mode
does mostly nothing.  FIXME: However we need something for anchors...
</para>
</refdescription>
</doc:mode>

<xsl:template match="*" mode="xref-to">
  <xsl:choose>
    <xsl:when test="@xreflabel">
      <xsl:value-of select="@xreflabel" />
    </xsl:when>

    <xsl:otherwise>
      <!-- Otherwise same as the title. -->
      <xsl:apply-templates select="." mode="for-title" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
