<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: admon.xsl,v 1.10 2004/05/17 00:00:15 stevecheng Exp $
     ********************************************************************

     Copyright 2000-2003 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     See the file COPYING in the docbook2X distribution for
     copyright and license details.

     ******************************************************************** -->

<xsl:template match="note|important|warning|caution|tip">
  <quotation>
    <xsl:call-template name="anchor" />
  
    <xsl:call-template name="make-caption">
      <xsl:with-param name="content">
        <xsl:choose>
          <xsl:when test="./title">
            <xsl:apply-templates select="./title" mode="admonition.title.mode" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="gentext-title" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:with-param>
    </xsl:call-template>
  
    <xsl:apply-templates />
  
  </quotation>
</xsl:template>


<xsl:template match="title" mode="admonition.title.mode">
  <xsl:apply-templates />
</xsl:template>

</xsl:stylesheet>
