package hcsshim

import (
	"io"
	"syscall"

	"github.com/Microsoft/go-winio"
)

var (
	vmcomputedll          = syscall.NewLazyDLL("vmcompute.dll")
	hcsCallbackAPI        = vmcomputedll.NewProc("HcsRegisterComputeSystemCallback")
	hcsCallbacksSupported = hcsCallbackAPI.Find() == nil
)

// makeOpenFiles calls winio.MakeOpenFile for each handle in a slice but closes all the handles
// if there is an error.
func makeOpenFiles(hs []syscall.Handle) (_ []io.ReadWriteCloser, err error) {
	fs := make([]io.ReadWriteCloser, len(hs))
	for i, h := range hs {
		if h != syscall.Handle(0) {
			if err == nil {
				fs[i], err = winio.MakeOpenFile(h)
			}
			if err != nil {
				syscall.Close(h)
			}
		}
	}
	if err != nil {
		for _, f := range fs {
			if f != nil {
				f.Close()
			}
		}
		return nil, err
	}
	return fs, nil
}
