Name: doclifter
Version: 1.8
Release: 1
URL: http://www.catb.org/~esr/doclifter/
Source0: %{name}-%{version}.tar.gz
License: GPL 
Group: Applications/System
Requires: python2
Summary: converts man/mdoc/ms/me/mm documents to DocBook
BuildRoot: %{_tmppath}/%{name}-root
BuildArch: noarch
#Keywords: "DocBook, man, ms, mm, me, mdoc, lifting, XML, SGML"

%description
The doclifter program translates documents written in troff macros to DocBook.
Lifting documents from presentation level to semantic level is hard, and
a really good job requires human polishing.  This tool aims to do everything
that can be mechanized, and to preserve any troff-level information that might
have structural implications in XML comments.  

%prep
%setup -q

%build
make doclifter.1

%install
[ "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"
mkdir -p "$RPM_BUILD_ROOT"%{_bindir}
mkdir -p "$RPM_BUILD_ROOT"%{_mandir}/man1/
cp doclifter "$RPM_BUILD_ROOT"%{_bindir}
cp doclifter.1 "$RPM_BUILD_ROOT"%{_mandir}/man1/

%clean
[ "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"

%files
%defattr(-,root,root,-)
%doc README COPYING
%{_mandir}/man1/doclifter.1*
%{_bindir}/doclifter

%changelog
* Mon Mar  1 2004 Eric S. Raymond <esr@snark.thyrsus.com> 1.8-1
- Avoid choking on malformed tables in Qt pages.  Fix minor bug in handling 
  of nested .if/.ie requests. Process Fa macro correctly.

* Tue Feb 17 2004 Eric S. Raymond <esr@snark.thyrsus.com> 1.7-1
- Handle .Pa tags in synopses better.  This version lifts 96% of 10316
  man pages in a full Fedora Core 1 installation.

* Fri Jan  2 2004 Eric S. Raymond <esr@snark.thyrsus.com> 1.6-1
- Simpler, better entity translation logic; the -s and -x options are gone.

* Mon Dec 29 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.5
- Fixes to RPM packaging.

* Wed Dec 26 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.4
- Handle .TQ reduction.  Translate attempts to fake up double quotes
  in text with `` and ''.  Catch a few more .RS/.RE cases.

* Mon Dec 15 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.3
  Process .RS/.RE tags to generate list nesting.  As a side effect,
  this change fixes bad interactions between .ig and .TP. Fix a bug in 
  gathering hints from function prologs.  Use <varname>
  rather than <symbol> for variables.  Work around a common bug in ISC
  man pages. Evaluate one-line .el macros properly.

* Mon Dec 08 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.2
- SGML-generation support removed; the -s and -x options now
  control whether troff special characters are translated to the
  ISO entity set or the XHTML entity set.
  Corrected a bug in processing of synopses with multiple commands.
  Handle \f[012434] font changes in synopses correctly. -D option
  supports posting hints at startup time.  Better recognition of 
  filenames and commands in running text.  Error return values
  now convey more information.

* Thu Dec 04 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.1
- Fixed a bug in conditional evaluation that twadmin(8) tickled.
  Better detection of pure inclusions. Better blank-section 
  elimination.  Kleene star recognized as ... synonym in command
  synopses.  Correct some bugs in semantic-hint collection.
  Limited internationalization -- recognize "NAME" in a couple
  of different languages.  Recognize Qt manual pages and use their
  conventions.  Better lifting of mandoc-generated pages. Translate
  groff-style \[...] escapes, flag unknown ones.  Can now parse
  K&R style function prototypes as well as ANSI ones. This version 
  lifts 96% of 9829 manual pages in a full Red Hat 9 installation
  with Fedora updates to *validated* XML-DocBook.

* Thu Nov 20 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.0.6
- Lots of changes made so the XML output will pass validation.
  Appropriately wrap <citerefentry> sequences generated from SEE ALSO.
  Clean up generated <sbrk/> tags when we don't find a function or
  command synopsis.  Push back folded highlights so paragraph generation
  doesn't get screwed up.  Don't generate invalid class attribute for
  <programlisting> and <symbol>.  The .RS command no longer ends a
  .IP or .TP entry.  Correct .Ql so it doesn't generate spurious 
  line breaks. Fix a bug in <group> syntax processing.  Declare <envar>
  <constant>, and <errorcode> in-line tags (avoids fooups in processing 
  mdoc). Fix lexer bug that dropped a character after """ in tokens.
  Evaluate groff-style \\n[...] register escapes, \\n(.$., \w, and .g.
  Generate IDs correctly even when section titles are in CJK.  Accept
  options starting with +. The mdoc interpreter can now deal with an
  out-of-order Synopsis section. This version lifts 94% of 9829 manual
  pages in a full Red Hat 9 installation with Fedora updates.

* Tue Oct 21 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.0.5
- Translate Version 8 .L macro and friends.  Fix some minor markup
  problems in doclifter.xml.

* Tue Mar 18 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.0.4
- Improved synopsis line detection. Added Berkely Bsx. Ox, Nx macros.
  Implemented extended groff ab, als, nop and return requests.  Some 
  effort is now made to identify markup that refers to section headers
  and lift it to link tags (by Aaron Hawley).  Corrected erroneous
  handling of string quotes around request arguments.  Implemented
  mdoc .Ex and .Rv macros.  Better handling of \d, \u, and \v troff
  requests.

* Fri Feb 14 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.0.3
- Enable translation of PIC diagrams using pic2plot. Lift highlighted 
  .*_t and errno appropriately.  Implemented .fam and \F groff
  extensions.  Improved synopsis line detection.  Interpret DS/DE in
  manual pages (it's illegal but unambiguous).  Work around common
  error of putting an opening ' at the left margin. This version lifts 
  96% of 6705 manual pages in a Red Hat 8.0 install.

* Thu Feb 13 2003 Eric S. Raymond <esr@snark.thyrsus.com> 1.0.2
- Corrected a bug in processing of the .SM highlight on manual pages.
  This affects other font changers with two-character names, notably CW.

* Tue Sep 17 2002 Eric S. Raymond <esr@snark.thyrsus.com>  1.0.1
- Prevent some false matches on mwww macros.  Don't generate 
  entity inclusion files into the internal set; Tim Waugh says
  it's not necessary and indeed it seems not to be when I'm using xmlto.

* Sat Aug 17 2002 Eric S. Raymond <esr@snark.thyrsus.com>  1.0.0
- Better firewalling against unbalanced font changes -- unbalanced
  markup can no longer break the translation. Drastically 
  improved parsing of function prototypes. Support for mwww macros.
  Added groff-1.18's euro and micro signs.  Also now interpreting
  various historical fossils from Ultrix and elsewhere that show up
  on Linux manual pages.  This version lifts 95% of the 5548 man pages
  in a full Red Hat 7.3 workstation install.

* Tue Jul 30 2002 Eric S. Raymond <esr@snark.thyrsus.com> 0.99
- C declaration parsing for sections 2 and 3 by Pradeep Padala.
  Improvements in command-synopsis parsing.  Applied Michael
  Smith's XML-compliance patch.  Default changed to XML to 
  go with 7.3 toolchain.  Added -s option.  This version lifts
  97% of 4253 man pages in a full Red Hat 7.3 install.

* Mon Jul 15 2002 Eric S. Raymond <esr@snark.thyrsus.com> 0.95
- Point release for Pradeep Padala.
  Added Windows port fix. Better command marking from synopsis 
  sections.  Oops, allow tildes in URLs.  We can handle multiple
  stacked .TP entries now.  Implement groff mso, ignore ftr.
  Crude, non-semantic lifting of function synopses.

* Tue Nov 9 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.9
- Add mm support.  Resolve Latin 1 and Latin 2 entities correctly.  
  Don't let line numbering be confused by saved sections.  Handle 
  non-syntactic [] in optional filename extensions.  Improved 
  generation of included entities.

* Mon Nov 5 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.8
- Catch and foil attempts to rename immutable macros.  Better
  handling of unbalanced highlights.  Multiple name lines are
  now passed through with the first one parsed. 96% success on 
  sections 1 and 8 of a full Red Hat install.

* Tue Oct 31 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.7
- Multiple vertically-stacked hanging tags are now translated into
  Synopsis sections.  Mdoc bibliography macros are supported.
  Paragraphed text in Synopsis sections is now handled. Tcl/Tk
  extension macros are processed.  92% success on section 1 of a
  full Red Hat install.

* Tue Oct 18 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.6
- Better handling of weird highlight and paragraphing combinations.

* Tue Oct 2 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.5
- Support for Berkeley mdoc.

* Wed Sep 5 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.4
- Don't rely on compilerlike.py being available.

* Tue Sep 4 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.3
- More steps towards mandoc interpretation.  Checkpoint release for 
  Jorge Godoy and Jeffrey Franks.

* Fri Aug 31 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.2
- Extra arguments of .TH are now passed through.  \c is now handled
  properly rather than just being nuked.  Now formats a dozen or
  so more problem pages.  Magic inclusion semantics and -I.  Full
  support for extended groff_char(7) characters.  Implemented .tr.

* Mon Aug 27 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.1
- Initial build.

* Thu Aug 16 2001 Eric S. Raymond <esr@snark.thyrsus.com> 0.0
- First RCS commit.  Project launched

