#ifndef Check_h
#define Check_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;

namespace doctorj
{
    class AstItem;
    class ErrorRegistry;
    class Reporter;

    /**
     * A check.
     */
    class Check
    {
    public:
        Check();

        Check(Reporter* const reporter);

        /**
         * Writes the verbose description to the given output stream.
         */
        virtual void describe(ostream& os) const;

        /**
         * Returns the title of this error.
         */
        virtual string title() const = 0;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const = 0;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const = 0;

        /**
         * Returns the registry that this (type of) error uses.
         */
        virtual ErrorRegistry* getErrorRegistry() const = 0; 

        /**
         * Returns the identifier.
         */
        virtual int identifier() const;

        /**
         * Returns the ID, which is a concatenation of the category and the
         * identifier.
         */
        virtual string id() const;

        /**
         * Returns the category.
         */
        virtual char category() const;

        /**
         * These objects may be copied after being reported. Thus, they can only
         * be created on the heap. Thus, you should use <code>destroy</code>.
         */
        virtual void destroy() const;

    protected:

        virtual ~Check();

        /**
         * Returns the reporter this error uses.
         */
        Reporter* reporter() const;

    private:

        /**
         * Where this error will be reported.
         */
        Reporter* reporter_;


    };
}

#endif //! Check_h
