#ifndef Error_h
#define Error_h

#ifndef Check_h
#include "Check.h"
#endif

using namespace std;

namespace doctorj
{
    class AstItem;
    class StringEdit;

    /**
     * An error that is reported by an analyzer. "Error" also includes warnings.
     * Subclasses of this class should register with the ErrorRegistry singleton.
     */
    class Error : public Check
    {
    public:
        Error();

        /**
         * Associates this error with the given item.
         */
        Error(Reporter* const reporter, AstItem* const item);

        /**
         * Returns the item to which the error pertains.
         */
        virtual AstItem* item() const;

        /**
         * Processes the error. If the error is enabled to be fixed, then
         * <code>fix</code> is invoked.
         */
        virtual void process();

    protected:
        
        /**
         * Returns the edit for this error, or NULL if none. By default, this
         * returns NULL.
         */
        virtual StringEdit* getEdit();

        /**
         * Processes the error.
         */
        virtual void fix();

        /**
         * Returns whether this type of error and edit need to be confirmed.
         */
        bool needsConfirmation();
        
        /**
         * Interactively asks the user whether to apply the given edit.
         */
        bool confirm(StringEdit* const edit);

        /**
         * Destructor.
         */
        virtual ~Error();

    private:

        /**
         * The item to which the error pertains.
         */
        AstItem* item_;

    };
}

#endif //! Error_h
