#ifndef HierarchyXMLPrinter_h
#define HierarchyXMLPrinter_h

#ifndef HierarchyPrinter_h
#include "HierarchyPrinter.h"
#endif


namespace doctorj
{
    class AstProject;
    class AstNode;
    class AstItem;
    class AstValue;

    class HierarchyXMLPrinter : public HierarchyPrinter 
    {
    public:
        HierarchyXMLPrinter();
        
        virtual ~HierarchyXMLPrinter();

        /**
         * Processes an AstProject.
         */
        virtual void process(AstProject* const p);

    protected:

        /**
         * Prints a node.
         */
        virtual void print(AstNode* const n, int level = 0);
    
        /**
         * Prints an item.
         */
        virtual void print(AstItem* const i, int level = 0);
    
    };
}

#endif //! HierarchyXMLPrinter_h
