#ifndef ExceptionDocumentationAnalyzer_h
#define ExceptionDocumentationAnalyzer_h

#ifndef JavadocAnalyzer_h
#include "JavadocAnalyzer.h"
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

#ifndef std_map
#define std_map
#include <map>
#endif

using namespace std;

namespace doctorj
{
    class AstNoncode;
    class AstTaggedComment;
    class AstTaggedDescribedComment;
    class AstThrowsNameList;

    /**
     * Analyzes exceptions (AKA throws).
     */
    class ExceptionDocumentationAnalyzer : public JavadocAnalyzer
    {
    public:

        /**
         * Default constructor.
         */
        ExceptionDocumentationAnalyzer(Reporter* const analyzer,
                                       AstNoncode* const noncode,
                                       AstModifierList* const modifiers,
                                       AstThrowsNameList* const throwsList);

        virtual ~ExceptionDocumentationAnalyzer();

        /**
         * Checks the @throws tag.
         */
        virtual void checkThrows(AstTaggedComment* const tc, const string& tag);

        /**
         * Checks the @exception tag.
         */
        virtual void checkException(AstTaggedComment* const tc);

        /**
         * Sets the status of the given throw (exception) to documented.
         */
        virtual void throwDocumented(AstTaggedDescribedComment* const thr,
                                     const string& name);

        /**
         * Returns whether the target of the given described tag comment exists
         * in the list of exceptions in the code.
         */
        virtual bool codeThrowExists(AstTaggedDescribedComment* const tdc,
                                     const string& tag);

        /**
         * Returns whether the target of the given described tag comment is a
         * misspelling of an exception in the list in the code.
         */
        virtual bool docThrowMisspelled(AstTaggedDescribedComment* const tdc,
                                        const string& tag);

        /**
         * Checks for undocumented throws (exceptions).
         */
        virtual void checkUndocumentedThrows();

    protected:

        typedef vector< pair< AstTaggedDescribedComment*, string > > DocumentedThrowsListType;

        /**
         * The leading noncode (whitespace and comments).
         */
        AstNoncode* noncode_;

        /**
         * The list of exceptions in the code.
         */
        AstThrowsNameList* const throwsList_;

        /**
         * The previous exception in the list in the documentation.
         */
        AstTaggedDescribedComment* lastDocThrow_;

        /**
         * Documented throws (exceptions) that were processed.
         */
        DocumentedThrowsListType throwsDocumented_;
        
    };
}

#endif //! ExceptionDocumentationAnalyzer_h
