#ifndef JavadocTags_h
#include "JavadocTags.h"
#endif

#ifndef DocDebug_h
#include "DocDebug.h"
#endif

#ifndef DocUserPreferences_h
#include "DocUserPreferences.h"
#endif

#ifndef iterext_h
#include "iterext.h"
#endif

using namespace doctorj;

const string JavadocTags::AUTHOR("@author");
const string JavadocTags::VERSION_("@version");
const string JavadocTags::PARAM("@param");
const string JavadocTags::RETURN("@return");
const string JavadocTags::EXCEPTION("@exception");
const string JavadocTags::THROWS("@throws");
const string JavadocTags::SEE("@see");
const string JavadocTags::SINCE("@since");
const string JavadocTags::SERIAL("@serial");
const string JavadocTags::SERIALDATA("@serialData");
const string JavadocTags::SERIALFIELD("@serialField");
const string JavadocTags::DEPRECATED("@deprecated");
const int JavadocTags::CUSTOM_TAG = 999;

JavadocTags::JavadocTags()
{
    add(AUTHOR,      0);
    add(VERSION_,    1);
    add(PARAM,       2);
    add(RETURN,      3);
    add(EXCEPTION,   4);
    add(THROWS,      4);
    add(SEE,         5);
    add(SINCE,       6);
    add(SERIAL,      7);
    add(SERIALDATA,  7);
    add(SERIALFIELD, 7);
    add(DEPRECATED,  8);

    DocUserPreferences* prefs = DocUserPreferences::get();
    EACH(vector<string>, prefs->userDefinedTags, uit) {
        string utag = *uit;
        add(utag, CUSTOM_TAG);
    }
}

JavadocTags::~JavadocTags()
{
}

void JavadocTags::add(const string& tag, int index)
{
    tags_.insert(make_pair(tag, index));
}

int JavadocTags::indexForTag(const string& tag) const
{
    StrIntMap::const_iterator pos = tags_.find(tag);
    if (pos == tags_.end()) {
        return -1;
    }
    else {
        DEBUG_DOCUMENTATION_ANALYZER(cout << "JavadocTags::indexForTag(" << tag << "): returning " << pos->second << endl);
        return pos->second;
    }
}

void JavadocTags::tagsAtIndex(int index, vector<string>* const tags) const
{
    StrIntMap::const_iterator stop = tags_.end();
    for (StrIntMap::const_iterator pos = tags_.begin(); pos != stop; ++pos) {
        if (pos->second == index) {
            tags->push_back(pos->first);
        }
    }
}

int JavadocTags::firstIndex() const
{
    return 0;
}

int JavadocTags::lastIndex() const
{
    return 8;
}

vector<string> JavadocTags::allTags() const
{
    vector<string> tags;
    StrIntMap::const_iterator stop = tags_.end();
    for (StrIntMap::const_iterator pos = tags_.begin(); pos != stop; ++pos) {
        tags.push_back(pos->first);
    }
    return tags;
}

vector<string> JavadocTags::getValidItemTags()
{
    vector<string> tags;
    tags.push_back(DEPRECATED);
    tags.push_back(SEE);
    tags.push_back(SINCE);
    return tags;
}

vector<string> JavadocTags::getValidConstructorTags()
{
    vector<string> tags = getValidItemTags();
    tags.push_back(PARAM);
    tags.push_back(EXCEPTION);
    tags.push_back(THROWS);
    tags.push_back(SERIALDATA);
    return tags;
}

vector<string> JavadocTags::getValidMethodTags()
{
    vector<string> tags = getValidItemTags();
    tags.push_back(PARAM);
    tags.push_back(EXCEPTION);
    tags.push_back(THROWS);
    tags.push_back(RETURN);
    tags.push_back(SERIALDATA);
    return tags;
}

vector<string> JavadocTags::getValidFieldTags()
{
    vector<string> tags = getValidItemTags();
    tags.push_back(SERIAL);
    tags.push_back(SERIALFIELD);
    return tags;
}

vector<string> JavadocTags::getValidInterfaceTags()
{
    vector<string> tags = getValidItemTags();
    tags.push_back(VERSION_);
    tags.push_back(AUTHOR);
    return tags;
}

vector<string> JavadocTags::getValidClassTags()
{
    return getValidInterfaceTags();
}
