#ifndef JavadocTags_h
#define JavadocTags_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_map
#define std_map
#include <map>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj 
{
    class JavadocTags
    {
    public:

        static const string AUTHOR;
        static const string VERSION_;
        static const string PARAM;
        static const string RETURN;
        static const string EXCEPTION;
        static const string THROWS;
        static const string SEE;
        static const string SINCE;
        static const string SERIAL;
        static const string SERIALDATA;
        static const string SERIALFIELD;
        static const string DEPRECATED;
        
        static const int CUSTOM_TAG;
        
        JavadocTags();

        virtual ~JavadocTags();

        /**
         * Returns the order that the tag should be within the list of tags, according
         * to the Javadoc spec.
         */
        int indexForTag(const string& tag) const;

        /**
         * Passes back the tags for the given index.
         */
        void tagsAtIndex(int index, vector<string>* const tags) const;

        /**
         * Returns the beginning index.
         */
        int firstIndex() const;

        /**
         * Returns the last index.
         */
        int lastIndex() const;

        /**
         * Returns all tags.
         */
        vector<string> allTags() const;

        /**
         * Returns the tags valid for any item.
         */
        static vector<string> getValidItemTags();

        /**
         * Returns the tags valid for a constructor.
         */
        static vector<string> getValidConstructorTags();

        /**
         * Returns the tags valid for a method.
         */
        static vector<string> getValidMethodTags();
             
        /**
         * Returns the tags valid for a field.
         */
        static vector<string> getValidFieldTags();

        /**
         * Returns the tags valid for an interface.
         */
        static vector<string> getValidInterfaceTags();

        /**
         * Returns the tags valid for a class.
         */
        static vector<string> getValidClassTags();
             
    protected:

        /**
         * Adds the given tag at the index.
         */
        void add(const string& tag, int index);

    private:

        typedef map<string, int> StrIntMap;

        /**
         * Maps from tags (as strings) to their index values.
         */
        StrIntMap tags_;

    };
}

#endif //! JavadocTags_h
