#ifndef MethodDocumentationAnalyzer_h
#define MethodDocumentationAnalyzer_h

#ifndef MethodCtorDocumentationAnalyzer_h
#include "MethodCtorDocumentationAnalyzer.h"
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

using namespace std;

namespace doctorj 
{
    class AstFormalParameterList;
    class AstItem;
    class AstMethodHeader;
    class AstModifierList;
    class AstNoncode;
    class AstTaggedComment;
    class AstThrowsNameList;
    class Reporter;

    class MethodDocumentationAnalyzer : public MethodCtorDocumentationAnalyzer 
    {
    public:
        /**
         * Checks the given code.
         */
        MethodDocumentationAnalyzer(Reporter* const reporter,
                                    AstMethodHeader* const header, 
                                    AstItem* const returnType,
                                    AstModifierList* const modifiers,
                                    AstFormalParameterList* const parameters,
                                    AstThrowsNameList* const throwsList);

        virtual ~MethodDocumentationAnalyzer();

        /**
         * What type of object we're analyzing--method.
         */
        virtual string type() const;

        /**
         * The identifier (subject) of what we're analyzing.
         */
        virtual AstItem* getSubject();

        /**
         * The parameters of what we're analyzing. NULL if no parameters.
         */
        virtual AstFormalParameterList* getFormalParameterList();

        /**
         * Checks that the return type was documented, if any.
         */
        virtual void checkUndocumentedReturn();

        /**
         * Complain about documenting a return type with a void return type.
         */
        virtual void checkReturn(AstTaggedComment* const tc);

        /**
         * Returns the noncode preceding the method.
         */
        virtual AstNoncode* leadingNoncode();

        /**
         * Creates the error for the usage of an invalid tag with a method.
         */
        virtual ErrorInvalidJavadocTag* makeUnknownTagError(AstItem* const item, 
                                                            const string& tag) const;
        
    private:

        AstMethodHeader* header_;
        
        AstItem* const returnType_;

        bool gotReturnDoc_;

    };
}

#endif //! MethodDocumentationAnalyzer_h
