#ifndef ParameterDocumentationAnalyzer_h
#define ParameterDocumentationAnalyzer_h

#ifndef JavadocAnalyzer_h
#include "JavadocAnalyzer.h"
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj 
{
    class AstFormalParameter;
    class AstFormalParameterList;
    class AstTaggedComment;
    class AstTaggedDescribedComment;

    enum ParamDocStatus {
        DOC_PARAM_NAME_MISSING              = 1 << 0,
        DOC_PARAM_DESCRIPTION_MISSING       = 1 << 1,
        DOC_PARAM_HAS_DESCRIPTION           = 1 << 2,
        DOC_PARAM_OK                        = 1 << 3,
        DOC_PARAM_USES_DATA_TYPE            = 1 << 4,
        DOC_PARAM_MISSPELLED                = 1 << 5,
        DOC_PARAM_REPEATED                  = 1 << 6,
        DOC_PARAM_MISORDERED                = 1 << 7,
        DOC_PARAM_MISORDERED_AND_MISSPELLED = 1 << 8,
        DOC_PARAM_NOT_IN_CODE               = 1 << 9,
        DOC_PARAMS_NOT_IN_CODE              = 1 << 10
    };

    /**
     * Analyzes parameters (AKA arguments).
     */
    class ParameterDocumentationAnalyzer : public JavadocAnalyzer 
    {
    public:

        /**
         * 
         */
        ParameterDocumentationAnalyzer(Reporter* const reporter, 
                                       AstModifierList* const modifiers,
                                       AstFormalParameterList* const args);

        virtual ~ParameterDocumentationAnalyzer();

        /**
         * Returns undocumented parameters.
         */
        virtual vector<AstFormalParameter*> getUndocumentedParams() const;

        /**
         * Returns the status of the parameter with regard to the documentation
         * (and vice versa). The int is comprised on ParamDocStatus values.
         */
        virtual int getParameterStatus(AstTaggedComment* const tc);
        
        /**
         * Returns the status of the parameter with regard to the documentation
         * (and vice versa). The int is comprised on ParamDocStatus values.
         */
        virtual int getParameterStatus(AstTaggedDescribedComment* const tdc);

        /**
         * Returns the current parameter, or NULL if none.
         */
        virtual AstFormalParameter* currentParameter();

    protected:

        /**
         * Returns whether the current parameter is a near match to the given
         * argument.
         */
        virtual bool nearMatch(const string& str1, const string& str2) const;
        

        /**
         * Looks through the parameter list in the code (AKA the arguments) for
         * a parameter matching the given name.
         */
        virtual AstFormalParameter* findArgumentByName(const string& name) const;

        /**
         * Looks through the parameter list in the code (AKA the arguments) for
         * the first parameter nearly matching the given name. Note that this
         * will return an exact match for the given name.
         */
        virtual AstFormalParameter* findArgumentByNameMisspelled(const string& name) const;

        /**
         * Sets the status of the given parameter (argument) to documented.
         */
        virtual void paramDocumented(const string& paramName);

        /**
         * Advances to the next parameter to be checked.
         */
        virtual void nextUndocumented();

        /**
         * Returns whether the given parameter name has been marked as
         * documented.
         */
        virtual bool isDocumented(const string& name) const;

        /**
         * The parameters (arguments) that were documented.
         */
        vector<string> paramsDocumented_;

        /**
         * The arguments (parameters) in the code.
         */
        AstFormalParameterList* arguments_;

        /**
         * The current parameter being analyzed, as an index in the formal
         * parameter list.
         */
        int currentParam_;

    };
}

#endif //! ParameterDocumentationAnalyzer_h
